/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import com.infomata.data.DataRow;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.CampLejeuneVerificationMethod;
import gov.va.med.esr.common.model.lookup.CampLejeuneChangeSource;
import gov.va.med.esr.common.model.lookup.CampLejeuneVerificationType;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.fw.io.AbstractRawFileDataContainer;
import gov.va.med.fw.io.ClassMapping;
import gov.va.med.fw.io.RawFileDataContainerUtils;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.lang.builder.ToStringBuilder;

public class CampLejeuneImportData
extends AbstractRawFileDataContainer {
    private static final long serialVersionUID = -8131081638932278722L;
    private static HashMap codeMap = new HashMap();
    private String firstName;
    private String lastName;
    private String ssn;
    private String dob;
    private String gender;
    private String cleIndicator;
    private String verifiedMethod;
    private String comments;
    private String clRegistrationDate;
    private String veteranIdentifiers = null;
    private String icn = "";
    private PersonIdentityTraits traits = null;
    private CampLejeuneVerification clv = null;

    protected void buildToString(ToStringBuilder builder) {
        builder.append("firstName", (Object)this.firstName);
        builder.append("lastName", (Object)this.lastName);
        builder.append("ssn", (Object)this.ssn);
        builder.append("dob", (Object)this.dob);
        builder.append("gender", (Object)this.gender);
        builder.append("cleIndicator", (Object)this.cleIndicator);
        builder.append("verifiedMethod", (Object)this.verifiedMethod);
        builder.append("comments", (Object)this.comments);
        builder.append("clRegistrationDate", (Object)this.clRegistrationDate);
        builder.append("icn", (Object)this.icn);
    }

    public void setRawFileData(String rawFileData, DataRow parsedRow, ClassMapping classMapping) throws Exception {
        this.lastName = StringUtils.stripToNull((String)parsedRow.getString(2));
        this.firstName = StringUtils.stripToNull((String)parsedRow.getString(3));
        this.ssn = StringUtils.stripToNull((String)parsedRow.getString(5));
        this.dob = StringUtils.stripToNull((String)parsedRow.getString(7));
        this.gender = StringUtils.stripToNull((String)parsedRow.getString(8));
        if (this.gender == null || this.gender.length() < 1) {
            this.gender = "M";
        }
        this.clRegistrationDate = StringUtils.stripToNull((String)parsedRow.getString(16));
        this.cleIndicator = StringUtils.stripToNull((String)parsedRow.getString(17));
        this.verifiedMethod = StringUtils.stripToNull((String)parsedRow.getString(18));
        this.comments = StringUtils.stripToNull((String)parsedRow.getString(25));
        String errMsg = this.isDataValid();
        if (!StringUtils.isEmpty((String)errMsg)) {
            throw new Exception("ERROR: Missing required data: " + errMsg);
        }
    }

    public String getVeteranIdentifiers() {
        return new StringBuffer(this.icn).append("|").append(this.firstName).append("|").append(this.lastName).append("|").append(this.ssn).append("|").append(this.dob).append("|").append(this.gender).toString();
    }

    public PersonIdentityTraits getPersonTraits(LookupService lookupService) throws ServiceException {
        if (this.traits == null) {
            this.traits = new PersonIdentityTraits();
            Name name = new Name();
            name.setFamilyName(this.getLastName());
            name.setGivenName(this.getFirstName());
            name.setType(lookupService.getNameTypeByCode(NameType.LEGAL_NAME.getName()));
            this.traits.addName(name);
            SSN ssn = new SSN();
            ssn.setSsnText(this.getSsn());
            ssn.setType(lookupService.getSSNTypeByCode(SSNType.CODE_ACTIVE.getName()));
            this.traits.setSsn(ssn);
            BirthRecord birthRecord = new BirthRecord();
            birthRecord.setBirthDate(new ImpreciseDate(this.getDob()));
            this.traits.setBirthRecord(birthRecord);
            if (this.getGender() != null) {
                this.traits.setGender(lookupService.getGenderByCode(this.getGender()));
            }
        }
        return this.traits;
    }

    public CampLejeuneVerification getCampLejeuneVerification(LookupService lookupService) throws ServiceException {
        if (this.clv == null) {
            this.clv = new CampLejeuneVerification();
            if ("Yes".equalsIgnoreCase(this.cleIndicator)) {
                this.clv.setSpecialFactorIndicator(lookupService.getIndicatorByCode(Indicator.YES));
            } else if ("No".equalsIgnoreCase(this.cleIndicator)) {
                this.clv.setSpecialFactorIndicator(lookupService.getIndicatorByCode(Indicator.NO));
            } else {
                this.clv.setSpecialFactorIndicator(null);
            }
            this.clv.setChangeSource(lookupService.getCampLejeuneChangeSourceByCode(CampLejeuneChangeSource.CODE_CLEAR.getCode()));
            this.clv.setChangeSite(lookupService.getVaFacilityByCode(VAFacility.CODE_HEC.getCode()));
            if (!StringUtils.isEmpty((String)this.verifiedMethod)) {
                List<String> clvms = this.getCodes(Arrays.asList(this.verifiedMethod.split(",")));
                for (String clvVMStr1 : clvms) {
                    CampLejeuneVerificationType clvtype1 = (CampLejeuneVerificationType)lookupService.getByCode(CampLejeuneVerificationType.class, clvVMStr1);
                    if (this.clv.getCampLejeuneMethodByType(clvtype1) != null) continue;
                    CampLejeuneVerificationMethod clvm = new CampLejeuneVerificationMethod();
                    clvm.setVerificationType(clvtype1);
                    this.clv.addCampLejeuneVerificationMethod(clvm);
                }
            }
            if (!StringUtils.isEmpty((String)this.comments)) {
                this.clv.setComments(StringUtils.replace((String)this.comments, (String)"^^^", (String)"|"));
            }
            if (!StringUtils.isEmpty((String)this.clRegistrationDate)) {
                this.clv.setRegistrationDate(new ImpreciseDate(StringUtils.replace((String)this.clRegistrationDate, (String)"-", (String)"")));
            }
        }
        return this.clv;
    }

    private List<String> getCodes(List<String> names) {
        if (names == null || names.size() == 0) {
            return null;
        }
        if (codeMap.size() == 0) {
            codeMap.put("DOD", "1");
            codeMap.put("NPRC", "2");
            codeMap.put("DPRIS", "3");
            codeMap.put("OMPF", "4");
            codeMap.put("USMC", "5");
            codeMap.put("CDC", "6");
            codeMap.put("OTHER", "7");
        }
        ArrayList<String> codes = new ArrayList<String>();
        Object code = null;
        for (String name : names) {
            codes.add((String)codeMap.get(name.toUpperCase()));
        }
        return codes;
    }

    public OrderedMap getRawFileData() throws Exception {
        return null;
    }

    private String isDataValid() {
        StringBuffer err = new StringBuffer();
        if (StringUtils.isEmpty((String)this.firstName)) {
            err.append("First Name is Missing! ");
        }
        if (StringUtils.isEmpty((String)this.lastName)) {
            err.append("Last Name is Missing! ");
        }
        if (StringUtils.isEmpty((String)this.ssn)) {
            err.append("SSN is Missing! ");
        }
        if (StringUtils.isEmpty((String)this.dob)) {
            err.append("Date of Birth is Missing! ");
        }
        if (StringUtils.isEmpty((String)this.gender)) {
            err.append("Gender is Missing! ");
        }
        return err.toString();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getSsn() {
        return this.ssn;
    }

    public void setSsn(String ssn) {
        this.ssn = ssn;
    }

    public String getDob() {
        return this.dob;
    }

    public void setDob(String dob) {
        this.dob = dob;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getCleIndicator() {
        return this.cleIndicator;
    }

    public void setCleIndicator(String cleIndicator) {
        this.cleIndicator = cleIndicator;
    }

    public String getVerifiedMethod() {
        return this.verifiedMethod;
    }

    public void setVerifiedMethod(String verifiedMethod) {
        this.verifiedMethod = verifiedMethod;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public String getClRegistrationDate() {
        return this.clRegistrationDate;
    }

    public void setClRegistrationDate(String clRegistrationDate) {
        this.clRegistrationDate = clRegistrationDate;
    }

    public String getIcn() {
        return this.icn;
    }

    public void setIcn(String icn) {
        this.icn = icn;
    }

    static {
        RawFileDataContainerUtils.autoRegisterConvertersForClass();
    }
}

