/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.fw.batchprocess.AbstractDataQueryProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import java.math.BigDecimal;
import java.util.List;

public class CVEndDateProcess
extends AbstractDataQueryProcess {
    private EligibilityEnrollmentService eligibilityEnrollmentService = null;

    protected void processData(DataProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("CV End Date batch process: Query result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        if (acquiredData == null) {
            return;
        }
        for (int i = 0; i < acquiredData.size(); ++i) {
            BigDecimal personId = (BigDecimal)acquiredData.get(i);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing person # " + (i + 1) + " with id = " + personId));
            }
            try {
                this.getEligibilityEnrollmentService().processCalculateEE(new PersonIdEntityKeyImpl(personId), true, true);
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                continue;
            }
            catch (Exception ex) {
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                String errMsg = "Error while executing CV End Date batch process for person " + personId;
                context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"CVEndDateProcess: Processing complete.");
            this.logger.debug((Object)("CVEndDateProcess: Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("CVEndDateProcess: Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    public EligibilityEnrollmentService getEligibilityEnrollmentService() {
        return this.eligibilityEnrollmentService;
    }

    public void setEligibilityEnrollmentService(EligibilityEnrollmentService eligibilityEnrollmentService) {
        this.eligibilityEnrollmentService = eligibilityEnrollmentService;
    }
}

