/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataQueryProcess;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataQueryProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import gov.va.med.fw.service.ServiceException;
import java.math.BigDecimal;
import java.util.List;

public class Add200ESRCorrelationBatchProcess
extends AbstractDataQueryProcess {
    private final String sql_getEnrollmentWithout200ESR = "SELECT ed.person_id as personId FROM enrollment_determination ed WHERE NOT EXISTS ( SELECT p.person_id FROM person p, ps_person_correlation pc WHERE p.person_id = ed.person_id AND p.vpid_id = pc.person_vpid_id AND pc.system_of_interest_type_id = 139)";
    private PersonService personService;

    protected void processData(DataProcessExecutionContext context, List acquiredData) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Add 200ESR Correlation batch process: result Size=" + (acquiredData == null ? 0 : acquiredData.size())));
        }
        Person person = null;
        BigDecimal personId = null;
        ProcessStatistics stats = context.getProcessStatistics();
        for (int i = 0; i < acquiredData.size() && !this.isInterrupted(context); ++i) {
            block6: {
                personId = (BigDecimal)acquiredData.get(i);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing person # " + (i + 1) + " with id = " + personId));
                }
                try {
                    person = this.personService.getPerson(new PersonIdEntityKeyImpl(personId));
                    this.personService.addESRCorrelation(person);
                    stats.incrementNumberOfSuccessfulRecords();
                }
                catch (ServiceException ex) {
                    stats.incrementNumberOfErrorRecords();
                    String errMsg = "Error while executing Add 200ESR Correlation batch process for person " + personId;
                    context.getExceptionData().add(errMsg + " Reason: " + ex.getMessage());
                    if (!this.logger.isWarnEnabled()) break block6;
                    this.logger.warn((Object)(errMsg + " Reason: "), (Throwable)ex);
                }
            }
            if (!stats.isTotalNumberMod(512)) continue;
            this.updateJobResult(context);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Add200ESRCorrelationBatchProcess: Processing of current batch complete.");
            this.logger.debug((Object)("Add200ESRCorrelationBatchProcess: Successful records count = " + context.getProcessStatistics().getNumberOfSuccessfulRecords()));
            this.logger.debug((Object)("Add200ESRCorrelationBatchProcess: Failure records count =" + context.getProcessStatistics().getNumberOfErrorRecords()));
        }
    }

    protected List doAcquireData(DataQueryProcessExecutionContext context) throws Exception {
        return this.getDao().executeSQLQuery("SELECT ed.person_id as personId FROM enrollment_determination ed WHERE NOT EXISTS ( SELECT p.person_id FROM person p, ps_person_correlation pc WHERE p.person_id = ed.person_id AND p.vpid_id = pc.person_vpid_id AND pc.system_of_interest_type_id = 139)", "ALTER SESSION FORCE PARALLEL QUERY");
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

