/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.batchprocess;

import gov.va.med.esr.common.batchprocess.ACAMailingResponseAddressFileData;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.comms.Correspondence;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.lookup.CorrespondenceStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.common.persistent.comms.CommsTemplateDAO;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.service.CorrespondenceService;
import gov.va.med.esr.service.DemographicService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.fw.batchprocess.AbstractDataFileSingleRowIncrementProcess;
import gov.va.med.fw.batchprocess.DataFileProcessExecutionContext;
import gov.va.med.fw.batchprocess.DataProcessExecutionContext;
import gov.va.med.fw.batchprocess.ProcessStatistics;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.apache.tools.ant.util.FileUtils;

public class ACAMailingResponseAddressFileProcess
extends AbstractDataFileSingleRowIncrementProcess {
    protected PersonService personService;
    private CorrespondenceService correspondenceService;
    private LookupService lookupService;
    private DemographicService demographicService;
    private CommsLogService commsLogService;
    private CommsTemplateDAO templDAO;
    private String rawData = null;
    ProcessStatistics stats;
    private String outputFileLocation;
    private Writer cpeWriter;
    private int cpeCount = 0;
    File cpeFile;

    public void processDataRecords(DataFileProcessExecutionContext context, List acquiredData) {
        if (acquiredData.isEmpty()) {
            this.logger.info((Object)"ACA Address File Response Job found no records");
            return;
        }
        if (this.stats == null) {
            this.stats = context.getProcessStatistics();
        }
        if (this.cpeWriter == null) {
            this.cpeFile = new File(this.getOutputFileLocation(), context.getCurrentFile().getName());
            this.cpeWriter = this.getOutputWriter(this.getOutputFileLocation(), context.getCurrentFile().getName());
            this.cpeCount = 0;
        }
        for (int i = 0; i < acquiredData.size(); ++i) {
            try {
                Object obj = acquiredData.get(i);
                if (this.processDataRecord(context, obj)) {
                    if (this.isKeepProcessedData()) {
                        context.getProcessedData().add(obj);
                        continue;
                    }
                    this.updateJobResultsLast(context);
                    continue;
                }
                this.updateJobResultsLast(context);
                break;
            }
            catch (RuntimeException e) {
                if (!this.logger.isErrorEnabled()) continue;
                this.logger.error((Object)("RuntimeException in ACA Address File processDataRecords^" + e.getMessage() + "^" + this.rawData));
            }
        }
    }

    private Writer getOutputWriter(String fileLocation, String fileName) {
        BufferedWriter output = null;
        try {
            File file = new File(fileLocation + fileName);
            output = new BufferedWriter(new FileWriter(file));
        }
        catch (IOException e) {
            throw new RuntimeException("ACA Address File Process is unable to generate file to CPE. File= " + fileLocation + fileName + "Exception: " + e);
        }
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processDataRecord(DataFileProcessExecutionContext context, Object bean) {
        ACAMailingResponseAddressFileData dataRecord = (ACAMailingResponseAddressFileData)((Object)bean);
        boolean success = true;
        this.rawData = context.getCurrentRowRawData();
        try {
            if (dataRecord.validateData().size() > 0) {
                List invalidData = dataRecord.validateData();
                String errMsg = "";
                for (int i = 0; i < invalidData.size(); ++i) {
                    errMsg = errMsg + "^" + (String)invalidData.get(i);
                }
                this.logger.error((Object)("ACA Address File Record Failed - Missing Required Fields: " + errMsg));
                this.stats.incrementNumberOfErrorRecords();
                return success;
            }
            if (dataRecord.getFormNumText().contains("801")) {
                Writer invalidData = this.cpeWriter;
                synchronized (invalidData) {
                    this.cpeWriter.write(dataRecord.getFormNumText() + "^" + dataRecord.getVPID() + "^" + dataRecord.getName() + "^" + dataRecord.getAddressline1() + "^" + dataRecord.getAddressline2() + "^" + dataRecord.getCity() + "^" + dataRecord.getState() + "^" + dataRecord.getZip() + "^" + dataRecord.getEmailaddress() + "^" + dataRecord.getDatemailed() + "\n");
                    this.cpeWriter.flush();
                    ++this.cpeCount;
                }
                context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                return true;
            }
            try {
                Person person;
                ComLetterTemplateType.Code formType;
                VPIDEntityKey key = CommonEntityKeyFactory.createVPIDEntityKey(dataRecord.getVPID());
                PersonIdEntityKey personkey = this.getPersonService().getPersonIdByVPID(key);
                if (personkey == null) {
                    throw new Exception("failed to retrieve person id by VPID in ACA Address File process");
                }
                if (dataRecord.getFormNumText().contains("800D")) {
                    formType = ComLetterTemplateType.FORM_NUMBER_800D;
                } else if (dataRecord.getFormNumText().contains("800A")) {
                    formType = ComLetterTemplateType.FORM_NUMBER_800A;
                } else {
                    throw new Exception("Unknown Form Type in ACA Address File Process:" + dataRecord.getFormNumText());
                }
                ArrayList<Correspondence> ltrResults = this.getCorrespondenceService().getSentPersonCorrespondence(new BigDecimal(personkey.getKeyValueAsString()), formType);
                ArrayList<Correspondence> formResults = this.getCorrespondenceService().getSentPersonCorrespondence(new BigDecimal(personkey.getKeyValueAsString()), ComLetterTemplateType.FORM_NUMBER_800);
                if ((formResults == null || formResults.isEmpty()) && (person = this.getPersonService().getPersonWithoutIdentityTraits(key)) != null) {
                    Correspondence ltr = new Correspondence(person);
                    SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = formatter.parse("2015-01-01");
                    ltr.setEffectiveDate(date);
                    this.getCorrespondenceService().triggerNewCMSCorrespondence(ltr, formType);
                    this.getCorrespondenceService().updateACACorrespondence(ltr, CorrespondenceStatus.MAILED_BY_CMS, null);
                    Correspondence form = new Correspondence(person);
                    form.setEffectiveDate(date);
                    this.getCorrespondenceService().triggerNewCMSCorrespondence(form, ComLetterTemplateType.FORM_NUMBER_800);
                    this.getCorrespondenceService().updateACACorrespondence(form, CorrespondenceStatus.MAILED_BY_CMS, null);
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                    return true;
                }
                Correspondence corr = null;
                Correspondence form = null;
                try {
                    if (ltrResults.size() == 1) {
                        corr = (Correspondence)((Object)ltrResults.get(0));
                    } else {
                        Collections.sort(ltrResults, new Comparator<Correspondence>(){

                            @Override
                            public int compare(Correspondence o1, Correspondence o2) {
                                return o1.getStatusDate().compareTo(o2.getStatusDate());
                            }
                        });
                        corr = (Correspondence)((Object)ltrResults.get(0));
                    }
                    if (formResults.size() == 1) {
                        form = (Correspondence)((Object)formResults.get(0));
                    } else {
                        Collections.sort(formResults, new Comparator<Correspondence>(){

                            @Override
                            public int compare(Correspondence o1, Correspondence o2) {
                                return o1.getStatusDate().compareTo(o2.getStatusDate());
                            }
                        });
                        form = (Correspondence)((Object)formResults.get(0));
                    }
                    this.getCorrespondenceService().updateACACorrespondence(corr, CorrespondenceStatus.MAILED_BY_CMS, null);
                    this.getCorrespondenceService().updateACACorrespondence(form, CorrespondenceStatus.MAILED_BY_CMS, null);
                    context.getProcessStatistics().incrementNumberOfSuccessfulRecords();
                }
                catch (Exception ex) {
                    if (corr != null) {
                        this.getCorrespondenceService().updateACACorrespondence(corr, CorrespondenceStatus.ENROLLMENT_REJECT, "Error Processing CMS Mailing Response. Mail Sent but Status is Unknown");
                    }
                    if (form != null) {
                        this.getCorrespondenceService().updateACACorrespondence(form, CorrespondenceStatus.ENROLLMENT_REJECT, "Error Processing CMS Mailing Response. Mail Sent but Status is Unknown");
                    }
                    throw new Exception("Failed to process ACA Address File update", ex);
                }
            }
            catch (Exception ex) {
                this.logger.error((Object)("Exception in ACA Address File Process " + ex));
                context.getProcessStatistics().incrementNumberOfErrorRecords();
                return true;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("processDataRecord in ACA Address File process- Exception processing data record: " + this.rawData), (Throwable)ex);
            context.getProcessStatistics().incrementNumberOfErrorRecords();
        }
        return success;
    }

    protected void handleDataProcessCompleted(DataProcessExecutionContext context) {
        try {
            if (this.cpeWriter != null) {
                this.cpeWriter.flush();
                this.cpeWriter.close();
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Unknown Exception in Process ACA Address File:" + ex.getMessage()));
        }
        if (this.cpeCount == 0 && this.cpeFile != null) {
            FileUtils.delete((File)this.cpeFile);
        }
        this.cpeWriter = null;
        super.handleDataProcessCompleted(context);
    }

    private void updateJobResultsLast(DataFileProcessExecutionContext context) {
        this.stats.setProcessingEndDate(new Date());
        this.updateJobResult((DataProcessExecutionContext)context);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.personService, (String)"personService is required");
        Validate.notNull((Object)this.correspondenceService, (String)"correspondenceService is required");
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public CorrespondenceService getCorrespondenceService() {
        return this.correspondenceService;
    }

    public void setCorrespondenceService(CorrespondenceService correspondenceService) {
        this.correspondenceService = correspondenceService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public DemographicService getDemographicService() {
        return this.demographicService;
    }

    public void setDemographicService(DemographicService demographicService) {
        this.demographicService = demographicService;
    }

    public CommsLogService getCommsLogService() {
        return this.commsLogService;
    }

    public void setCommsLogService(CommsLogService commsLogService) {
        this.commsLogService = commsLogService;
    }

    public CommsTemplateDAO getTemplDAO() {
        return this.templDAO;
    }

    public void setTemplDAO(CommsTemplateDAO templDAO) {
        this.templDAO = templDAO;
    }

    public String getOutputFileLocation() {
        return this.outputFileLocation;
    }

    public void setOutputFileLocation(String outputFileLocation) {
        this.outputFileLocation = outputFileLocation;
    }
}

