/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.soa.utils.security;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class EncryptionUtils {
    private static final String DS_KEYSTORE = "DSKey.store";
    private static final String DS_KEYSTOREFILE = "myDeliveryService.jks";
    public static final String SHA_PREFIX = "<SHA>";
    public static final String D3S_PREFIX = "{3DES}";
    private static final String ALGORITHM_ALIAS = "DESede";
    private static final String SECURITY_PROVIDER = "SunJCE";
    private static boolean isStandalone = false;
    private static Key cachedKey = null;
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$soa$utils$security$EncryptionUtils == null ? (class$gov$va$med$soa$utils$security$EncryptionUtils = EncryptionUtils.class$("gov.va.med.soa.utils.security.EncryptionUtils")) : class$gov$va$med$soa$utils$security$EncryptionUtils));
    static /* synthetic */ Class class$gov$va$med$soa$utils$security$EncryptionUtils;

    public static void main(String[] args) {
        isStandalone = false;
        String input = null;
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        int loop = -1;
        while (loop != 0) {
            try {
                String result;
                System.out.println("OPTIONS:");
                System.out.println("1 - Encrypt a string.");
                System.out.println("2 - Quit.");
                System.out.print("Select option: ");
                input = br.readLine();
                if (input.equals("-2")) {
                    EncryptionUtils.generateSymmetricKey(ALGORITHM_ALIAS, SECURITY_PROVIDER);
                    continue;
                }
                if (input.equals("1")) {
                    input = null;
                    System.out.print("Enter string to encrypt: ");
                    input = br.readLine();
                    result = EncryptionUtils.encrypt3DES(input);
                    System.out.println("\nEncrypted string: " + result + "\n");
                    continue;
                }
                if (input.equals("-1")) {
                    input = null;
                    System.out.print("Enter string to decrypt: ");
                    input = br.readLine();
                    result = EncryptionUtils.decrypt3DES(input);
                    System.out.println("\nDecrypted string: " + result + "\n");
                    continue;
                }
                if (input.equals("2")) {
                    System.out.println("\nEnd EncryptionUtils.\n");
                    System.exit(1);
                    continue;
                }
                System.out.println("EncryptionUtils:  Invalid selection.\n");
            }
            catch (Exception e) {
                System.out.println("The program has encountered an unrecoverable error. It will exit now: " + e.getMessage());
            }
        }
    }

    public static Key generateSymmetricKey(String algorithm, String provider) {
        SecretKey key = null;
        try {
            KeyGenerator kg = null;
            try {
                kg = KeyGenerator.getInstance(algorithm, provider);
            }
            catch (NoSuchProviderException nspe) {
                kg = KeyGenerator.getInstance(algorithm);
            }
            kg.init(168);
            key = kg.generateKey();
        }
        catch (NoSuchAlgorithmException nsae) {
            logger.error((Object)("No Such Algorithm: " + nsae.getMessage()));
        }
        return key;
    }

    private static Key get3DESKey() throws Exception {
        if (cachedKey == null) {
            String systemProperty = "";
            systemProperty = isStandalone ? System.getProperty(DS_KEYSTORE, System.getProperty("user.dir") + System.getProperty("file.separator") + DS_KEYSTOREFILE) : System.getProperty(DS_KEYSTORE);
            if (systemProperty != null && systemProperty.length() != 0) {
                systemProperty.replace('\\', '/');
                try {
                    FileInputStream keyStoreStream = new FileInputStream(systemProperty);
                    ObjectInputStream ois = new ObjectInputStream(keyStoreStream);
                    if (ois != null) {
                        cachedKey = (Key)ois.readObject();
                        ois.close();
                    }
                    logger.error((Object)("EncryptionUtils: Could not initialize the key from the keystore: " + systemProperty));
                }
                catch (Exception e) {
                    throw new Exception("EncryptionUtils: Could not read from the keystore: " + systemProperty, e);
                }
            } else {
                logger.error((Object)("EncryptionUtils: Could not initialize the keystore: " + systemProperty));
            }
        }
        return cachedKey;
    }

    public static String decrypt3DES(String credential) throws Exception {
        String decryptedCredential = "";
        if (credential != null && credential.indexOf(D3S_PREFIX, 0) == 0) {
            credential = credential.substring(D3S_PREFIX.length());
            Cipher unciph = Cipher.getInstance(ALGORITHM_ALIAS, SECURITY_PROVIDER);
            byte[] buf = new BASE64Decoder().decodeBuffer(credential);
            ByteArrayInputStream bais = new ByteArrayInputStream(buf);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CipherOutputStream cos_decrypted = new CipherOutputStream(baos, unciph);
            byte[] buffer_encrypted = new byte[8192];
            unciph.init(2, EncryptionUtils.get3DESKey());
            int length = 0;
            while ((length = bais.read(buffer_encrypted)) != -1) {
                cos_decrypted.write(buffer_encrypted, 0, length);
            }
            cos_decrypted.flush();
            cos_decrypted.close();
            decryptedCredential = baos.toString();
        } else {
            decryptedCredential = credential;
        }
        return decryptedCredential;
    }

    public static String encrypt3DES(String credential) throws Exception {
        String encryptedCredential = credential;
        if (credential != null && credential.length() > 0 && credential.indexOf(D3S_PREFIX, 0) != 0) {
            Cipher ciph = Cipher.getInstance(ALGORITHM_ALIAS, SECURITY_PROVIDER);
            byte[] inputBytes = credential.getBytes();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CipherOutputStream cos_encrypted = new CipherOutputStream(baos, ciph);
            ciph.init(1, EncryptionUtils.get3DESKey());
            for (int j = 0; j < inputBytes.length; ++j) {
                if (inputBytes[j] == 0) continue;
                cos_encrypted.write(inputBytes[j]);
            }
            cos_encrypted.flush();
            cos_encrypted.close();
            String s = new BASE64Encoder().encode(baos.toByteArray());
            encryptedCredential = D3S_PREFIX + s;
        }
        return encryptedCredential;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

