/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.soa.utils.enum;

import java.io.Serializable;

public class TechnologyType
implements Serializable {
    static final long serialVersionUID = 24140228177465668L;
    public static final int _UNKNOWN = -1;
    public static final int _JMS = 0;
    public static final int _EJB_REMOTE = 1;
    public static final int _EJB_LOCAL = 2;
    public static final int _POJO = 3;
    public static final int _WEB_SERVICE = 4;
    public static final int _VITRIA_BW = 5;
    private static final String _UNKNOWN_STR = "UNKNOWN";
    private static final String _JMS_STR = "JMS";
    private static final String _EJB_REMOTE_STR = "RemoteEJB";
    private static final String _EJB_LOCAL_STR = "LocalEJB";
    private static final String _POJO_STR = "POJO";
    private static final String _WEB_SERVICE_STR = "WebService";
    public static TechnologyType UNKNOWN = new TechnologyType(-1);
    public static TechnologyType JMS = new TechnologyType(0);
    public static TechnologyType EJB_REMOTE = new TechnologyType(1);
    public static TechnologyType EJB_LOCAL = new TechnologyType(2);
    public static TechnologyType POJO = new TechnologyType(3);
    public static TechnologyType WEB_SERVICE = new TechnologyType(4);
    private int currentTechnologyType;

    public TechnologyType() {
    }

    private TechnologyType(int technologyType) {
        this.currentTechnologyType = technologyType;
    }

    public String toString() {
        switch (this.currentTechnologyType) {
            case 0: {
                return _JMS_STR;
            }
            case 1: {
                return _EJB_REMOTE_STR;
            }
            case 2: {
                return _EJB_LOCAL_STR;
            }
            case 3: {
                return _POJO_STR;
            }
            case 4: {
                return _WEB_SERVICE_STR;
            }
        }
        return _UNKNOWN_STR;
    }

    public static TechnologyType fromInt(int technologyTypeID) {
        switch (technologyTypeID) {
            case 0: {
                return JMS;
            }
            case 1: {
                return EJB_REMOTE;
            }
            case 2: {
                return EJB_LOCAL;
            }
            case 3: {
                return POJO;
            }
            case 4: {
                return WEB_SERVICE;
            }
        }
        return UNKNOWN;
    }

    public static TechnologyType fromString(String technologyTypeDesc) {
        if (technologyTypeDesc == null) {
            return UNKNOWN;
        }
        if (technologyTypeDesc.equalsIgnoreCase(_JMS_STR)) {
            return JMS;
        }
        if (technologyTypeDesc.equalsIgnoreCase(_EJB_REMOTE_STR)) {
            return EJB_REMOTE;
        }
        if (technologyTypeDesc.equalsIgnoreCase(_EJB_LOCAL_STR)) {
            return EJB_LOCAL;
        }
        if (technologyTypeDesc.equalsIgnoreCase(_POJO_STR)) {
            return POJO;
        }
        if (technologyTypeDesc.equalsIgnoreCase(_WEB_SERVICE_STR)) {
            return WEB_SERVICE;
        }
        return UNKNOWN;
    }

    public int value() {
        return this.currentTechnologyType;
    }

    public boolean equals(Object reference) {
        if (!(reference instanceof TechnologyType)) {
            return false;
        }
        return this.value() == ((TechnologyType)reference).value();
    }

    public void setTechnologyType(int technologyType) {
        this.currentTechnologyType = technologyType;
    }

    public int getTechnologyType() {
        return this.currentTechnologyType;
    }
}

