/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.caip.client.location;

import gov.va.med.caip.client.config.BusinessDelegateDDInfo;
import gov.va.med.caip.client.config.NdsConnectionDDInfo;
import gov.va.med.caip.client.config.PerformanceMetricsInfo;
import gov.va.med.caip.client.exceptions.CaipInvocationException;
import gov.va.med.caip.client.location.ServiceFacade;
import gov.va.med.caip.client.location.ServiceFacadeJMSImpl;
import gov.va.med.caip.client.location.ServiceFacadeLocalEJBImpl;
import gov.va.med.caip.client.location.ServiceFacadeRemoteEJBImpl;
import gov.va.med.caip.client.location.ServiceFacadeWebServiceImpl;
import gov.va.med.caip.client.location.ServiceLocator;
import gov.va.med.caip.client.location.exception.CaipServiceLocatorException;
import gov.va.med.caip.client.location.exception.CaipServiceLocatorFinderException;
import gov.va.med.caip.client.utils.AuditTimerType;
import gov.va.med.caip.client.utils.CAIPAuditTimer;
import gov.va.med.namingdirectory.NamingDirectoryHome;
import gov.va.med.namingdirectory.NamingDirectoryRemote;
import gov.va.med.namingdirectory.exceptions.NdsServiceFinderException;
import gov.va.med.soa.utils.service.ServiceInfoRequestVO;
import gov.va.med.soa.utils.service.ServiceInfoVO;
import gov.va.med.soa.utils.service.ServiceLocationVO;
import gov.va.med.soa.utils.service.ServiceVersion;
import gov.va.med.soa.utils.service.ServiceVersionVO;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Properties;
import java.util.TreeMap;
import javax.ejb.CreateException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.apache.log4j.Logger;

public final class ServiceLocatorImpl
implements ServiceLocator {
    private static ServiceLocator _instance;
    private TreeMap _ndsConnectionDDInfoList;
    private InitialContext _initialContext = null;
    private NamingDirectoryHome _ndsLink;
    private HashMap _serviceCache = new HashMap();
    private HashMap _serviceLocationsCache = new HashMap();
    private static final Logger _log;
    static /* synthetic */ Class class$gov$va$med$caip$client$location$ServiceLocator;
    static /* synthetic */ Class class$javax$ejb$EJBLocalHome;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$jms$ConnectionFactory;
    static /* synthetic */ Class class$javax$jms$Destination;
    static /* synthetic */ Class class$gov$va$med$namingdirectory$NamingDirectoryHome;

    public static synchronized ServiceLocator getInstance(TreeMap ndsConnectionDDInfoList) {
        if (_instance == null) {
            _instance = new ServiceLocatorImpl(ndsConnectionDDInfoList);
        }
        return _instance;
    }

    private ServiceLocatorImpl(TreeMap ndsConnectionDDInfoList) {
        this._ndsConnectionDDInfoList = ndsConnectionDDInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceFacade getService(BusinessDelegateDDInfo info, ServiceVersion version, PerformanceMetricsInfo pmi, String site) throws CaipServiceLocatorException, CaipInvocationException {
        ServiceInfoRequestVO serviceInfo = new ServiceInfoRequestVO();
        ServiceVersionVO ndsVersion = new ServiceVersionVO(version.getMajorVersion(), version.getMinorVersion(), version.getRevisionNumber(), version.getBuildNumber());
        serviceInfo.setName(info.getImplementationClassName());
        serviceInfo.setVersion(ndsVersion);
        serviceInfo.setSignature(info.getSignature());
        serviceInfo.setApplication(info.getApplication());
        serviceInfo.setSite(site);
        ServiceFacade serviceEndpoint = null;
        HashMap hashMap = this._serviceCache;
        synchronized (hashMap) {
            HashMap hashMap2 = this._serviceLocationsCache;
            synchronized (hashMap2) {
                serviceEndpoint = (ServiceFacade)this._serviceCache.get(info.getDelegateId());
                if (serviceEndpoint == null) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Service not found in cache. Looking up. Key " + info.getDelegateId()));
                    }
                    serviceEndpoint = this.bindServiceEndpoint(serviceInfo, pmi, info);
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Service found in cache. Key " + info.getDelegateId()));
                }
            }
        }
        return serviceEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceFacade getServiceFailover(ServiceInfoVO serviceInfo, ServiceLocationVO serviceLocation, PerformanceMetricsInfo pmi) throws CaipServiceLocatorException, CaipInvocationException {
        HashMap hashMap = this._serviceCache;
        synchronized (hashMap) {
            HashMap hashMap2 = this._serviceLocationsCache;
            synchronized (hashMap2) {
                return this.bindToServiceEndpoint(serviceInfo, serviceLocation, pmi);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(String serviceKey) {
        HashMap hashMap = this._serviceCache;
        synchronized (hashMap) {
            ServiceFacade serviceEndpoint;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Removing service from cache. Key=" + serviceKey));
            }
            if ((serviceEndpoint = (ServiceFacade)this._serviceCache.get(serviceKey)) != null) {
                this._serviceCache.remove(serviceKey);
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Service was not present in cache to remove. Key=" + serviceKey));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceLocations(String serviceKey) {
        HashMap hashMap = this._serviceLocationsCache;
        synchronized (hashMap) {
            Object entry;
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Removing service locations from cache. Key=" + serviceKey));
            }
            if ((entry = this._serviceLocationsCache.get(serviceKey)) != null) {
                this._serviceLocationsCache.remove(serviceKey);
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)("Service was not present in locations cache to remove. Key=" + serviceKey));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ServiceFacade bindServiceEndpoint(ServiceInfoRequestVO serviceInfo, PerformanceMetricsInfo pmi, BusinessDelegateDDInfo info) throws CaipServiceLocatorException, CaipInvocationException {
        ServiceInfoVO ndsServiceList = null;
        CAIPAuditTimer timer = new CAIPAuditTimer(pmi, AuditTimerType.TIMER_NDS_LOOKUP, true);
        if (this._ndsConnectionDDInfoList == null || this._ndsConnectionDDInfoList.isEmpty()) {
            throw new CaipServiceLocatorException("Caip infrastucture has not been initialized or required configuration elements missing.");
        }
        try {
            try {
                ndsServiceList = this.callNDS(serviceInfo);
            }
            catch (Exception e) {
                throw new CaipServiceLocatorException("Error with Naming Directory.", e);
            }
            if (ndsServiceList.getLocations().size() == 0) {
                _log.error((Object)("No available service found in Naming directory. Request=" + serviceInfo.toString()));
                throw new CaipServiceLocatorFinderException("No available service not found in Naming directory.");
            }
            ndsServiceList.sortAvailableLocations();
        }
        finally {
            timer.stopAndLog(info);
        }
        return this.bindService(serviceInfo, pmi, ndsServiceList, info);
    }

    private ServiceFacade bindService(ServiceInfoRequestVO serviceInfo, PerformanceMetricsInfo pmi, ServiceInfoVO ndsServiceList, BusinessDelegateDDInfo info) throws CaipServiceLocatorException {
        int relativePriority;
        ServiceFacade serviceEndpoint = null;
        CaipServiceLocatorException sle = null;
        for (relativePriority = 0; serviceEndpoint == null && relativePriority < ndsServiceList.getLocations().size(); ++relativePriority) {
            ServiceLocationVO ndsServiceLocation = ndsServiceList.getServiceLocation(relativePriority);
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Attempting bind for relative priority " + relativePriority + " target=" + ndsServiceLocation.getTarget() + ". NDS priority=" + ndsServiceLocation.getPriority()));
            }
            if (ndsServiceList == null) continue;
            if (ndsServiceList.getTechnology().value() == 3) break;
            try {
                serviceEndpoint = this.bindToServiceEndpoint(ndsServiceList, ndsServiceLocation, pmi);
                sle = null;
                continue;
            }
            catch (CaipServiceLocatorException e) {
                try {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Attempt to bind to current target service failed. Retrying. " + ndsServiceLocation.getTarget()));
                    }
                    serviceEndpoint = this.bindToServiceEndpoint(ndsServiceList, ndsServiceLocation, pmi);
                    sle = null;
                    continue;
                }
                catch (CaipServiceLocatorException le) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Cannot bind to current target service after two attempts. " + ndsServiceLocation.getTarget()));
                    }
                    sle = le;
                }
            }
        }
        if (sle != null) {
            _log.error((Object)"Unable to bind to primary or alternate services.");
            throw sle;
        }
        if (relativePriority == 1) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Caching primary service endpoint. Key=" + info.getDelegateId()));
            }
            this._serviceCache.put(info.getDelegateId(), serviceEndpoint);
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Not caching service endpoint because it is not the primary. Key=" + info.getDelegateId()));
        }
        for (int i = 0; i < relativePriority; ++i) {
            ndsServiceList.removeServiceLocation(0);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Caching service locations. Key=" + info.getDelegateId()));
        }
        this._serviceLocationsCache.put(info.getDelegateId(), ndsServiceList);
        return serviceEndpoint;
    }

    private ServiceInfoVO callNDS(ServiceInfoRequestVO serviceInfo) throws CaipServiceLocatorFinderException {
        ServiceInfoVO ndsServiceList = null;
        ListIterator ndsLocationsIterator = new ArrayList(this._ndsConnectionDDInfoList.values()).listIterator();
        boolean keepTrying = true;
        Throwable savedException = null;
        while (keepTrying) {
            NamingDirectoryHome namingDirectoryHome;
            String errMsg = "Cannot connect to NDS. ";
            try {
                namingDirectoryHome = this.getNdsHome(ndsLocationsIterator);
            }
            catch (Exception e2) {
                Throwable e2;
                if (e2 instanceof CaipServiceLocatorException) {
                    errMsg = errMsg + "Previously found an NDS home, but either could not connect or call remote. ";
                    if (savedException != null) {
                        errMsg = errMsg + e2.toString();
                        e2 = savedException;
                    }
                } else if (savedException == null) {
                    errMsg = errMsg + "No NDS connection entries can be located.";
                } else {
                    errMsg = errMsg + "Can find NDS home, but either cannot connect or call remote";
                    e2 = savedException;
                }
                _log.error((Object)errMsg);
                throw new CaipServiceLocatorFinderException(errMsg, e2);
            }
            try {
                NamingDirectoryRemote namingDirectory = namingDirectoryHome.create();
                ndsServiceList = namingDirectory.retrieveService(serviceInfo);
                keepTrying = false;
                if (!ndsLocationsIterator.hasPrevious()) continue;
                this._ndsLink = null;
            }
            catch (CreateException e) {
                _log.error((Object)"Unable to make NDS remote connection.");
                this._ndsLink = null;
                savedException = e;
            }
            catch (RemoteException e) {
                _log.error((Object)("Unable to either make or use NDS remote connection. Request=" + serviceInfo.toString()));
                this._ndsLink = null;
                savedException = e;
            }
            catch (NdsServiceFinderException e) {
                errMsg = "No available service found in Naming directory. Request=" + serviceInfo.toString();
                _log.error((Object)errMsg);
                throw new CaipServiceLocatorFinderException(errMsg, e);
            }
        }
        return ndsServiceList;
    }

    private void logList(ServiceInfoVO serviceInfo) {
        for (int i = 0; i < serviceInfo.getLocations().size(); ++i) {
            ServiceLocationVO serviceLocation = serviceInfo.getServiceLocation(i);
            _log.debug((Object)("" + i + "=" + serviceLocation.getTarget() + " priority=" + serviceLocation.getPriority()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private ServiceFacade bindToServiceEndpoint(ServiceInfoVO serviceInfo, ServiceLocationVO serviceLocation, PerformanceMetricsInfo pmi) throws CaipServiceLocatorException {
        timer = new CAIPAuditTimer(pmi, AuditTimerType.TIMER_NARROW, true);
        serviceEndpoint /* !! */  = null;
        try {
            switch (serviceInfo.getTechnology().value()) {
                case 3: {
                    ** break;
lbl7:
                    // 1 sources

                    break;
                }
                case 2: {
                    initialContext = null;
                    ejbLocalHomeRefObject = null;
                    try {
                        initialContext = new InitialContext();
                        ejbLocalHomeRefObject = initialContext.lookup(serviceLocation.getLocation());
                        var10_19 = null;
                        ** if (initialContext == null) goto lbl-1000
                    }
                    catch (Throwable var9_31) {
                        var10_20 = null;
                        if (initialContext != null) {
                            try {
                                initialContext.close();
                            }
                            catch (NamingException e) {
                                ServiceLocatorImpl._log.warn((Object)("Could not close initial context for: " + serviceLocation.getLocation()), (Throwable)e);
                            }
                        }
                        throw var9_31;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            initialContext.close();
                        }
                        catch (NamingException e) {
                            ServiceLocatorImpl._log.warn((Object)("Could not close initial context for: " + serviceLocation.getLocation()), (Throwable)e);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        ** GOTO lbl36
                        catch (NamingException e) {
                            throw new CaipServiceLocatorException("Can not perform JNDI lookup for the service EJBLocalHome: " + serviceLocation.getLocation(), e);
                        }
                    }
lbl36:
                    // 2 sources

                    ejbLocalHomeRef = (EJBLocalHome)PortableRemoteObject.narrow((Object)ejbLocalHomeRefObject, (Class)(ServiceLocatorImpl.class$javax$ejb$EJBLocalHome == null ? (ServiceLocatorImpl.class$javax$ejb$EJBLocalHome = ServiceLocatorImpl.class$("javax.ejb.EJBLocalHome")) : ServiceLocatorImpl.class$javax$ejb$EJBLocalHome));
                    serviceEndpoint /* !! */  = new ServiceFacadeLocalEJBImpl(serviceInfo, ejbLocalHomeRef);
                    ** break;
lbl39:
                    // 1 sources

                    break;
                }
                case 1: {
                    initialContext = null;
                    ejbHomeRefObject = null;
                    try {
                        contextProps = new Properties();
                        contextProps.put("java.naming.factory.initial", serviceLocation.getProvider());
                        contextProps.put("java.naming.provider.url", serviceLocation.getUrl());
                        if (serviceLocation.getPrincipal() != null && !serviceLocation.getPrincipal().equals("")) {
                            contextProps.put("java.naming.security.principal", serviceLocation.getPrincipal());
                            if (serviceLocation.getCredential() != null && !serviceLocation.getCredential().equals("")) {
                                contextProps.put("java.naming.security.credentials", serviceLocation.getCredential());
                            }
                        }
                        initialContext = new InitialContext(contextProps);
                        ejbHomeRefObject = initialContext.lookup(serviceLocation.getLocation());
                        var13_33 = null;
                        ** if (initialContext == null) goto lbl-1000
                    }
                    catch (Throwable var12_37) {
                        var13_34 = null;
                        if (initialContext != null) {
                            try {
                                initialContext.close();
                            }
                            catch (NamingException e) {
                                ServiceLocatorImpl._log.warn((Object)("Could not close initial context for: " + serviceLocation.getLocation()), (Throwable)e);
                            }
                        }
                        throw var12_37;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            initialContext.close();
                        }
                        catch (NamingException e) {
                            ServiceLocatorImpl._log.warn((Object)("Could not close initial context for: " + serviceLocation.getLocation()), (Throwable)e);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        ** GOTO lbl79
                        catch (NamingException e) {
                            throw new CaipServiceLocatorException("Can not perform JNDI lookup for the service EJBHome: " + serviceLocation.getLocation(), e);
                        }
                    }
lbl79:
                    // 2 sources

                    ejbHomeRef = (EJBHome)PortableRemoteObject.narrow((Object)ejbHomeRefObject, (Class)(ServiceLocatorImpl.class$javax$ejb$EJBHome == null ? (ServiceLocatorImpl.class$javax$ejb$EJBHome = ServiceLocatorImpl.class$("javax.ejb.EJBHome")) : ServiceLocatorImpl.class$javax$ejb$EJBHome));
                    serviceEndpoint /* !! */  = new ServiceFacadeRemoteEJBImpl(serviceInfo, ejbHomeRef);
                    ** break;
lbl82:
                    // 1 sources

                    break;
                }
                case 0: {
                    initialContext = null;
                    connectionFactoryObject = null;
                    destinationObject = null;
                    contextProps = new Properties();
                    contextProps.put("java.naming.factory.initial", serviceLocation.getProvider());
                    contextProps.put("java.naming.provider.url", serviceLocation.getUrl());
                    if (serviceLocation.getPrincipal() != null && !serviceLocation.getPrincipal().equals("")) {
                        contextProps.put("java.naming.security.principal", serviceLocation.getPrincipal());
                        if (serviceLocation.getCredential() != null && !serviceLocation.getCredential().equals("")) {
                            contextProps.put("java.naming.security.credentials", serviceLocation.getCredential());
                        }
                    }
                    try {
                        initialContext = new InitialContext(contextProps);
                        connectionFactoryObject = initialContext.lookup(serviceLocation.getFactoryLocation());
                        destinationObject = initialContext.lookup(serviceLocation.getLocation());
                        var16_38 = null;
                        ** if (initialContext == null) goto lbl-1000
                    }
                    catch (Throwable var15_42) {
                        var16_39 = null;
                        if (initialContext != null) {
                            try {
                                initialContext.close();
                            }
                            catch (NamingException e) {
                                ServiceLocatorImpl._log.warn((Object)("Could not close initial context for: " + serviceLocation.getLocation()), (Throwable)e);
                            }
                        }
                        throw var15_42;
                    }
lbl-1000:
                    // 1 sources

                    {
                        try {
                            initialContext.close();
                        }
                        catch (NamingException e) {
                            ServiceLocatorImpl._log.warn((Object)("Could not close initial context for: " + serviceLocation.getLocation()), (Throwable)e);
                        }
                    }
lbl-1000:
                    // 2 sources

                    {
                        ** GOTO lbl124
                        catch (NamingException e) {
                            throw new CaipServiceLocatorException("Can not perform JNDI lookup for the service JMS: " + serviceLocation.getLocation(), e);
                        }
                    }
lbl124:
                    // 2 sources

                    connectionFactory = (ConnectionFactory)PortableRemoteObject.narrow((Object)connectionFactoryObject, (Class)(ServiceLocatorImpl.class$javax$jms$ConnectionFactory == null ? (ServiceLocatorImpl.class$javax$jms$ConnectionFactory = ServiceLocatorImpl.class$("javax.jms.ConnectionFactory")) : ServiceLocatorImpl.class$javax$jms$ConnectionFactory));
                    destination = (Destination)PortableRemoteObject.narrow((Object)destinationObject, (Class)(ServiceLocatorImpl.class$javax$jms$Destination == null ? (ServiceLocatorImpl.class$javax$jms$Destination = ServiceLocatorImpl.class$("javax.jms.Destination")) : ServiceLocatorImpl.class$javax$jms$Destination));
                    serviceEndpoint /* !! */  = new ServiceFacadeJMSImpl(serviceInfo, connectionFactory, destination);
                    ** break;
lbl128:
                    // 1 sources

                    break;
                }
                case 4: {
                    try {
                        proxyClass = Class.forName(serviceLocation.getProvider());
                        proxyObject = proxyClass.newInstance();
                        serviceEndpoint /* !! */  = new ServiceFacadeWebServiceImpl(serviceInfo, serviceLocation.getUrl(), proxyObject);
                        ** break;
lbl135:
                        // 1 sources

                        break;
                    }
                    catch (ClassNotFoundException e) {
                        throw new CaipServiceLocatorException("Cannot load proxy class: " + serviceLocation.getProvider(), e);
                    }
                    catch (InstantiationException e) {
                        throw new CaipServiceLocatorException("Cannot load proxy class: " + serviceLocation.getProvider(), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new CaipServiceLocatorException("Cannot load proxy class: " + serviceLocation.getProvider(), e);
                    }
                    catch (MalformedURLException e) {
                        throw new CaipServiceLocatorException("The Web Service URL is not formatted properly: " + serviceLocation.getLocation(), e);
                    }
                }
                default: {
                    buf = new StringBuffer("Service TechnologyType ");
                    buf.append(serviceInfo.getTechnology().toString());
                    buf.append(" of ");
                    buf.append(serviceInfo.getName());
                    buf.append(", is not currently supported.");
                    throw new CaipServiceLocatorException(buf.toString());
                }
            }
        }
        finally {
            timer.stopAndLog(serviceInfo);
        }
        return serviceEndpoint /* !! */ ;
    }

    private synchronized NamingDirectoryHome getNdsHome(ListIterator ndsLocationsIterator) throws CaipServiceLocatorException {
        if (this._ndsLink != null) {
            return this._ndsLink;
        }
        while (ndsLocationsIterator.hasNext()) {
            NdsConnectionDDInfo ndsInfo = null;
            try {
                ndsInfo = (NdsConnectionDDInfo)ndsLocationsIterator.next();
                this._ndsLink = (NamingDirectoryHome)PortableRemoteObject.narrow((Object)this.lookupNdsHomeReference(ndsInfo), (Class)(class$gov$va$med$namingdirectory$NamingDirectoryHome == null ? (class$gov$va$med$namingdirectory$NamingDirectoryHome = ServiceLocatorImpl.class$("gov.va.med.namingdirectory.NamingDirectoryHome")) : class$gov$va$med$namingdirectory$NamingDirectoryHome));
                break;
            }
            catch (Exception e) {
                if (ndsLocationsIterator.hasNext()) {
                    _log.info((Object)("Unable to connect to current NDS target; values=" + ((Object)ndsInfo).toString() + ". Trying alternate. Exception=" + e.toString()));
                    continue;
                }
                String errMsg = "Unable to connect to NDS. No more targets to try. Current target value=" + ((Object)ndsInfo).toString();
                _log.error((Object)errMsg);
                throw new CaipServiceLocatorException(errMsg, e);
            }
        }
        if (this._ndsLink == null) {
            String msg = "Cannot obtain NDS home. No more NDS targets to try.";
            _log.error((Object)msg);
            throw new CaipServiceLocatorException(msg);
        }
        return this._ndsLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object lookupNdsHomeReference(NdsConnectionDDInfo ndsInfo) throws NamingException, CaipServiceLocatorException {
        _log.debug((Object)("Connecting to NDS at URL " + ndsInfo.getUrl() + ", name " + ndsInfo.getName() + " , priority=" + ndsInfo.getPriority()));
        InitialContext initialContext = null;
        Object serviceReference = null;
        if (initialContext != null) return serviceReference;
        try {
            Properties contextProps = new Properties();
            contextProps.put("java.naming.factory.initial", ndsInfo.getProvider());
            contextProps.put("java.naming.provider.url", ndsInfo.getUrl());
            contextProps.put("java.naming.security.principal", ndsInfo.getUser());
            contextProps.put("java.naming.security.credentials", ndsInfo.getPassWord());
            initialContext = new InitialContext(contextProps);
            serviceReference = initialContext.lookup(ndsInfo.getName());
            Object var6_5 = null;
            if (initialContext == null) return serviceReference;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (initialContext == null) throw throwable;
            try {
                _log.debug((Object)("lookupNdsHomeReference - Close initial context for: " + ndsInfo.getUrl()));
                initialContext.close();
                throw throwable;
            }
            catch (NamingException e) {
                _log.warn((Object)("Could not close initial context for: " + ndsInfo.getUrl() + ", name " + ndsInfo.getName() + " , priority=" + ndsInfo.getPriority()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            _log.debug((Object)("lookupNdsHomeReference - Close initial context for: " + ndsInfo.getUrl()));
            initialContext.close();
            return serviceReference;
        }
        catch (NamingException e) {
            _log.warn((Object)("Could not close initial context for: " + ndsInfo.getUrl() + ", name " + ndsInfo.getName() + " , priority=" + ndsInfo.getPriority()), (Throwable)e);
        }
        return serviceReference;
    }

    public ServiceInfoVO getServiceLocations(String serviceKey) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Getting cached service locations for key " + serviceKey));
        }
        return (ServiceInfoVO)this._serviceLocationsCache.get(serviceKey);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _log = Logger.getLogger((Class)(class$gov$va$med$caip$client$location$ServiceLocator == null ? (class$gov$va$med$caip$client$location$ServiceLocator = ServiceLocatorImpl.class$("gov.va.med.caip.client.location.ServiceLocator")) : class$gov$va$med$caip$client$location$ServiceLocator));
    }
}

