/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.caip.client.location;

import gov.va.med.caip.client.exceptions.CaipInvocationException;
import gov.va.med.caip.client.location.ServiceFacadeImpl;
import gov.va.med.caip.client.location.ServiceFacadeJMS;
import gov.va.med.soa.utils.service.ServiceInfo;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;

public class ServiceFacadeJMSImpl
extends ServiceFacadeImpl
implements ServiceFacadeJMS {
    protected ConnectionFactory connectionFactory;
    protected Connection conn;
    protected Session session;
    protected Destination destination;

    public ServiceFacadeJMSImpl(ServiceInfo serviceInfo, ConnectionFactory factory, Destination destination) throws CaipInvocationException {
        super(serviceInfo);
        this.connectionFactory = factory;
        this.destination = destination;
        this.initSession();
    }

    private void initSession() throws CaipInvocationException {
        block4: {
            try {
                if (this.connectionFactory instanceof QueueConnectionFactory) {
                    QueueConnectionFactory qcf = (QueueConnectionFactory)this.connectionFactory;
                    QueueConnection qc = qcf.createQueueConnection();
                    this.conn = qc;
                    this.session = qc.createQueueSession(false, 1);
                    break block4;
                }
                if (this.connectionFactory instanceof TopicConnectionFactory) {
                    TopicConnectionFactory tcf = (TopicConnectionFactory)this.connectionFactory;
                    TopicConnection tc = tcf.createTopicConnection();
                    this.conn = tc;
                    this.session = tc.createTopicSession(false, 1);
                    break block4;
                }
                throw new CaipInvocationException("Invalid JMS Connection Factory");
            }
            catch (JMSException e) {
                throw new CaipInvocationException(e);
            }
        }
    }

    public Destination getDestination() {
        return this.destination;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public Session getSession() {
        return this.session;
    }
}

