/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.caip.client.factory;

import gov.va.med.caip.client.businessdelegate.BusinessDelegate;
import gov.va.med.caip.client.businessdelegate.BusinessDelegateInfo;
import gov.va.med.caip.client.businessdelegate.BusinessDelegateJMS;
import gov.va.med.caip.client.businessdelegate.BusinessDelegateLocalEJB;
import gov.va.med.caip.client.businessdelegate.BusinessDelegateRemoteEJB;
import gov.va.med.caip.client.businessdelegate.BusinessDelegateWebService;
import gov.va.med.caip.client.config.BusinessDelegateDDInfo;
import gov.va.med.caip.client.config.CaipConfiguration;
import gov.va.med.caip.client.config.CaipConfigurator;
import gov.va.med.caip.client.exceptions.CaipAlreadyConfiguredException;
import gov.va.med.caip.client.exceptions.CaipConfigurationFileNotFoundException;
import gov.va.med.caip.client.exceptions.CaipDelegateNoServiceException;
import gov.va.med.caip.client.exceptions.CaipDelegateNotFoundException;
import gov.va.med.caip.client.exceptions.CaipException;
import gov.va.med.caip.client.exceptions.CaipNotConfiguredException;
import gov.va.med.caip.client.exceptions.DelegateNotCaipCompatibleException;
import gov.va.med.caip.client.factory.ConfigData;
import gov.va.med.caip.client.factory.DelegateProxy;
import gov.va.med.caip.client.location.ServiceFacade;
import gov.va.med.caip.client.location.ServiceFacadeJMS;
import gov.va.med.caip.client.location.ServiceFacadeLocalEJB;
import gov.va.med.caip.client.location.ServiceFacadeRemoteEJB;
import gov.va.med.caip.client.location.ServiceFacadeWebService;
import gov.va.med.caip.client.location.ServiceLocator;
import gov.va.med.caip.client.location.ServiceLocatorImpl;
import gov.va.med.caip.client.location.exception.CaipServiceLocatorFinderException;
import gov.va.med.caip.client.utils.AuditTimerType;
import gov.va.med.caip.client.utils.CAIPAuditTimer;
import gov.va.med.soa.utils.enum.TechnologyType;
import gov.va.med.soa.utils.exceptions.ExceptionUtils;
import gov.va.med.soa.utils.service.ServiceInfoVO;
import gov.va.med.soa.utils.service.ServiceLocationVO;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public final class BusinessDelegateFactory {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$caip$client$factory$BusinessDelegateFactory == null ? (class$gov$va$med$caip$client$factory$BusinessDelegateFactory = BusinessDelegateFactory.class$("gov.va.med.caip.client.factory.BusinessDelegateFactory")) : class$gov$va$med$caip$client$factory$BusinessDelegateFactory));
    private static final String defaultCaipConfigFileName = "myCaipConfig.xml";
    private static ConfigData configData = new ConfigData();
    static /* synthetic */ Class class$gov$va$med$caip$client$factory$BusinessDelegateFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void passiveConfigureCaip() {
        block17: {
            try {
                logger.error((Object)"Initializing Business Delegate Factory...");
                FileInputStream caipConfigStream = null;
                String caipConfigPropName = defaultCaipConfigFileName;
                String systemProperty = System.getProperty(caipConfigPropName);
                if (systemProperty == null || systemProperty.length() == 0) {
                    logger.error((Object)("passiveConfigureCaip - system property [" + caipConfigPropName + "] is either not set, or is set to the empty string."));
                } else {
                    systemProperty.replace('\\', '/');
                    caipConfigStream = new FileInputStream(systemProperty);
                }
                if (caipConfigStream != null) {
                    block16: {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Found default caipConfig.xml in the classpath - configuring at the class load time.");
                        }
                        try {
                            BusinessDelegateFactory.configureCaip(caipConfigStream);
                        }
                        catch (CaipConfigurationFileNotFoundException e) {
                            if (logger.isEnabledFor(Priority.ERROR)) {
                                String errMsg = "Cannot configure CAIP during FactoryInitialization, due to file not found." + "\n\t" + ExceptionUtils.getFullStackTrace(e);
                                logger.error((Object)errMsg);
                            }
                        }
                        catch (CaipAlreadyConfiguredException e) {
                            if (logger.isEnabledFor(Priority.ERROR)) {
                                String errMsg = "Can CAIP FactoryInitialization, already done." + "\n\t" + ExceptionUtils.getFullStackTrace(e);
                                logger.error((Object)errMsg);
                            }
                        }
                        catch (CaipException e) {
                            if (!logger.isEnabledFor(Priority.ERROR)) break block16;
                            String errMsg = "Cannot configure CAIP during FactoryInitialization." + "\n\t" + ExceptionUtils.getFullStackTrace(e);
                            logger.error((Object)errMsg);
                        }
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Finished configuring CAIP at the class load time.");
                    }
                    ConfigData configData = BusinessDelegateFactory.configData;
                    synchronized (configData) {
                        BusinessDelegateFactory.configData.setCaipConfiguredByClient(false);
                        break block17;
                    }
                }
                logger.error((Object)"Did not find default myCaipConfig.xml in the classpath at the class load time. Application will need to configure CAIP implicitly.");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureCaip(InputStream caipConfig) throws CaipAlreadyConfiguredException, CaipConfigurationFileNotFoundException, CaipNotConfiguredException, CaipException {
        ConfigData configData = BusinessDelegateFactory.configData;
        synchronized (configData) {
            CAIPAuditTimer timer = new CAIPAuditTimer(null, AuditTimerType.TIMER_CONFIG, true);
            try {
                if (BusinessDelegateFactory.configData.isCaipConfiguredByClient()) {
                    throw new CaipAlreadyConfiguredException("Caip BusinessDelegateFactory has been already configured.");
                }
                if (caipConfig == null) {
                    throw new CaipConfigurationFileNotFoundException("Provided caipConfig InputStream == null. Please provide appropriate input stream.");
                }
                CaipConfiguration caipConfiguration = CaipConfigurator.doConfigureCaip(caipConfig);
                BusinessDelegateFactory.configData.setClientBDDescriptorCache(caipConfiguration.getBusinessDelegates());
                BusinessDelegateFactory.configData.setNdsConnectionDDInfoList(caipConfiguration.getNdsConnectionDDInfoList());
                BusinessDelegateFactory.configData.setPerformanceMetricsInfo(caipConfiguration.getPerformanceMetricsInfo());
                BusinessDelegateFactory.configData.setSite(caipConfiguration.getSite());
                timer.setPerformaceMetricsInfo(BusinessDelegateFactory.configData.getPerformanceMetricsInfo());
                BusinessDelegateFactory.configData.setCaipConfiguredByClient(true);
                BusinessDelegateFactory.configData.setCaipConfigured(true);
            }
            catch (CaipException e) {
                throw new CaipNotConfiguredException(e);
            }
            finally {
                timer.stopAndLog();
            }
        }
    }

    public static void configureCaip(String fileName) throws CaipAlreadyConfiguredException, CaipConfigurationFileNotFoundException, CaipException {
        FileInputStream fileInStr;
        try {
            fileInStr = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            String errMsg = "Provided caipConfig fileName " + fileName + " is not found. Please provide appropriate input stream.";
            throw new CaipConfigurationFileNotFoundException(errMsg, e);
        }
        BusinessDelegateFactory.configureCaip(fileInStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCaipConfigurationCache() {
        ConfigData configData = BusinessDelegateFactory.configData;
        synchronized (configData) {
            BusinessDelegateFactory.configData.setCaipConfigured(false);
            BusinessDelegateFactory.configData.setCaipConfiguredByClient(false);
            BusinessDelegateFactory.configData.setClientBDDescriptorCache(new HashMap());
            BusinessDelegateFactory.configData.setNdsConnectionDDInfoList(new TreeMap());
            BusinessDelegateFactory.configData.setPerformanceMetricsInfo(null);
            BusinessDelegateFactory.configData.setSite("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCaipConfigured() {
        ConfigData configData = BusinessDelegateFactory.configData;
        synchronized (configData) {
            return BusinessDelegateFactory.configData.isCaipConfigured();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCaipConfiguredByClient() {
        ConfigData configData = BusinessDelegateFactory.configData;
        synchronized (configData) {
            return BusinessDelegateFactory.configData.isCaipConfiguredByClient();
        }
    }

    public static BusinessDelegate getBusinessDelegate(Class delegate) throws CaipNotConfiguredException, CaipDelegateNotFoundException, DelegateNotCaipCompatibleException, CaipDelegateNoServiceException, CaipException {
        return BusinessDelegateFactory.getBusinessDelegate(delegate.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BusinessDelegate getBusinessDelegate(String delegateId) throws CaipNotConfiguredException, CaipDelegateNotFoundException, DelegateNotCaipCompatibleException, CaipDelegateNoServiceException, CaipException {
        if (!BusinessDelegateFactory.isCaipConfigured()) {
            throw new CaipNotConfiguredException("CAIP is not Configured.  Use configureCaip() method first or provide default myCaipConfig.xml file in the classpath");
        }
        BusinessDelegate businessDelegate = null;
        BusinessDelegateDDInfo businessDelegateDDInfo = null;
        ConfigData configData = BusinessDelegateFactory.configData;
        synchronized (configData) {
            HashMap clientBDDescriptorCache = BusinessDelegateFactory.configData.getClientBDDescriptorCache();
            businessDelegateDDInfo = (BusinessDelegateDDInfo)clientBDDescriptorCache.get(delegateId);
        }
        if (businessDelegateDDInfo == null) {
            throw new CaipDelegateNotFoundException("No entry for business delegate " + delegateId + " in configuration file. ");
        }
        businessDelegate = BusinessDelegateFactory.getDelegateInstance(businessDelegateDDInfo);
        return businessDelegate;
    }

    private static Class getDelegateClass(BusinessDelegateDDInfo businessDelegateDDInfo) throws ClassNotFoundException {
        Class<?> oClass = null;
        ClassLoader oClassLoader = (class$gov$va$med$caip$client$factory$BusinessDelegateFactory == null ? (class$gov$va$med$caip$client$factory$BusinessDelegateFactory = BusinessDelegateFactory.class$("gov.va.med.caip.client.factory.BusinessDelegateFactory")) : class$gov$va$med$caip$client$factory$BusinessDelegateFactory).getClassLoader();
        try {
            oClass = oClassLoader.loadClass(businessDelegateDDInfo.getImplementationClassName());
        }
        catch (ClassNotFoundException e) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)"Could not find delegate class in CAIP classpath. Checking Thread's context loader.");
            }
            oClassLoader = Thread.currentThread().getContextClassLoader();
            oClass = oClassLoader.loadClass(businessDelegateDDInfo.getImplementationClassName());
        }
        return oClass;
    }

    private static BusinessDelegate getDelegateInstance(BusinessDelegateDDInfo businessDelegateDDInfo) throws CaipDelegateNotFoundException, DelegateNotCaipCompatibleException, CaipNotConfiguredException, CaipDelegateNoServiceException, CaipException {
        BusinessDelegate businessDelegate = BusinessDelegateFactory.instantiateDelegate(businessDelegateDDInfo);
        BusinessDelegateFactory.narrowService(businessDelegateDDInfo, businessDelegate);
        return businessDelegate;
    }

    private static BusinessDelegate instantiateDelegate(BusinessDelegateDDInfo businessDelegateDDInfo) throws CaipDelegateNotFoundException, DelegateNotCaipCompatibleException {
        BusinessDelegate businessDelegate = null;
        try {
            Class bdImplClass = BusinessDelegateFactory.getDelegateClass(businessDelegateDDInfo);
            Object bdObject = DelegateProxy.newInstance((BusinessDelegate)bdImplClass.newInstance(), businessDelegateDDInfo, configData.getPerformanceMetricsInfo());
            businessDelegate = (BusinessDelegate)bdObject;
        }
        catch (ClassNotFoundException e) {
            throw new CaipDelegateNotFoundException("Cannot load CAIP Delegate Implementation Class " + businessDelegateDDInfo.getImplementationClassName(), e);
        }
        catch (NoClassDefFoundError e) {
            throw new CaipDelegateNotFoundException("Cannot load CAIP Delegate Implementation Class " + businessDelegateDDInfo.getImplementationClassName(), e);
        }
        catch (ClassCastException e) {
            String msg = "CAIP Delegate Implementation Class  " + businessDelegateDDInfo.getImplementationClassName() + " does not implement CAIP compliant BusinessDelegate Interface";
            throw new DelegateNotCaipCompatibleException(msg);
        }
        catch (InstantiationException e) {
            throw new CaipDelegateNotFoundException("Cannot load CAIP Delegate Implementation Class " + businessDelegateDDInfo.getImplementationClassName(), e);
        }
        catch (IllegalAccessException e) {
            throw new CaipDelegateNotFoundException("Cannot load CAIP Delegate Implementation Class " + businessDelegateDDInfo.getImplementationClassName(), e);
        }
        return businessDelegate;
    }

    private static ServiceInfoVO narrowService(BusinessDelegateDDInfo businessDelegateDDInfo, BusinessDelegate businessDelegate) throws CaipDelegateNoServiceException, CaipException {
        ServiceLocator serviceLocator = null;
        try {
            BusinessDelegateInfo bdInfo = businessDelegate.getBusinessDelegateInterfaceInfo();
            if (TechnologyType.POJO.equals(businessDelegateDDInfo.getTechnologyType())) {
                return null;
            }
            serviceLocator = BusinessDelegateFactory.getServiceLocator();
            ServiceFacade serviceEndpoint = null;
            serviceEndpoint = serviceLocator.getService(businessDelegateDDInfo, bdInfo.getVersion(), configData.getPerformanceMetricsInfo(), configData.getSite());
            BusinessDelegateFactory.populateServiceFacade(businessDelegate, serviceEndpoint);
        }
        catch (CaipServiceLocatorFinderException e) {
            throw new CaipDelegateNoServiceException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new CaipException(e.getMessage(), e);
        }
        return serviceLocator.getServiceLocations(businessDelegateDDInfo.getDelegateId());
    }

    private static void narrowServiceFailover(ServiceInfoVO serviceInfo, ServiceLocationVO serviceLocation, BusinessDelegate businessDelegate, BusinessDelegateDDInfo bdInfo) throws CaipDelegateNoServiceException, CaipException {
        ServiceLocator serviceLocator = null;
        try {
            serviceLocator = BusinessDelegateFactory.getServiceLocator();
            ServiceFacade serviceEndpoint = serviceLocator.getServiceFailover(serviceInfo, serviceLocation, configData.getPerformanceMetricsInfo());
            BusinessDelegateFactory.populateServiceFacade(businessDelegate, serviceEndpoint);
        }
        catch (CaipServiceLocatorFinderException e) {
            throw new CaipDelegateNoServiceException(e.getMessage(), e);
        }
        catch (Exception e) {
            throw new CaipException(e.getMessage(), e);
        }
    }

    private static void populateServiceFacade(BusinessDelegate businessDelegate, ServiceFacade serviceEndpoint) throws CaipException, CaipDelegateNoServiceException {
        switch (serviceEndpoint.getServiceInfo().getTechnology().value()) {
            case 2: {
                ServiceFacadeLocalEJB serviceEndpointLocalEJB = (ServiceFacadeLocalEJB)serviceEndpoint;
                BusinessDelegateLocalEJB businessDelegateLocalEJB = (BusinessDelegateLocalEJB)businessDelegate;
                businessDelegateLocalEJB.setServiceFacade(serviceEndpointLocalEJB);
                break;
            }
            case 1: {
                ServiceFacadeRemoteEJB serviceEndpointRemoteEJB = (ServiceFacadeRemoteEJB)serviceEndpoint;
                BusinessDelegateRemoteEJB businessDelegateRemoteEJB = (BusinessDelegateRemoteEJB)businessDelegate;
                businessDelegateRemoteEJB.setServiceFacade(serviceEndpointRemoteEJB);
                break;
            }
            case 0: {
                ServiceFacadeJMS serviceEndpointQueue = (ServiceFacadeJMS)serviceEndpoint;
                BusinessDelegateJMS businessDelegateJMSQueue = (BusinessDelegateJMS)businessDelegate;
                businessDelegateJMSQueue.setServiceFacade(serviceEndpointQueue);
                break;
            }
            case 4: {
                ServiceFacadeWebService serviceEndpointWS = (ServiceFacadeWebService)serviceEndpoint;
                BusinessDelegateWebService businessDelegateWS = (BusinessDelegateWebService)businessDelegate;
                businessDelegateWS.setServiceFacade(serviceEndpointWS);
                break;
            }
            default: {
                throw new CaipDelegateNoServiceException("Service type " + serviceEndpoint.getServiceInfo().getTechnology() + " is not supported by CAIP.");
            }
        }
    }

    public static ServiceInfoVO rebindService(BusinessDelegate businessDelegate, BusinessDelegateDDInfo bdInfo) throws CaipDelegateNoServiceException, CaipException {
        BusinessDelegateFactory.rebindPrep(bdInfo.getDelegateId());
        return BusinessDelegateFactory.narrowService(bdInfo, businessDelegate);
    }

    public static void rebindServiceFailover(BusinessDelegate businessDelegate, ServiceInfoVO serviceInfo, ServiceLocationVO serviceLocation, BusinessDelegateDDInfo bdInfo) throws CaipDelegateNoServiceException, CaipException {
        BusinessDelegateFactory.rebindPrep(bdInfo.getDelegateId());
        BusinessDelegateFactory.narrowServiceFailover(serviceInfo, serviceLocation, businessDelegate, bdInfo);
    }

    private static void rebindPrep(String delegateId) {
        ServiceLocator serviceLocator = BusinessDelegateFactory.getServiceLocator();
        serviceLocator.removeService(delegateId);
        serviceLocator.removeServiceLocations(delegateId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServiceLocator getServiceLocator() {
        ConfigData configData = BusinessDelegateFactory.configData;
        synchronized (configData) {
            return ServiceLocatorImpl.getInstance(BusinessDelegateFactory.configData.getNdsConnectionDDInfoList());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        BusinessDelegateFactory.passiveConfigureCaip();
    }
}

