/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.caip.client.config;

import gov.va.med.caip.client.config.CaipConfiguration;
import gov.va.med.caip.client.config.CaipConfigurationAcceptor;
import gov.va.med.caip.client.exceptions.CaipException;
import gov.va.med.caip.client.exceptions.CanNotParseCaipConfigurationFileException;
import gov.va.med.soa.utils.exceptions.ExceptionUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.digester.Digester;
import org.apache.log4j.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CaipConfigurator {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$caip$client$config$CaipConfigurator == null ? (class$gov$va$med$caip$client$config$CaipConfigurator = CaipConfigurator.class$("gov.va.med.caip.client.config.CaipConfigurator")) : class$gov$va$med$caip$client$config$CaipConfigurator));
    static /* synthetic */ Class class$gov$va$med$caip$client$config$CaipConfigurator;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    private CaipConfigurator() {
    }

    public static CaipConfiguration doConfigureCaip(InputStream caipConfigStream) throws CaipException, CanNotParseCaipConfigurationFileException {
        CaipConfigurationAcceptor caipConfigurationAcceptor = new CaipConfigurationAcceptor();
        SAXParser sp = null;
        String errMsg = "Cannot configure parser to parse caipConfiguration file. ";
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(true);
            spf.setNamespaceAware(true);
            spf.setFeature("http://xml.org/sax/features/validation", true);
            spf.setFeature("http://apache.org/xml/features/validation/schema", true);
            spf.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            sp = spf.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)(errMsg + ExceptionUtils.getFullStackTrace(e)));
            throw new CanNotParseCaipConfigurationFileException(errMsg, e);
        }
        catch (SAXException e) {
            logger.error((Object)(errMsg + ExceptionUtils.getFullStackTrace(e)));
            throw new CanNotParseCaipConfigurationFileException(errMsg, e);
        }
        Digester digester = new Digester(sp);
        digester.setErrorHandler((ErrorHandler)new XmlObjectValidator());
        digester.setEntityResolver((EntityResolver)new CAIPResolver());
        digester.push((Object)caipConfigurationAcceptor);
        CaipConfigurator.addDigesterMethods(digester);
        try {
            digester.parse(caipConfigStream);
        }
        catch (Exception e) {
            errMsg = "Cannot parse caipConfiguration file. ";
            logger.error((Object)(errMsg + ExceptionUtils.getFullStackTrace(e)));
            throw new CanNotParseCaipConfigurationFileException(errMsg, e);
        }
        return caipConfigurationAcceptor;
    }

    private static void addDigesterMethods(Digester digester) {
        Class[] bdTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CaipConfigurator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CaipConfigurator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CaipConfigurator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CaipConfigurator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CaipConfigurator.class$("java.lang.String")) : class$java$lang$String};
        digester.addCallMethod("CaipClientConfiguration/BusinessDelegates/BusinessDelegate", "addBusinessDelegateDefinition", 5, bdTypes);
        digester.addCallParam("CaipClientConfiguration/BusinessDelegates/BusinessDelegate/DelegateId", 0);
        digester.addCallParam("CaipClientConfiguration/BusinessDelegates/BusinessDelegate/Signature", 1);
        digester.addCallParam("CaipClientConfiguration/BusinessDelegates/BusinessDelegate/ImplementationClass", 2);
        digester.addCallParam("CaipClientConfiguration/BusinessDelegates/BusinessDelegate/TransportTechnology", 3);
        digester.addCallParam("CaipClientConfiguration/BusinessDelegates/BusinessDelegate/Application", 4);
        Class[] ndsTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = CaipConfigurator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CaipConfigurator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CaipConfigurator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = CaipConfigurator.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = CaipConfigurator.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CaipConfigurator.class$("java.lang.String")) : class$java$lang$String};
        digester.addCallMethod("CaipClientConfiguration/NDSConnections/NDSConnection", "addNDSLocationInformation", 6, ndsTypes);
        digester.addCallParam("CaipClientConfiguration/NDSConnections/NDSConnection/Name", 0);
        digester.addCallParam("CaipClientConfiguration/NDSConnections/NDSConnection/Provider", 1);
        digester.addCallParam("CaipClientConfiguration/NDSConnections/NDSConnection/Url", 2);
        digester.addCallParam("CaipClientConfiguration/NDSConnections/NDSConnection/Priority", 3);
        digester.addCallParam("CaipClientConfiguration/NDSConnections/NDSConnection/User", 4);
        digester.addCallParam("CaipClientConfiguration/NDSConnections/NDSConnection/Password", 5);
        Class[] pmTypes = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = CaipConfigurator.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CaipConfigurator.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CaipConfigurator.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CaipConfigurator.class$("java.lang.Boolean")) : class$java$lang$Boolean};
        digester.addCallMethod("CaipClientConfiguration/PerformanceMetrics", "addPerformanceMetricsInformation", 4, pmTypes);
        digester.addCallParam("CaipClientConfiguration/PerformanceMetrics/ConfigureCaip", 0);
        digester.addCallParam("CaipClientConfiguration/PerformanceMetrics/ServiceNarrowingRebinding", 1);
        digester.addCallParam("CaipClientConfiguration/PerformanceMetrics/NDSLookup", 2);
        digester.addCallParam("CaipClientConfiguration/PerformanceMetrics/ProxyInvocation", 3);
        digester.addCallMethod("CaipClientConfiguration/SiteName", "addSite", 1);
        digester.addCallParam("CaipClientConfiguration/SiteName", 0);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CAIPResolver
    implements EntityResolver {
        private CAIPResolver() {
        }

        public InputSource resolveEntity(String arg0, String arg1) throws SAXException, IOException {
            InputSource source = null;
            if (arg1 != null && arg1.equals("http://med.va.gov/CommonServices/caipConfig.xsd")) {
                logger.debug((Object)"Checking classpath for schema caipConfig.xsd.");
                URL schemaLoc = Thread.currentThread().getContextClassLoader().getResource("caipConfig.xsd");
                source = new InputSource(schemaLoc.toString());
            } else {
                logger.debug((Object)"Using schema location as coded in configuration file.");
            }
            return source;
        }
    }

    protected static class XmlObjectValidator
    implements ErrorHandler {
        protected XmlObjectValidator() {
        }

        public void error(SAXParseException exception) throws SAXException {
            throw new SAXException(exception.getMessage());
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            throw new SAXException(exception.getMessage());
        }

        public void warning(SAXParseException exception) {
            logger.warn((Object)("WARNING while parsing CAIP configuration file: " + exception.toString()));
        }
    }
}

