/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.caip.client.config;

import gov.va.med.caip.client.config.BusinessDelegateDDInfoImpl;
import gov.va.med.caip.client.config.CaipConfiguration;
import gov.va.med.caip.client.config.NdsConnectionDDInfoImpl;
import gov.va.med.caip.client.config.PerformanceMetricsInfo;
import gov.va.med.caip.client.config.PerformanceMetricsInfoImpl;
import gov.va.med.caip.client.exceptions.CaipFactoryConfigurationException;
import gov.va.med.soa.utils.enum.TechnologyType;
import gov.va.med.soa.utils.exceptions.ExceptionUtils;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class CaipConfigurationAcceptor
implements CaipConfiguration {
    private static final Logger logger = Logger.getLogger((Class)(class$gov$va$med$caip$client$config$CaipConfigurationAcceptor == null ? (class$gov$va$med$caip$client$config$CaipConfigurationAcceptor = CaipConfigurationAcceptor.class$("gov.va.med.caip.client.config.CaipConfigurationAcceptor")) : class$gov$va$med$caip$client$config$CaipConfigurationAcceptor));
    private HashMap businessDelegates = new HashMap();
    private TreeMap ndsConnectionDDInfoList = new TreeMap();
    private PerformanceMetricsInfo performanceMetricsInfo = new PerformanceMetricsInfoImpl();
    private String site = "";
    static /* synthetic */ Class class$gov$va$med$caip$client$config$CaipConfigurationAcceptor;

    CaipConfigurationAcceptor() {
    }

    public void addBusinessDelegateDefinition(String delegateId, String signature, String implementationClassName, String technologyType, String application) throws CaipFactoryConfigurationException {
        if (this.businessDelegates.get(delegateId) != null) {
            String errMsg = "DelegateId must be unique within a configuation file. More than one delegate entry found with delegate id " + delegateId;
            logger.error((Object)errMsg);
            throw new CaipFactoryConfigurationException(errMsg);
        }
        try {
            BusinessDelegateDDInfoImpl businessDelegateDDInfo = new BusinessDelegateDDInfoImpl();
            businessDelegateDDInfo.setDelegateId(delegateId);
            businessDelegateDDInfo.setSignature(signature);
            businessDelegateDDInfo.setImplementationClassName(implementationClassName);
            businessDelegateDDInfo.setTechnologyType(TechnologyType.fromString(technologyType));
            businessDelegateDDInfo.setApplication(application);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding Business Delegate Descriptor: " + businessDelegateDDInfo.toString() + " \nwith key " + delegateId));
            }
            this.businessDelegates.put(delegateId, businessDelegateDDInfo);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            String errMsg = "Exception occured within addBusinessDelegateDefinition(): ";
            logger.error((Object)(errMsg + ExceptionUtils.getFullStackTrace(e)));
            throw new CaipFactoryConfigurationException(errMsg, e);
        }
    }

    public void addNDSLocationInformation(String jndiName, String jndiProvider, String url, Integer priority, String user, String password) throws CaipFactoryConfigurationException {
        try {
            NdsConnectionDDInfoImpl ndsConnectionDDInfoImpl = new NdsConnectionDDInfoImpl();
            ndsConnectionDDInfoImpl.setName(jndiName);
            ndsConnectionDDInfoImpl.setProvider(jndiProvider);
            ndsConnectionDDInfoImpl.setUrl(url);
            ndsConnectionDDInfoImpl.setPriority(priority);
            ndsConnectionDDInfoImpl.setUser(user);
            ndsConnectionDDInfoImpl.setPassWord(password);
            this.ndsConnectionDDInfoList.put(priority, ndsConnectionDDInfoImpl);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding NDS connection entry: " + ndsConnectionDDInfoImpl.toString()));
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            String errMsg = "Exception occured within addInfrastructureDescriptor(): ";
            logger.error((Object)(errMsg + ExceptionUtils.getFullStackTrace(e)));
            throw new CaipFactoryConfigurationException(errMsg, e);
        }
    }

    public void addPerformanceMetricsInformation(boolean timeConfigureCaipMetrics, boolean timeServiceNarrowingRebindingMetrics, boolean timeNDSLookupMetrics, boolean timeProxyInvocationMetrics) throws CaipFactoryConfigurationException {
        try {
            PerformanceMetricsInfoImpl performanceMetricsInfoImpl = new PerformanceMetricsInfoImpl();
            performanceMetricsInfoImpl.setTimeConfigureCaip(timeConfigureCaipMetrics);
            performanceMetricsInfoImpl.setTimeServiceNarrowingRebinding(timeServiceNarrowingRebindingMetrics);
            performanceMetricsInfoImpl.setTimeNDSLookup(timeNDSLookupMetrics);
            performanceMetricsInfoImpl.setTimeProxyInvocation(timeProxyInvocationMetrics);
            this.performanceMetricsInfo = performanceMetricsInfoImpl;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding PerformancemMetricsInformation: " + performanceMetricsInfoImpl.toString()));
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            String errMsg = "Exception occured within addPerformancemMetricsInformation(): ";
            logger.error((Object)(errMsg + ExceptionUtils.getFullStackTrace(e)));
            throw new CaipFactoryConfigurationException(errMsg, e);
        }
    }

    public void addSite(String aSite) throws CaipFactoryConfigurationException {
        try {
            this.site = aSite;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding CAIP site: " + this.site));
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            String errMsg = "Exception occured within addSite(): ";
            logger.error((Object)(errMsg + ExceptionUtils.getFullStackTrace(e)));
            throw new CaipFactoryConfigurationException(errMsg, e);
        }
    }

    public HashMap getBusinessDelegates() {
        return this.businessDelegates;
    }

    public TreeMap getNdsConnectionDDInfoList() {
        return this.ndsConnectionDDInfoList;
    }

    public PerformanceMetricsInfo getPerformanceMetricsInfo() {
        return this.performanceMetricsInfo;
    }

    public String getSite() {
        return this.site;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

