/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly.factory.db.common;

import gov.va.med.term.access.readonly.factory.db.common.ConnectionProvider;
import gov.va.med.term.access.readonly.factory.db.common.FactoryException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class Database
implements ConnectionProvider {
    private String url_;
    private Properties properties_;

    public Database(Properties properties) {
        this.url_ = properties.getProperty("jdbc.url");
        this.properties_ = properties;
        String driver = properties.getProperty("jdbc.driver");
        if (driver != null) {
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException x) {
                throw new FactoryException("Could not find jdbc driver class " + driver, x);
            }
        }
    }

    public Connection acquireConnection() throws SQLException {
        return DriverManager.getConnection(this.url_, this.properties_);
    }

    public void releaseConnection(Connection connection) throws SQLException {
        connection.close();
    }
}

