/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly.factory.db.common;

import gov.va.med.term.access.readonly.factory.db.common.Database;
import gov.va.med.term.access.readonly.factory.db.common.FactoryException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.log4j.Logger;

public interface ConnectionProvider {
    public static final Factory factory = new Factory(){
        private Logger logger_ = Logger.getLogger((Class)(2.class$gov$va$med$term$access$readonly$factory$db$common$ConnectionProvider == null ? (2.class$gov$va$med$term$access$readonly$factory$db$common$ConnectionProvider = 2.class$("gov.va.med.term.access.readonly.factory.db.common.ConnectionProvider")) : 2.class$gov$va$med$term$access$readonly$factory$db$common$ConnectionProvider));
        private String jdbcPropertiesFilename_ = "/gov/va/med/term/access/factory/db/jdbc.properties";
        private ConnectionProvider instance_ = this.initialize_();

        private ConnectionProvider initialize_() {
            try {
                Class.forName("javax.sql.DataSource");
                Class<?> c = Class.forName((2.class$gov$va$med$term$access$readonly$factory$db$common$Database == null ? (2.class$gov$va$med$term$access$readonly$factory$db$common$Database = 2.class$("gov.va.med.term.access.readonly.factory.db.common.Database")) : 2.class$gov$va$med$term$access$readonly$factory$db$common$Database).getName() + "_DataSource");
                return (ConnectionProvider)c.newInstance();
            }
            catch (Exception x) {
                String dataSourceMessage = x.toString();
                String jdbcPropertiesFilename = this.jdbcPropertiesFilename_;
                try {
                    Properties properties = this.load(2.class$gov$va$med$term$access$readonly$factory$db$common$Database == null ? (2.class$gov$va$med$term$access$readonly$factory$db$common$Database = 2.class$("gov.va.med.term.access.readonly.factory.db.common.Database")) : 2.class$gov$va$med$term$access$readonly$factory$db$common$Database, jdbcPropertiesFilename);
                    if (this.logger_.isInfoEnabled()) {
                        this.logger_.info((Object)("Using database properties in " + jdbcPropertiesFilename));
                    }
                    if (properties.getProperty("jdbc.url") == null) {
                        String message = jdbcPropertiesFilename + ": must contain property 'jdbc.url'";
                        this.logger_.warn((Object)message);
                        throw new FactoryException(message);
                    }
                    if (this.logger_.isInfoEnabled()) {
                        this.logger_.info((Object)("Using JDBC url: '" + properties.getProperty("jdbc.url") + "'"));
                    }
                    return new Database(properties);
                }
                catch (FileNotFoundException x2) {
                    this.logger_.error((Object)("Database properties file not found: " + jdbcPropertiesFilename));
                    throw new FactoryException("No DataSource or JDBC properties file found: " + dataSourceMessage + ", " + x2.toString());
                }
                catch (IOException x3) {
                    this.logger_.error((Object)("... read error (" + x3.toString() + ")"));
                    throw new FactoryException("Error reading properties file " + jdbcPropertiesFilename, x3);
                }
            }
        }

        public ConnectionProvider obtain() {
            return this.instance_;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties load(Class relative, String path) throws IOException {
            Properties result = null;
            InputStream s = relative.getResourceAsStream(path);
            if (s == null) {
                throw new FileNotFoundException(path);
            }
            try {
                result = new Properties();
                result.load(s);
            }
            finally {
                try {
                    s.close();
                }
                catch (IOException x) {}
            }
            return result;
        }
    };

    public Connection acquireConnection() throws SQLException;

    public void releaseConnection(Connection var1) throws SQLException;

    static class 2 {
        static /* synthetic */ Class class$gov$va$med$term$access$readonly$factory$db$common$ConnectionProvider;
        static /* synthetic */ Class class$gov$va$med$term$access$readonly$factory$db$common$Database;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static interface Factory {
        public ConnectionProvider obtain();
    }
}

