/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly.factory.cache;

import gov.va.med.term.access.TableManager;
import gov.va.med.term.access.ZipCode;
import gov.va.med.term.access.ZipPlace;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.criteria.ObjectMatcher;
import gov.va.med.term.access.criteria.ObjectOrderByComparator;
import gov.va.med.term.access.readonly.ReadonlyZipCode;
import gov.va.med.term.access.util.ImplementorRegistry;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class ZipCodeFactory
implements ReadonlyZipCode.Factory {
    private static Timestamp timeWhenCachePrimed_;
    private static final TableManager manager_;
    private ReadonlyZipCode.Factory factory_;
    private Map mCache_ = null;
    private ZipCode[] aCache_ = null;
    private Map zipCodeCache_ = new TreeMap();
    static /* synthetic */ Class class$gov$va$med$term$access$readonly$ReadonlyZipCode$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$ZipCode;

    protected ReadonlyZipCode.Factory factory() {
        return this.factory_;
    }

    public ZipCodeFactory() {
        this.factory_ = (ReadonlyZipCode.Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$readonly$ReadonlyZipCode$Factory == null ? (class$gov$va$med$term$access$readonly$ReadonlyZipCode$Factory = ZipCodeFactory.class$("gov.va.med.term.access.readonly.ReadonlyZipCode$Factory")) : class$gov$va$med$term$access$readonly$ReadonlyZipCode$Factory);
    }

    protected ZipCodeFactory(ReadonlyZipCode.Factory factory) {
        this.factory_ = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkCache_() {
        if (this.mCache_ == null) {
            this.initialize_();
            return;
        }
        if (manager_ == null) {
            return;
        }
        if (manager_.isCacheCurrent("STD_ZipCode", timeWhenCachePrimed_)) {
            return;
        }
        Map map = this.zipCodeCache_;
        synchronized (map) {
            this.zipCodeCache_ = new TreeMap();
            ZipCode[] zipCodeArray = this.aCache_;
            synchronized (this.aCache_) {
                Map map2 = this.mCache_;
                synchronized (map2) {
                    this.mCache_ = null;
                    this.aCache_ = null;
                    this.initialize_();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
    }

    private synchronized void initialize_() {
        if (this.mCache_ != null) {
            return;
        }
        timeWhenCachePrimed_ = new Timestamp(System.currentTimeMillis());
        ZipCode[] a = this.factory_.obtain((Criteria)Criteria.ANY);
        TreeMap<ZipCode.Key, ZipCode> m = new TreeMap<ZipCode.Key, ZipCode>();
        int i = a.length;
        while (--i >= 0) {
            ZipCode object = a[i];
            m.put(object.getKey(), object);
            if (object.getZipCode() == null) continue;
            this.zipCodeCache_.put(String.valueOf(object.getZipCode()), object);
        }
        this.mCache_ = m;
        this.aCache_ = a;
    }

    public int count() {
        Criteria.Any criteria = Criteria.ANY;
        return this.count((Criteria)criteria);
    }

    public ZipCode[] obtain() {
        Criteria.Any criteria = Criteria.ANY;
        return this.obtain((Criteria)criteria, 0, Integer.MAX_VALUE, null);
    }

    public ZipCode[] obtain(int first, int max) {
        Criteria.Any criteria = Criteria.ANY;
        return this.obtain((Criteria)criteria, first, max, null);
    }

    public ZipCode[] obtain(int first, int max, String order) {
        Criteria.Any criteria = Criteria.ANY;
        return this.obtain((Criteria)criteria, first, max, order);
    }

    public int count(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null).length;
    }

    public ZipCode[] obtain(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null);
    }

    public ZipCode[] obtain(Criteria criteria, int first, int max) {
        return this.obtain(criteria, first, max, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipCode[] obtain(Criteria criteria, int first, int max, String order) {
        this.checkCache_();
        ZipCode[] zipCodeArray = this.aCache_;
        synchronized (this.aCache_) {
            Object[] instances = (ZipCode[])this.aCache_.clone();
            if (order != null) {
                ObjectOrderByComparator comparator = new ObjectOrderByComparator(class$gov$va$med$term$access$ZipCode == null ? (class$gov$va$med$term$access$ZipCode = ZipCodeFactory.class$("gov.va.med.term.access.ZipCode")) : class$gov$va$med$term$access$ZipCode, order);
                Arrays.sort(instances, comparator);
            }
            Vector<Object> matchingInstances = new Vector<Object>();
            matchingInstances.addAll(Arrays.asList(ObjectMatcher.filter((Criteria)criteria, (Object[])instances)));
            ZipCode[] result = new ZipCode[]{};
            if (first < matchingInstances.size()) {
                result = matchingInstances.subList(first, Math.min(matchingInstances.size(), first + max)).toArray(result);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipCode obtain(ZipCode.Key key) {
        this.checkCache_();
        Map map = this.mCache_;
        synchronized (map) {
            return (ZipCode)this.mCache_.get(key);
        }
    }

    public ZipCode obtainFromKeyString(String s) {
        return this.obtain(ReadonlyZipCode.Key.valueOf(s));
    }

    public ZipCode obtainFromKeyValue(Long keyValue) {
        return this.obtain(new ReadonlyZipCode.Key(keyValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipCode obtainByZipCode(String zipCode) {
        this.checkCache_();
        Map map = this.zipCodeCache_;
        synchronized (map) {
            return (ZipCode)this.zipCodeCache_.get(ZipCodeFactory.zipCodeCacheKey(zipCode));
        }
    }

    private static Object zipCodeCacheKey(String zipCode) {
        return zipCode;
    }

    public ZipPlace[] obtainZipPlaces(ZipCode referrer) {
        return this.factory_.obtainZipPlaces(referrer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        manager_ = TableManager.factory.obtainByTableName("STD_ZipCode");
    }
}

