/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly.factory.cache;

import gov.va.med.term.access.Country;
import gov.va.med.term.access.State;
import gov.va.med.term.access.TableManager;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.criteria.ObjectMatcher;
import gov.va.med.term.access.criteria.ObjectOrderByComparator;
import gov.va.med.term.access.readonly.ReadonlyState;
import gov.va.med.term.access.util.ImplementorRegistry;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class StateFactory
implements ReadonlyState.Factory {
    private static Timestamp timeWhenCachePrimed_;
    private static final TableManager manager_;
    private ReadonlyState.Factory factory_;
    private Map mCache_ = null;
    private State[] aCache_ = null;
    private Map postalNameCache_ = new TreeMap();
    private Map nameCache_ = new TreeMap();
    private Map fipsCodeCache_ = new TreeMap();
    private Map countryOwnerCache_ = new TreeMap();
    static /* synthetic */ Class class$gov$va$med$term$access$readonly$ReadonlyState$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$State;

    protected ReadonlyState.Factory factory() {
        return this.factory_;
    }

    public StateFactory() {
        this.factory_ = (ReadonlyState.Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$readonly$ReadonlyState$Factory == null ? (class$gov$va$med$term$access$readonly$ReadonlyState$Factory = StateFactory.class$("gov.va.med.term.access.readonly.ReadonlyState$Factory")) : class$gov$va$med$term$access$readonly$ReadonlyState$Factory);
    }

    protected StateFactory(ReadonlyState.Factory factory) {
        this.factory_ = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkCache_() {
        if (this.mCache_ == null) {
            this.initialize_();
            return;
        }
        if (manager_ == null) {
            return;
        }
        if (manager_.isCacheCurrent("STD_State", timeWhenCachePrimed_)) {
            return;
        }
        Map map = this.countryOwnerCache_;
        synchronized (map) {
            this.countryOwnerCache_ = new TreeMap();
            Map map2 = this.postalNameCache_;
            synchronized (map2) {
                this.postalNameCache_ = new TreeMap();
                Map map3 = this.nameCache_;
                synchronized (map3) {
                    this.nameCache_ = new TreeMap();
                    Map map4 = this.fipsCodeCache_;
                    synchronized (map4) {
                        this.fipsCodeCache_ = new TreeMap();
                        State[] stateArray = this.aCache_;
                        synchronized (this.aCache_) {
                            Map map5 = this.mCache_;
                            synchronized (map5) {
                                this.mCache_ = null;
                                this.aCache_ = null;
                                this.initialize_();
                            }
                            // ** MonitorExit[var5_5] (shouldn't be in output)
                        }
                    }
                    {
                    }
                }
                {
                }
            }
            {
            }
        }
    }

    private synchronized void initialize_() {
        if (this.mCache_ != null) {
            return;
        }
        timeWhenCachePrimed_ = new Timestamp(System.currentTimeMillis());
        State[] a = this.factory_.obtain((Criteria)Criteria.ANY);
        TreeMap<State.Key, State> m = new TreeMap<State.Key, State>();
        int i = a.length;
        while (--i >= 0) {
            State object = a[i];
            m.put(object.getKey(), object);
            if (object.getCountry() != null && object.getPostalName() != null) {
                this.postalNameCache_.put(String.valueOf(object.getCountry().getKey()) + '^' + String.valueOf(object.getPostalName()), object);
            }
            if (object.getCountry() != null && object.getName() != null) {
                this.nameCache_.put(String.valueOf(object.getCountry().getKey()) + '^' + String.valueOf(object.getName()), object);
            }
            if (object.getCountry() == null || object.getFipsCode() == null) continue;
            this.fipsCodeCache_.put(String.valueOf(object.getCountry().getKey()) + '^' + String.valueOf(object.getFipsCode()), object);
        }
        this.mCache_ = m;
        this.aCache_ = a;
    }

    public int count() {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.count((Criteria)criteria);
    }

    public State[] obtain() {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, 0, Integer.MAX_VALUE, null);
    }

    public State[] obtain(int first, int max) {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, first, max, null);
    }

    public State[] obtain(int first, int max, String order) {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, first, max, order);
    }

    public int count(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null).length;
    }

    public State[] obtain(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null);
    }

    public State[] obtain(Criteria criteria, int first, int max) {
        return this.obtain(criteria, first, max, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State[] obtain(Criteria criteria, int first, int max, String order) {
        this.checkCache_();
        State[] stateArray = this.aCache_;
        synchronized (this.aCache_) {
            Object[] instances = (State[])this.aCache_.clone();
            if (order != null) {
                ObjectOrderByComparator comparator = new ObjectOrderByComparator(class$gov$va$med$term$access$State == null ? (class$gov$va$med$term$access$State = StateFactory.class$("gov.va.med.term.access.State")) : class$gov$va$med$term$access$State, order);
                Arrays.sort(instances, comparator);
            }
            Vector<Object> matchingInstances = new Vector<Object>();
            matchingInstances.addAll(Arrays.asList(ObjectMatcher.filter((Criteria)criteria, (Object[])instances)));
            State[] result = new State[]{};
            if (first < matchingInstances.size()) {
                result = matchingInstances.subList(first, Math.min(matchingInstances.size(), first + max)).toArray(result);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State obtain(State.Key key) {
        this.checkCache_();
        Map map = this.mCache_;
        synchronized (map) {
            return (State)this.mCache_.get(key);
        }
    }

    public State obtainFromKeyString(String s) {
        return this.obtain(ReadonlyState.Key.valueOf(s));
    }

    public State obtainFromKeyValue(Long keyValue) {
        return this.obtain(new ReadonlyState.Key(keyValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State obtainByPostalName(Country country, String postalName) {
        this.checkCache_();
        Map map = this.postalNameCache_;
        synchronized (map) {
            return (State)this.postalNameCache_.get(StateFactory.postalNameCacheKey(country, postalName));
        }
    }

    private static Object postalNameCacheKey(Country country, String postalName) {
        return String.valueOf(country.getKey()) + '^' + postalName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State obtainByName(Country country, String name) {
        this.checkCache_();
        Map map = this.nameCache_;
        synchronized (map) {
            return (State)this.nameCache_.get(StateFactory.nameCacheKey(country, name));
        }
    }

    private static Object nameCacheKey(Country country, String name) {
        return String.valueOf(country.getKey()) + '^' + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State obtainByFipsCode(Country country, String fipsCode) {
        this.checkCache_();
        Map map = this.fipsCodeCache_;
        synchronized (map) {
            return (State)this.fipsCodeCache_.get(StateFactory.fipsCodeCacheKey(country, fipsCode));
        }
    }

    private static Object fipsCodeCacheKey(Country country, String fipsCode) {
        return String.valueOf(country.getKey()) + '^' + fipsCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State[] obtain(Country owner) {
        Object[] result;
        this.checkCache_();
        Map map = this.countryOwnerCache_;
        synchronized (map) {
            result = (State[])this.countryOwnerCache_.get(owner.getKey());
            if (result == null) {
                Long ownerId = owner.getId();
                Vector<ReadonlyState> v = new Vector<ReadonlyState>();
                int lim = this.aCache_.length;
                int i = -1;
                while (++i < lim) {
                    ReadonlyState current = (ReadonlyState)this.aCache_[i];
                    Long currentId = current.getCountryKey();
                    if (!ownerId.equals(currentId)) continue;
                    v.addElement(current);
                }
                result = new State[v.size()];
                v.copyInto(result);
                this.countryOwnerCache_.put(owner.getKey(), result);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        manager_ = TableManager.factory.obtainByTableName("STD_State");
    }
}

