/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly.factory.cache;

import gov.va.med.term.access.Service;
import gov.va.med.term.access.TableManager;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.criteria.ObjectMatcher;
import gov.va.med.term.access.criteria.ObjectOrderByComparator;
import gov.va.med.term.access.readonly.ReadonlyService;
import gov.va.med.term.access.util.ImplementorRegistry;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class ServiceFactory
implements ReadonlyService.Factory {
    private static Timestamp timeWhenCachePrimed_;
    private static final TableManager manager_;
    private ReadonlyService.Factory factory_;
    private Map mCache_ = null;
    private Service[] aCache_ = null;
    private Map nameCache_ = new TreeMap();
    static /* synthetic */ Class class$gov$va$med$term$access$readonly$ReadonlyService$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$Service;

    protected ReadonlyService.Factory factory() {
        return this.factory_;
    }

    public ServiceFactory() {
        this.factory_ = (ReadonlyService.Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$readonly$ReadonlyService$Factory == null ? (class$gov$va$med$term$access$readonly$ReadonlyService$Factory = ServiceFactory.class$("gov.va.med.term.access.readonly.ReadonlyService$Factory")) : class$gov$va$med$term$access$readonly$ReadonlyService$Factory);
    }

    protected ServiceFactory(ReadonlyService.Factory factory) {
        this.factory_ = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkCache_() {
        if (this.mCache_ == null) {
            this.initialize_();
            return;
        }
        if (manager_ == null) {
            return;
        }
        if (manager_.isCacheCurrent("STD_Service", timeWhenCachePrimed_)) {
            return;
        }
        Map map = this.nameCache_;
        synchronized (map) {
            this.nameCache_ = new TreeMap();
            Service[] serviceArray = this.aCache_;
            synchronized (this.aCache_) {
                Map map2 = this.mCache_;
                synchronized (map2) {
                    this.mCache_ = null;
                    this.aCache_ = null;
                    this.initialize_();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
    }

    private synchronized void initialize_() {
        if (this.mCache_ != null) {
            return;
        }
        timeWhenCachePrimed_ = new Timestamp(System.currentTimeMillis());
        Service[] a = this.factory_.obtain((Criteria)Criteria.ANY);
        TreeMap<Service.Key, Service> m = new TreeMap<Service.Key, Service>();
        int i = a.length;
        while (--i >= 0) {
            Service object = a[i];
            m.put(object.getKey(), object);
            if (object.getName() == null) continue;
            this.nameCache_.put(String.valueOf(object.getName()), object);
        }
        this.mCache_ = m;
        this.aCache_ = a;
    }

    public int count() {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.count((Criteria)criteria);
    }

    public Service[] obtain() {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, 0, Integer.MAX_VALUE, null);
    }

    public Service[] obtain(int first, int max) {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, first, max, null);
    }

    public Service[] obtain(int first, int max, String order) {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, first, max, order);
    }

    public int count(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null).length;
    }

    public Service[] obtain(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null);
    }

    public Service[] obtain(Criteria criteria, int first, int max) {
        return this.obtain(criteria, first, max, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service[] obtain(Criteria criteria, int first, int max, String order) {
        this.checkCache_();
        Service[] serviceArray = this.aCache_;
        synchronized (this.aCache_) {
            Object[] instances = (Service[])this.aCache_.clone();
            if (order != null) {
                ObjectOrderByComparator comparator = new ObjectOrderByComparator(class$gov$va$med$term$access$Service == null ? (class$gov$va$med$term$access$Service = ServiceFactory.class$("gov.va.med.term.access.Service")) : class$gov$va$med$term$access$Service, order);
                Arrays.sort(instances, comparator);
            }
            Vector<Object> matchingInstances = new Vector<Object>();
            matchingInstances.addAll(Arrays.asList(ObjectMatcher.filter((Criteria)criteria, (Object[])instances)));
            Service[] result = new Service[]{};
            if (first < matchingInstances.size()) {
                result = matchingInstances.subList(first, Math.min(matchingInstances.size(), first + max)).toArray(result);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service obtain(Service.Key key) {
        this.checkCache_();
        Map map = this.mCache_;
        synchronized (map) {
            return (Service)this.mCache_.get(key);
        }
    }

    public Service obtainFromKeyString(String s) {
        return this.obtain(ReadonlyService.Key.valueOf(s));
    }

    public Service obtainFromKeyValue(Long keyValue) {
        return this.obtain(new ReadonlyService.Key(keyValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Service obtainByName(String name) {
        this.checkCache_();
        Map map = this.nameCache_;
        synchronized (map) {
            return (Service)this.nameCache_.get(ServiceFactory.nameCacheKey(name));
        }
    }

    private static Object nameCacheKey(String name) {
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        manager_ = TableManager.factory.obtainByTableName("STD_Service");
    }
}

