/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly.factory.cache;

import gov.va.med.term.access.Institution;
import gov.va.med.term.access.TableManager;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.criteria.ObjectMatcher;
import gov.va.med.term.access.criteria.ObjectOrderByComparator;
import gov.va.med.term.access.readonly.ReadonlyInstitution;
import gov.va.med.term.access.util.ImplementorRegistry;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class InstitutionFactory
implements ReadonlyInstitution.Factory {
    private static Timestamp timeWhenCachePrimed_;
    private static final TableManager manager_;
    private ReadonlyInstitution.Factory factory_;
    private Map mCache_ = null;
    private Institution[] aCache_ = null;
    private Map stationNumberCache_ = new TreeMap();
    private Map parentReferrerCache_ = new TreeMap();
    static /* synthetic */ Class class$gov$va$med$term$access$readonly$ReadonlyInstitution$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$Institution;

    protected ReadonlyInstitution.Factory factory() {
        return this.factory_;
    }

    public InstitutionFactory() {
        this.factory_ = (ReadonlyInstitution.Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$readonly$ReadonlyInstitution$Factory == null ? (class$gov$va$med$term$access$readonly$ReadonlyInstitution$Factory = InstitutionFactory.class$("gov.va.med.term.access.readonly.ReadonlyInstitution$Factory")) : class$gov$va$med$term$access$readonly$ReadonlyInstitution$Factory);
    }

    protected InstitutionFactory(ReadonlyInstitution.Factory factory) {
        this.factory_ = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkCache_() {
        if (this.mCache_ == null) {
            this.initialize_();
            return;
        }
        if (manager_ == null) {
            return;
        }
        if (manager_.isCacheCurrent("STD_Institution", timeWhenCachePrimed_)) {
            return;
        }
        Map map = this.parentReferrerCache_;
        synchronized (map) {
            this.parentReferrerCache_ = new TreeMap();
            Map map2 = this.stationNumberCache_;
            synchronized (map2) {
                this.stationNumberCache_ = new TreeMap();
                Institution[] institutionArray = this.aCache_;
                synchronized (this.aCache_) {
                    Map map3 = this.mCache_;
                    synchronized (map3) {
                        this.mCache_ = null;
                        this.aCache_ = null;
                        this.initialize_();
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            {
            }
        }
    }

    private synchronized void initialize_() {
        if (this.mCache_ != null) {
            return;
        }
        timeWhenCachePrimed_ = new Timestamp(System.currentTimeMillis());
        Institution[] a = this.factory_.obtain((Criteria)Criteria.ANY);
        TreeMap<Institution.Key, Institution> m = new TreeMap<Institution.Key, Institution>();
        int i = a.length;
        while (--i >= 0) {
            Institution object = a[i];
            m.put(object.getKey(), object);
            if (object.getStationNumber() == null) continue;
            this.stationNumberCache_.put(String.valueOf(object.getStationNumber()), object);
        }
        this.mCache_ = m;
        this.aCache_ = a;
    }

    public int count() {
        Criteria.Any criteria = Criteria.ANY;
        return this.count((Criteria)criteria);
    }

    public Institution[] obtain() {
        Criteria.Any criteria = Criteria.ANY;
        return this.obtain((Criteria)criteria, 0, Integer.MAX_VALUE, null);
    }

    public Institution[] obtain(int first, int max) {
        Criteria.Any criteria = Criteria.ANY;
        return this.obtain((Criteria)criteria, first, max, null);
    }

    public Institution[] obtain(int first, int max, String order) {
        Criteria.Any criteria = Criteria.ANY;
        return this.obtain((Criteria)criteria, first, max, order);
    }

    public int count(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null).length;
    }

    public Institution[] obtain(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null);
    }

    public Institution[] obtain(Criteria criteria, int first, int max) {
        return this.obtain(criteria, first, max, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Institution[] obtain(Criteria criteria, int first, int max, String order) {
        this.checkCache_();
        Institution[] institutionArray = this.aCache_;
        synchronized (this.aCache_) {
            Object[] instances = (Institution[])this.aCache_.clone();
            if (order != null) {
                ObjectOrderByComparator comparator = new ObjectOrderByComparator(class$gov$va$med$term$access$Institution == null ? (class$gov$va$med$term$access$Institution = InstitutionFactory.class$("gov.va.med.term.access.Institution")) : class$gov$va$med$term$access$Institution, order);
                Arrays.sort(instances, comparator);
            }
            Vector<Object> matchingInstances = new Vector<Object>();
            matchingInstances.addAll(Arrays.asList(ObjectMatcher.filter((Criteria)criteria, (Object[])instances)));
            Institution[] result = new Institution[]{};
            if (first < matchingInstances.size()) {
                result = matchingInstances.subList(first, Math.min(matchingInstances.size(), first + max)).toArray(result);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Institution obtain(Institution.Key key) {
        this.checkCache_();
        Map map = this.mCache_;
        synchronized (map) {
            return (Institution)this.mCache_.get(key);
        }
    }

    public Institution obtainFromKeyString(String s) {
        return this.obtain(ReadonlyInstitution.Key.valueOf(s));
    }

    public Institution obtainFromKeyValue(Long keyValue) {
        return this.obtain(new ReadonlyInstitution.Key(keyValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Institution obtainByStationNumber(String stationNumber) {
        this.checkCache_();
        Map map = this.stationNumberCache_;
        synchronized (map) {
            return (Institution)this.stationNumberCache_.get(InstitutionFactory.stationNumberCacheKey(stationNumber));
        }
    }

    private static Object stationNumberCacheKey(String stationNumber) {
        return stationNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Institution[] obtainChildren(Institution referrer) {
        Object[] result;
        this.checkCache_();
        Map map = this.parentReferrerCache_;
        synchronized (map) {
            result = (Institution[])this.parentReferrerCache_.get(referrer.getKey());
            if (result == null) {
                Long referrerId = referrer.getId();
                Vector<ReadonlyInstitution> v = new Vector<ReadonlyInstitution>();
                int lim = this.aCache_.length;
                int i = -1;
                while (++i < lim) {
                    ReadonlyInstitution current = (ReadonlyInstitution)this.aCache_[i];
                    Long currentId = current.getParentKey();
                    if (!referrerId.equals(currentId)) continue;
                    v.addElement(current);
                }
                result = new Institution[v.size()];
                v.copyInto(result);
                this.parentReferrerCache_.put(referrer.getKey(), result);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        manager_ = TableManager.factory.obtainByTableName("STD_Institution");
    }
}

