/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly.factory.cache;

import gov.va.med.term.access.Ethnicity;
import gov.va.med.term.access.TableManager;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.criteria.ObjectMatcher;
import gov.va.med.term.access.criteria.ObjectOrderByComparator;
import gov.va.med.term.access.readonly.ReadonlyEthnicity;
import gov.va.med.term.access.util.ImplementorRegistry;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class EthnicityFactory
implements ReadonlyEthnicity.Factory {
    private static Timestamp timeWhenCachePrimed_;
    private static final TableManager manager_;
    private ReadonlyEthnicity.Factory factory_;
    private Map mCache_ = null;
    private Ethnicity[] aCache_ = null;
    private Map abbreviationCache_ = new TreeMap();
    static /* synthetic */ Class class$gov$va$med$term$access$readonly$ReadonlyEthnicity$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$Ethnicity;

    protected ReadonlyEthnicity.Factory factory() {
        return this.factory_;
    }

    public EthnicityFactory() {
        this.factory_ = (ReadonlyEthnicity.Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$readonly$ReadonlyEthnicity$Factory == null ? (class$gov$va$med$term$access$readonly$ReadonlyEthnicity$Factory = EthnicityFactory.class$("gov.va.med.term.access.readonly.ReadonlyEthnicity$Factory")) : class$gov$va$med$term$access$readonly$ReadonlyEthnicity$Factory);
    }

    protected EthnicityFactory(ReadonlyEthnicity.Factory factory) {
        this.factory_ = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkCache_() {
        if (this.mCache_ == null) {
            this.initialize_();
            return;
        }
        if (manager_ == null) {
            return;
        }
        if (manager_.isCacheCurrent("STD_Ethnicity", timeWhenCachePrimed_)) {
            return;
        }
        Map map = this.abbreviationCache_;
        synchronized (map) {
            this.abbreviationCache_ = new TreeMap();
            Ethnicity[] ethnicityArray = this.aCache_;
            synchronized (this.aCache_) {
                Map map2 = this.mCache_;
                synchronized (map2) {
                    this.mCache_ = null;
                    this.aCache_ = null;
                    this.initialize_();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
    }

    private synchronized void initialize_() {
        if (this.mCache_ != null) {
            return;
        }
        timeWhenCachePrimed_ = new Timestamp(System.currentTimeMillis());
        Ethnicity[] a = this.factory_.obtain((Criteria)Criteria.ANY);
        TreeMap<Ethnicity.Key, Ethnicity> m = new TreeMap<Ethnicity.Key, Ethnicity>();
        int i = a.length;
        while (--i >= 0) {
            Ethnicity object = a[i];
            m.put(object.getKey(), object);
            if (object.getAbbreviation() == null) continue;
            this.abbreviationCache_.put(String.valueOf(object.getAbbreviation()), object);
        }
        this.mCache_ = m;
        this.aCache_ = a;
    }

    public int count() {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.count((Criteria)criteria);
    }

    public Ethnicity[] obtain() {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, 0, Integer.MAX_VALUE, null);
    }

    public Ethnicity[] obtain(int first, int max) {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, first, max, null);
    }

    public Ethnicity[] obtain(int first, int max, String order) {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, first, max, order);
    }

    public int count(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null).length;
    }

    public Ethnicity[] obtain(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null);
    }

    public Ethnicity[] obtain(Criteria criteria, int first, int max) {
        return this.obtain(criteria, first, max, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ethnicity[] obtain(Criteria criteria, int first, int max, String order) {
        this.checkCache_();
        Ethnicity[] ethnicityArray = this.aCache_;
        synchronized (this.aCache_) {
            Object[] instances = (Ethnicity[])this.aCache_.clone();
            if (order != null) {
                ObjectOrderByComparator comparator = new ObjectOrderByComparator(class$gov$va$med$term$access$Ethnicity == null ? (class$gov$va$med$term$access$Ethnicity = EthnicityFactory.class$("gov.va.med.term.access.Ethnicity")) : class$gov$va$med$term$access$Ethnicity, order);
                Arrays.sort(instances, comparator);
            }
            Vector<Object> matchingInstances = new Vector<Object>();
            matchingInstances.addAll(Arrays.asList(ObjectMatcher.filter((Criteria)criteria, (Object[])instances)));
            Ethnicity[] result = new Ethnicity[]{};
            if (first < matchingInstances.size()) {
                result = matchingInstances.subList(first, Math.min(matchingInstances.size(), first + max)).toArray(result);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ethnicity obtain(Ethnicity.Key key) {
        this.checkCache_();
        Map map = this.mCache_;
        synchronized (map) {
            return (Ethnicity)this.mCache_.get(key);
        }
    }

    public Ethnicity obtainFromKeyString(String s) {
        return this.obtain(ReadonlyEthnicity.Key.valueOf(s));
    }

    public Ethnicity obtainFromKeyValue(Long keyValue) {
        return this.obtain(new ReadonlyEthnicity.Key(keyValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ethnicity obtainByAbbreviation(String abbreviation) {
        this.checkCache_();
        Map map = this.abbreviationCache_;
        synchronized (map) {
            return (Ethnicity)this.abbreviationCache_.get(EthnicityFactory.abbreviationCacheKey(abbreviation));
        }
    }

    private static Object abbreviationCacheKey(String abbreviation) {
        return abbreviation;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        manager_ = TableManager.factory.obtainByTableName("STD_Ethnicity");
    }
}

