/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly.factory.cache;

import gov.va.med.term.access.County;
import gov.va.med.term.access.State;
import gov.va.med.term.access.StatisticalArea;
import gov.va.med.term.access.TableManager;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.criteria.ObjectMatcher;
import gov.va.med.term.access.criteria.ObjectOrderByComparator;
import gov.va.med.term.access.readonly.ReadonlyCounty;
import gov.va.med.term.access.util.ImplementorRegistry;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class CountyFactory
implements ReadonlyCounty.Factory {
    private static Timestamp timeWhenCachePrimed_;
    private static final TableManager manager_;
    private ReadonlyCounty.Factory factory_;
    private Map mCache_ = null;
    private County[] aCache_ = null;
    private Map numberCache_ = new TreeMap();
    private Map nameCache_ = new TreeMap();
    private Map stateOwnerCache_ = new TreeMap();
    static /* synthetic */ Class class$gov$va$med$term$access$readonly$ReadonlyCounty$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$County;

    protected ReadonlyCounty.Factory factory() {
        return this.factory_;
    }

    public CountyFactory() {
        this.factory_ = (ReadonlyCounty.Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$readonly$ReadonlyCounty$Factory == null ? (class$gov$va$med$term$access$readonly$ReadonlyCounty$Factory = CountyFactory.class$("gov.va.med.term.access.readonly.ReadonlyCounty$Factory")) : class$gov$va$med$term$access$readonly$ReadonlyCounty$Factory);
    }

    protected CountyFactory(ReadonlyCounty.Factory factory) {
        this.factory_ = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkCache_() {
        if (this.mCache_ == null) {
            this.initialize_();
            return;
        }
        if (manager_ == null) {
            return;
        }
        if (manager_.isCacheCurrent("STD_County", timeWhenCachePrimed_)) {
            return;
        }
        Map map = this.stateOwnerCache_;
        synchronized (map) {
            this.stateOwnerCache_ = new TreeMap();
            Map map2 = this.numberCache_;
            synchronized (map2) {
                this.numberCache_ = new TreeMap();
                Map map3 = this.nameCache_;
                synchronized (map3) {
                    this.nameCache_ = new TreeMap();
                    County[] countyArray = this.aCache_;
                    synchronized (this.aCache_) {
                        Map map4 = this.mCache_;
                        synchronized (map4) {
                            this.mCache_ = null;
                            this.aCache_ = null;
                            this.initialize_();
                        }
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                    }
                }
                {
                }
            }
            {
            }
        }
    }

    private synchronized void initialize_() {
        if (this.mCache_ != null) {
            return;
        }
        timeWhenCachePrimed_ = new Timestamp(System.currentTimeMillis());
        County[] a = this.factory_.obtain((Criteria)Criteria.ANY);
        TreeMap<County.Key, County> m = new TreeMap<County.Key, County>();
        int i = a.length;
        while (--i >= 0) {
            County object = a[i];
            m.put(object.getKey(), object);
            if (object.getState() != null && object.getNumber() != null) {
                this.numberCache_.put(String.valueOf(object.getState().getKey()) + '^' + String.valueOf(object.getNumber()), object);
            }
            if (object.getState() == null || object.getName() == null) continue;
            this.nameCache_.put(String.valueOf(object.getState().getKey()) + '^' + String.valueOf(object.getName()), object);
        }
        this.mCache_ = m;
        this.aCache_ = a;
    }

    public int count() {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.count((Criteria)criteria);
    }

    public County[] obtain() {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, 0, Integer.MAX_VALUE, null);
    }

    public County[] obtain(int first, int max) {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, first, max, null);
    }

    public County[] obtain(int first, int max, String order) {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, first, max, order);
    }

    public int count(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null).length;
    }

    public County[] obtain(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null);
    }

    public County[] obtain(Criteria criteria, int first, int max) {
        return this.obtain(criteria, first, max, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public County[] obtain(Criteria criteria, int first, int max, String order) {
        this.checkCache_();
        County[] countyArray = this.aCache_;
        synchronized (this.aCache_) {
            Object[] instances = (County[])this.aCache_.clone();
            if (order != null) {
                ObjectOrderByComparator comparator = new ObjectOrderByComparator(class$gov$va$med$term$access$County == null ? (class$gov$va$med$term$access$County = CountyFactory.class$("gov.va.med.term.access.County")) : class$gov$va$med$term$access$County, order);
                Arrays.sort(instances, comparator);
            }
            Vector<Object> matchingInstances = new Vector<Object>();
            matchingInstances.addAll(Arrays.asList(ObjectMatcher.filter((Criteria)criteria, (Object[])instances)));
            County[] result = new County[]{};
            if (first < matchingInstances.size()) {
                result = matchingInstances.subList(first, Math.min(matchingInstances.size(), first + max)).toArray(result);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public County obtain(County.Key key) {
        this.checkCache_();
        Map map = this.mCache_;
        synchronized (map) {
            return (County)this.mCache_.get(key);
        }
    }

    public County obtainFromKeyString(String s) {
        return this.obtain(ReadonlyCounty.Key.valueOf(s));
    }

    public County obtainFromKeyValue(Long keyValue) {
        return this.obtain(new ReadonlyCounty.Key(keyValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public County obtainByNumber(State state, String number) {
        this.checkCache_();
        Map map = this.numberCache_;
        synchronized (map) {
            return (County)this.numberCache_.get(CountyFactory.numberCacheKey(state, number));
        }
    }

    private static Object numberCacheKey(State state, String number) {
        return String.valueOf(state.getKey()) + '^' + number;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public County obtainByName(State state, String name) {
        this.checkCache_();
        Map map = this.nameCache_;
        synchronized (map) {
            return (County)this.nameCache_.get(CountyFactory.nameCacheKey(state, name));
        }
    }

    private static Object nameCacheKey(State state, String name) {
        return String.valueOf(state.getKey()) + '^' + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public County[] obtain(State owner) {
        Object[] result;
        this.checkCache_();
        Map map = this.stateOwnerCache_;
        synchronized (map) {
            result = (County[])this.stateOwnerCache_.get(owner.getKey());
            if (result == null) {
                Long ownerId = owner.getId();
                Vector<ReadonlyCounty> v = new Vector<ReadonlyCounty>();
                int lim = this.aCache_.length;
                int i = -1;
                while (++i < lim) {
                    ReadonlyCounty current = (ReadonlyCounty)this.aCache_[i];
                    Long currentId = current.getStateKey();
                    if (!ownerId.equals(currentId)) continue;
                    v.addElement(current);
                }
                result = new County[v.size()];
                v.copyInto(result);
                this.stateOwnerCache_.put(owner.getKey(), result);
            }
        }
        return result;
    }

    public StatisticalArea[] obtainStatisticalAreas(County referrer) {
        return this.factory_.obtainStatisticalAreas(referrer);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        manager_ = TableManager.factory.obtainByTableName("STD_County");
    }
}

