/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly.factory.cache;

import gov.va.med.term.access.Country;
import gov.va.med.term.access.TableManager;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.criteria.ObjectMatcher;
import gov.va.med.term.access.criteria.ObjectOrderByComparator;
import gov.va.med.term.access.readonly.ReadonlyCountry;
import gov.va.med.term.access.util.ImplementorRegistry;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class CountryFactory
implements ReadonlyCountry.Factory {
    private static Timestamp timeWhenCachePrimed_;
    private static final TableManager manager_;
    private ReadonlyCountry.Factory factory_;
    private Map mCache_ = null;
    private Country[] aCache_ = null;
    private Map alpha3CodeCache_ = new TreeMap();
    static /* synthetic */ Class class$gov$va$med$term$access$readonly$ReadonlyCountry$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$Country;

    protected ReadonlyCountry.Factory factory() {
        return this.factory_;
    }

    public CountryFactory() {
        this.factory_ = (ReadonlyCountry.Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$readonly$ReadonlyCountry$Factory == null ? (class$gov$va$med$term$access$readonly$ReadonlyCountry$Factory = CountryFactory.class$("gov.va.med.term.access.readonly.ReadonlyCountry$Factory")) : class$gov$va$med$term$access$readonly$ReadonlyCountry$Factory);
    }

    protected CountryFactory(ReadonlyCountry.Factory factory) {
        this.factory_ = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkCache_() {
        if (this.mCache_ == null) {
            this.initialize_();
            return;
        }
        if (manager_ == null) {
            return;
        }
        if (manager_.isCacheCurrent("STD_Country", timeWhenCachePrimed_)) {
            return;
        }
        Map map = this.alpha3CodeCache_;
        synchronized (map) {
            this.alpha3CodeCache_ = new TreeMap();
            Country[] countryArray = this.aCache_;
            synchronized (this.aCache_) {
                Map map2 = this.mCache_;
                synchronized (map2) {
                    this.mCache_ = null;
                    this.aCache_ = null;
                    this.initialize_();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
    }

    private synchronized void initialize_() {
        if (this.mCache_ != null) {
            return;
        }
        timeWhenCachePrimed_ = new Timestamp(System.currentTimeMillis());
        Country[] a = this.factory_.obtain((Criteria)Criteria.ANY);
        TreeMap<Country.Key, Country> m = new TreeMap<Country.Key, Country>();
        int i = a.length;
        while (--i >= 0) {
            Country object = a[i];
            m.put(object.getKey(), object);
            if (object.getAlpha3Code() == null) continue;
            this.alpha3CodeCache_.put(String.valueOf(object.getAlpha3Code()), object);
        }
        this.mCache_ = m;
        this.aCache_ = a;
    }

    public int count() {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.count((Criteria)criteria);
    }

    public Country[] obtain() {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, 0, Integer.MAX_VALUE, null);
    }

    public Country[] obtain(int first, int max) {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, first, max, null);
    }

    public Country[] obtain(int first, int max, String order) {
        Criteria.ValidTime criteria = new Criteria.ValidTime((Criteria)new Criteria.Equal("isActive", (Object)Boolean.TRUE));
        return this.obtain((Criteria)criteria, first, max, order);
    }

    public int count(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null).length;
    }

    public Country[] obtain(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null);
    }

    public Country[] obtain(Criteria criteria, int first, int max) {
        return this.obtain(criteria, first, max, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Country[] obtain(Criteria criteria, int first, int max, String order) {
        this.checkCache_();
        Country[] countryArray = this.aCache_;
        synchronized (this.aCache_) {
            Object[] instances = (Country[])this.aCache_.clone();
            if (order != null) {
                ObjectOrderByComparator comparator = new ObjectOrderByComparator(class$gov$va$med$term$access$Country == null ? (class$gov$va$med$term$access$Country = CountryFactory.class$("gov.va.med.term.access.Country")) : class$gov$va$med$term$access$Country, order);
                Arrays.sort(instances, comparator);
            }
            Vector<Object> matchingInstances = new Vector<Object>();
            matchingInstances.addAll(Arrays.asList(ObjectMatcher.filter((Criteria)criteria, (Object[])instances)));
            Country[] result = new Country[]{};
            if (first < matchingInstances.size()) {
                result = matchingInstances.subList(first, Math.min(matchingInstances.size(), first + max)).toArray(result);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Country obtain(Country.Key key) {
        this.checkCache_();
        Map map = this.mCache_;
        synchronized (map) {
            return (Country)this.mCache_.get(key);
        }
    }

    public Country obtainFromKeyString(String s) {
        return this.obtain(ReadonlyCountry.Key.valueOf(s));
    }

    public Country obtainFromKeyValue(Long keyValue) {
        return this.obtain(new ReadonlyCountry.Key(keyValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Country obtainByAlpha3Code(String alpha3Code) {
        this.checkCache_();
        Map map = this.alpha3CodeCache_;
        synchronized (map) {
            return (Country)this.alpha3CodeCache_.get(CountryFactory.alpha3CodeCacheKey(alpha3Code));
        }
    }

    private static Object alpha3CodeCacheKey(String alpha3Code) {
        return alpha3Code;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        manager_ = TableManager.factory.obtainByTableName("STD_Country");
    }
}

