/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly.factory.cache;

import gov.va.med.term.access.AdministrativeEntity;
import gov.va.med.term.access.Agency;
import gov.va.med.term.access.Institution;
import gov.va.med.term.access.TableManager;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.criteria.ObjectMatcher;
import gov.va.med.term.access.criteria.ObjectOrderByComparator;
import gov.va.med.term.access.readonly.ReadonlyAdministrativeEntity;
import gov.va.med.term.access.util.ImplementorRegistry;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class AdministrativeEntityFactory
implements ReadonlyAdministrativeEntity.Factory {
    private static Timestamp timeWhenCachePrimed_;
    private static final TableManager manager_;
    private ReadonlyAdministrativeEntity.Factory factory_;
    private Map mCache_ = null;
    private AdministrativeEntity[] aCache_ = null;
    private Map institutionCache_ = new TreeMap();
    private Map agencyCache_ = new TreeMap();
    private Map administrativeParentReferrerCache_ = new TreeMap();
    static /* synthetic */ Class class$gov$va$med$term$access$readonly$ReadonlyAdministrativeEntity$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$AdministrativeEntity;

    protected ReadonlyAdministrativeEntity.Factory factory() {
        return this.factory_;
    }

    public AdministrativeEntityFactory() {
        this.factory_ = (ReadonlyAdministrativeEntity.Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$readonly$ReadonlyAdministrativeEntity$Factory == null ? (class$gov$va$med$term$access$readonly$ReadonlyAdministrativeEntity$Factory = AdministrativeEntityFactory.class$("gov.va.med.term.access.readonly.ReadonlyAdministrativeEntity$Factory")) : class$gov$va$med$term$access$readonly$ReadonlyAdministrativeEntity$Factory);
    }

    protected AdministrativeEntityFactory(ReadonlyAdministrativeEntity.Factory factory) {
        this.factory_ = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkCache_() {
        if (this.mCache_ == null) {
            this.initialize_();
            return;
        }
        if (manager_ == null) {
            return;
        }
        if (manager_.isCacheCurrent("STD_AdministrativeEntity", timeWhenCachePrimed_)) {
            return;
        }
        Map map = this.administrativeParentReferrerCache_;
        synchronized (map) {
            this.administrativeParentReferrerCache_ = new TreeMap();
            Map map2 = this.institutionCache_;
            synchronized (map2) {
                this.institutionCache_ = new TreeMap();
                Map map3 = this.agencyCache_;
                synchronized (map3) {
                    this.agencyCache_ = new TreeMap();
                    AdministrativeEntity[] administrativeEntityArray = this.aCache_;
                    synchronized (this.aCache_) {
                        Map map4 = this.mCache_;
                        synchronized (map4) {
                            this.mCache_ = null;
                            this.aCache_ = null;
                            this.initialize_();
                        }
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                    }
                }
                {
                }
            }
            {
            }
        }
    }

    private synchronized void initialize_() {
        if (this.mCache_ != null) {
            return;
        }
        timeWhenCachePrimed_ = new Timestamp(System.currentTimeMillis());
        AdministrativeEntity[] a = this.factory_.obtain((Criteria)Criteria.ANY);
        TreeMap<AdministrativeEntity.Key, AdministrativeEntity> m = new TreeMap<AdministrativeEntity.Key, AdministrativeEntity>();
        int i = a.length;
        while (--i >= 0) {
            AdministrativeEntity object = a[i];
            m.put(object.getKey(), object);
            if (object.getInstitution() != null) {
                this.institutionCache_.put(String.valueOf(object.getInstitution().getKey()), object);
            }
            if (object.getAgency() == null) continue;
            this.agencyCache_.put(String.valueOf(object.getAgency().getKey()), object);
        }
        this.mCache_ = m;
        this.aCache_ = a;
    }

    public int count() {
        Criteria.Any criteria = Criteria.ANY;
        return this.count((Criteria)criteria);
    }

    public AdministrativeEntity[] obtain() {
        Criteria.Any criteria = Criteria.ANY;
        return this.obtain((Criteria)criteria, 0, Integer.MAX_VALUE, null);
    }

    public AdministrativeEntity[] obtain(int first, int max) {
        Criteria.Any criteria = Criteria.ANY;
        return this.obtain((Criteria)criteria, first, max, null);
    }

    public AdministrativeEntity[] obtain(int first, int max, String order) {
        Criteria.Any criteria = Criteria.ANY;
        return this.obtain((Criteria)criteria, first, max, order);
    }

    public int count(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null).length;
    }

    public AdministrativeEntity[] obtain(Criteria criteria) {
        return this.obtain(criteria, 0, Integer.MAX_VALUE, null);
    }

    public AdministrativeEntity[] obtain(Criteria criteria, int first, int max) {
        return this.obtain(criteria, first, max, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdministrativeEntity[] obtain(Criteria criteria, int first, int max, String order) {
        this.checkCache_();
        AdministrativeEntity[] administrativeEntityArray = this.aCache_;
        synchronized (this.aCache_) {
            Object[] instances = (AdministrativeEntity[])this.aCache_.clone();
            if (order != null) {
                ObjectOrderByComparator comparator = new ObjectOrderByComparator(class$gov$va$med$term$access$AdministrativeEntity == null ? (class$gov$va$med$term$access$AdministrativeEntity = AdministrativeEntityFactory.class$("gov.va.med.term.access.AdministrativeEntity")) : class$gov$va$med$term$access$AdministrativeEntity, order);
                Arrays.sort(instances, comparator);
            }
            Vector<Object> matchingInstances = new Vector<Object>();
            matchingInstances.addAll(Arrays.asList(ObjectMatcher.filter((Criteria)criteria, (Object[])instances)));
            AdministrativeEntity[] result = new AdministrativeEntity[]{};
            if (first < matchingInstances.size()) {
                result = matchingInstances.subList(first, Math.min(matchingInstances.size(), first + max)).toArray(result);
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdministrativeEntity obtain(AdministrativeEntity.Key key) {
        this.checkCache_();
        Map map = this.mCache_;
        synchronized (map) {
            return (AdministrativeEntity)this.mCache_.get(key);
        }
    }

    public AdministrativeEntity obtainFromKeyString(String s) {
        return this.obtain(ReadonlyAdministrativeEntity.Key.valueOf(s));
    }

    public AdministrativeEntity obtainFromKeyValue(Long keyValue) {
        return this.obtain(new ReadonlyAdministrativeEntity.Key(keyValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdministrativeEntity obtainByInstitution(Institution institution) {
        this.checkCache_();
        Map map = this.institutionCache_;
        synchronized (map) {
            return (AdministrativeEntity)this.institutionCache_.get(AdministrativeEntityFactory.institutionCacheKey(institution));
        }
    }

    private static Object institutionCacheKey(Institution institution) {
        return String.valueOf(institution.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdministrativeEntity obtainByAgency(Agency agency) {
        this.checkCache_();
        Map map = this.agencyCache_;
        synchronized (map) {
            return (AdministrativeEntity)this.agencyCache_.get(AdministrativeEntityFactory.agencyCacheKey(agency));
        }
    }

    private static Object agencyCacheKey(Agency agency) {
        return String.valueOf(agency.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdministrativeEntity[] obtainAdministrativeChildren(AdministrativeEntity referrer) {
        Object[] result;
        this.checkCache_();
        Map map = this.administrativeParentReferrerCache_;
        synchronized (map) {
            result = (AdministrativeEntity[])this.administrativeParentReferrerCache_.get(referrer.getKey());
            if (result == null) {
                Long referrerId = referrer.getId();
                Vector<ReadonlyAdministrativeEntity> v = new Vector<ReadonlyAdministrativeEntity>();
                int lim = this.aCache_.length;
                int i = -1;
                while (++i < lim) {
                    ReadonlyAdministrativeEntity current = (ReadonlyAdministrativeEntity)this.aCache_[i];
                    Long currentId = current.getAdministrativeParentKey();
                    if (!referrerId.equals(currentId)) continue;
                    v.addElement(current);
                }
                result = new AdministrativeEntity[v.size()];
                v.copyInto(result);
                this.administrativeParentReferrerCache_.put(referrer.getKey(), result);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        manager_ = TableManager.factory.obtainByTableName("STD_AdministrativeEntity");
    }
}

