/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly;

import gov.va.med.term.access.County;
import gov.va.med.term.access.State;
import gov.va.med.term.access.StatisticalArea;
import gov.va.med.term.access.ZipClassification;
import gov.va.med.term.access.ZipCode;
import gov.va.med.term.access.ZipPlace;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.util.ImplementorRegistry;
import gov.va.med.term.access.util.Is;
import org.apache.log4j.Logger;

public class ReadonlyZipCode
implements ZipCode {
    protected static final Factory factory_ = (Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$ZipCode$Factory == null ? (class$gov$va$med$term$access$ZipCode$Factory = ReadonlyZipCode.class$("gov.va.med.term.access.ZipCode$Factory")) : class$gov$va$med$term$access$ZipCode$Factory);
    private static Logger logger_ = Logger.getLogger((Class)(class$gov$va$med$term$access$ZipCode == null ? (class$gov$va$med$term$access$ZipCode = ReadonlyZipCode.class$("gov.va.med.term.access.ZipCode")) : class$gov$va$med$term$access$ZipCode));
    private Key key_;
    protected Integer version_;
    protected Long id_;
    protected String zipCode_;
    protected ZipPlace[] zipPlaces_ = null;
    protected Long zipClassificationKey_ = null;
    protected Long preferredZipPlaceKey_ = null;
    protected Long stateKey_ = null;
    protected String countyNumber_;
    static /* synthetic */ Class class$gov$va$med$term$access$ZipCode$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$ZipCode;

    public void setKey(Key value) {
        this.key_ = value;
    }

    public ZipCode.Key getKey() {
        return this.key_;
    }

    public String getKeyString() {
        return this.getKey().toString();
    }

    public Integer getVersion() {
        return this.version_;
    }

    public String getName() {
        return this.getZipCode().toString();
    }

    public Long getId() {
        return this.id_;
    }

    public void setId(Long value) {
        this.id_ = value;
        this.key_ = new Key(value);
    }

    public String getZipCode() {
        return this.zipCode_;
    }

    public void setZipCode(String value) {
        this.zipCode_ = value;
    }

    public ZipPlace[] getZipPlaces() {
        return (ZipPlace[])this.zipPlaces_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZipPlace[] zipPlaces_() {
        ReadonlyZipCode readonlyZipCode = this;
        synchronized (readonlyZipCode) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling ZipPlace.factory.obtainZipPlaces");
            }
            return factory_.obtainZipPlaces(this);
        }
    }

    public void setZipClassificationKey(Long value) {
        this.zipClassificationKey_ = value;
    }

    public Long getZipClassificationKey() {
        return this.zipClassificationKey_;
    }

    public ZipClassification getZipClassification() {
        if (this.zipClassificationKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling ZipClassification.factory.obtainFromKeyValue(" + this.zipClassificationKey_ + ")"));
            }
            return ZipClassification.factory.obtainFromKeyValue(this.zipClassificationKey_);
        }
        return null;
    }

    public void setPreferredZipPlaceKey(Long value) {
        this.preferredZipPlaceKey_ = value;
    }

    public Long getPreferredZipPlaceKey() {
        return this.preferredZipPlaceKey_;
    }

    public ZipPlace getPreferredZipPlace() {
        if (this.preferredZipPlaceKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling ZipPlace.factory.obtainFromKeyValue(" + this.preferredZipPlaceKey_ + ")"));
            }
            return ZipPlace.factory.obtainFromKeyValue(this.preferredZipPlaceKey_);
        }
        return null;
    }

    public void setStateKey(Long value) {
        this.stateKey_ = value;
    }

    public Long getStateKey() {
        return this.stateKey_;
    }

    public State getState() {
        if (this.stateKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling State.factory.obtainFromKeyValue(" + this.stateKey_ + ")"));
            }
            return State.factory.obtainFromKeyValue(this.stateKey_);
        }
        return null;
    }

    public String getCountyNumber() {
        return this.countyNumber_;
    }

    public void setCountyNumber(String value) {
        this.countyNumber_ = value;
    }

    public County getCounty() {
        String countyNbr = this.getCountyNumber();
        if (countyNbr == null) {
            return null;
        }
        County county = County.factory.obtainByNumber(this.getState(), countyNbr);
        return county;
    }

    public StatisticalArea getStatisticalArea() {
        County county = this.getCounty();
        if (county == null) {
            return null;
        }
        StatisticalArea[] statisticalAreas = county.getStatisticalAreas();
        return statisticalAreas == null || statisticalAreas.length == 0 ? null : statisticalAreas[0];
    }

    public boolean equals(Object o) {
        ZipPlace[] otherZipPlaces;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadonlyZipCode other = (ReadonlyZipCode)o;
        if (!Is.equal((Object)this.getKey(), (Object)other.getKey())) {
            return false;
        }
        if (!Is.equal((Object)this.getId(), (Object)other.getId())) {
            return false;
        }
        if (!Is.equal((Object)this.getZipCode(), (Object)other.getZipCode())) {
            return false;
        }
        ZipPlace[] thisZipPlaces = this.getZipPlaces();
        int i = thisZipPlaces.length;
        if (i != (otherZipPlaces = other.getZipPlaces()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisZipPlaces[i].getKey(), (Object)otherZipPlaces[i].getKey())) continue;
            return false;
        }
        if (!Is.equal((Object)this.zipClassificationKey_, (Object)other.zipClassificationKey_)) {
            return false;
        }
        if (!Is.equal((Object)this.preferredZipPlaceKey_, (Object)other.preferredZipPlaceKey_)) {
            return false;
        }
        if (!Is.equal((Object)this.stateKey_, (Object)other.stateKey_)) {
            return false;
        }
        return Is.equal((Object)this.getCountyNumber(), (Object)other.getCountyNumber());
    }

    public int hashCode() {
        return this.key_ == null ? 0 : this.key_.hashCode();
    }

    public Object clone() {
        try {
            ReadonlyZipCode result = (ReadonlyZipCode)super.clone();
            return result;
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException("Unexpected error in clone: ", x);
        }
    }

    public static ReadonlyZipCode valueOf(String s) {
        return ReadonlyZipCode.obtainFromKeyString(s);
    }

    public int compareTo(Object o) {
        int result = 0;
        ReadonlyZipCode other = (ReadonlyZipCode)o;
        String value = this.getZipCode();
        String otherValue = other.getZipCode();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public static ReadonlyZipCode[] obtain() {
        return (ReadonlyZipCode[])factory_.obtain();
    }

    public static ReadonlyZipCode[] obtain(int first, int max) {
        return (ReadonlyZipCode[])factory_.obtain(first, max);
    }

    public static ReadonlyZipCode[] obtain(int first, int max, String order) {
        return (ReadonlyZipCode[])factory_.obtain(first, max, order);
    }

    public static ReadonlyZipCode obtain(ZipCode.Key key) {
        return (ReadonlyZipCode)factory_.obtain(key);
    }

    public static ReadonlyZipCode obtainByZipCode(String zipCode) {
        return (ReadonlyZipCode)factory_.obtainByZipCode(zipCode);
    }

    public static ReadonlyZipCode obtainFromKeyString(String s) {
        return (ReadonlyZipCode)factory_.obtainFromKeyString(s);
    }

    public static ReadonlyZipCode obtainFromKeyValue(Long keyValue) {
        return (ReadonlyZipCode)factory_.obtainFromKeyValue(keyValue);
    }

    public static ReadonlyZipCode[] obtain(Criteria criteria) {
        return (ReadonlyZipCode[])factory_.obtain(criteria);
    }

    public static ReadonlyZipCode[] obtain(Criteria criteria, int first, int max) {
        return (ReadonlyZipCode[])factory_.obtain(criteria, first, max);
    }

    public static ReadonlyZipCode[] obtain(Criteria criteria, int first, int max, String order) {
        return (ReadonlyZipCode[])factory_.obtain(criteria, first, max, order);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ReadonlyZipCode@");
        buf.append(System.identityHashCode(this));
        buf.append("[");
        buf.append("key=");
        buf.append(this.key_);
        buf.append(',');
        buf.append("id=");
        buf.append(String.valueOf(this.getId()));
        buf.append(',');
        buf.append("zipCode=");
        buf.append(String.valueOf(this.getZipCode()));
        buf.append(',');
        buf.append("zipClassification=");
        ZipClassification thisZipClassification = this.getZipClassification();
        if (thisZipClassification == null) {
            buf.append("null");
        } else {
            buf.append(thisZipClassification.getKey());
            buf.append('(');
            buf.append(thisZipClassification.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("preferredZipPlace=");
        ZipPlace thisPreferredZipPlace = this.getPreferredZipPlace();
        if (thisPreferredZipPlace == null) {
            buf.append("null");
        } else {
            buf.append(thisPreferredZipPlace.getKey());
            buf.append('(');
            buf.append(thisPreferredZipPlace.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("state=");
        State thisState = this.getState();
        if (thisState == null) {
            buf.append("null");
        } else {
            buf.append(thisState.getKey());
            buf.append('(');
            buf.append(thisState.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("countyNumber=");
        buf.append(String.valueOf(this.getCountyNumber()));
        buf.append(',');
        buf.append("county=");
        County thisCounty = this.getCounty();
        if (thisCounty == null) {
            buf.append("null");
        } else {
            buf.append(thisCounty.getKey());
            buf.append('(');
            buf.append(thisCounty.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("statisticalArea=");
        StatisticalArea thisStatisticalArea = this.getStatisticalArea();
        if (thisStatisticalArea == null) {
            buf.append("null");
        } else {
            buf.append(thisStatisticalArea.getKey());
            buf.append('(');
            buf.append(thisStatisticalArea.getName());
            buf.append(')');
        }
        buf.append(']');
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Factory
    extends ZipCode.Factory {
        public ZipPlace[] obtainZipPlaces(ZipCode var1);
    }

    public static class Key
    implements ZipCode.Key,
    Comparable {
        private final Long value_;
        private final String sValue_;

        public Key(int value) {
            this.value_ = new Long(value);
            this.sValue_ = String.valueOf(value);
        }

        public Key(Long value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public int hashCode() {
            return this.value_.hashCode();
        }

        public boolean equals(Object other) {
            return other != null && other.getClass() == this.getClass() && ((Key)other).value_.equals(this.value_);
        }

        public Long value() {
            return this.value_;
        }

        public static Key valueOf(String keyString) {
            return new Key(Long.valueOf(keyString));
        }

        public int compareTo(Object other) {
            return this.value_.compareTo(((Key)other).value_);
        }

        public String toString() {
            return this.sValue_;
        }
    }
}

