/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly;

import gov.va.med.term.access.TableManager;
import gov.va.med.term.access.util.ImplementorRegistry;
import gov.va.med.term.access.util.Is;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class ReadonlyTableManager
implements TableManager {
    private static Logger logger_ = Logger.getLogger((Class)(class$gov$va$med$term$access$readonly$ReadonlyTableManager == null ? (class$gov$va$med$term$access$readonly$ReadonlyTableManager = ReadonlyTableManager.class$("gov.va.med.term.access.readonly.ReadonlyTableManager")) : class$gov$va$med$term$access$readonly$ReadonlyTableManager));
    private static Map tableNameCache_ = new TreeMap();
    private static Map tableStatsCache_ = new TreeMap();
    private static final long TABLE_MANAGER_CHECK_INTERVAL = 3600000L;
    protected static final Factory factory_ = (Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$TableManager == null ? (class$gov$va$med$term$access$TableManager = ReadonlyTableManager.class$("gov.va.med.term.access.TableManager")) : class$gov$va$med$term$access$TableManager);
    private Key key_;
    protected Long id_;
    protected String tableName_;
    protected String releaseNumber_;
    protected String releaseDate_;
    protected String lastPopulated_;
    protected Timestamp lastUpdated_;
    static /* synthetic */ Class class$gov$va$med$term$access$readonly$ReadonlyTableManager;
    static /* synthetic */ Class class$gov$va$med$term$access$TableManager;

    public void setKey(Key value) {
        this.key_ = value;
    }

    public TableManager.Key getKey() {
        return this.key_;
    }

    public String getKeyString() {
        return this.getKey().toString();
    }

    public String getName() {
        return this.getTableName();
    }

    public Long getId() {
        return this.id_;
    }

    public void setId(Long value) {
        this.id_ = value;
        this.key_ = new Key(value);
    }

    public String getTableName() {
        return this.tableName_;
    }

    public void setTableName(String value) {
        this.tableName_ = value;
    }

    public String getReleaseNumber() {
        return this.releaseNumber_;
    }

    public void setReleaseNumber(String value) {
        this.releaseNumber_ = value;
    }

    public String getReleaseDate() {
        return this.releaseDate_;
    }

    public void setReleaseDate(String value) {
        this.releaseDate_ = value;
    }

    public String getLastPopulated() {
        return this.lastPopulated_;
    }

    public void setLastPopulated(String value) {
        this.lastPopulated_ = value;
    }

    public Timestamp getLastUpdated() {
        return this.lastUpdated_;
    }

    public void setLastUpdated(Timestamp value) {
        this.lastUpdated_ = value;
    }

    public boolean isCacheCurrent(String tableName, Timestamp lastRead) {
        Long longCount;
        long currentTimeMillis = System.currentTimeMillis();
        Timestamp nextTimeToCheck = (Timestamp)tableNameCache_.get(tableName);
        if (nextTimeToCheck == null) {
            nextTimeToCheck = new Timestamp(currentTimeMillis + 3600000L);
            if (logger_.isInfoEnabled()) {
                logger_.info((Object)("Registering first cache check for : " + tableName + " at: " + nextTimeToCheck));
            }
            tableNameCache_.put(tableName, nextTimeToCheck);
        }
        if ((longCount = (Long)tableStatsCache_.get(tableName)) == null) {
            tableStatsCache_.put(tableName, new Long(1L));
        } else {
            long count = longCount;
            tableStatsCache_.put(tableName, new Long(++count));
        }
        Timestamp currentTime = new Timestamp(currentTimeMillis);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("Checking cache for : " + tableName + " at: " + currentTime + " against last time primed:" + lastRead));
        }
        if (nextTimeToCheck.after(currentTime)) {
            return true;
        }
        nextTimeToCheck = new Timestamp(currentTimeMillis + 3600000L);
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("Registering next cache check for : " + tableName + " at: " + nextTimeToCheck));
        }
        tableNameCache_.put(tableName, nextTimeToCheck);
        TableManager manager = TableManager.factory.obtainByTableName(tableName);
        if (manager == null) {
            logger_.warn((Object)("No TableManager found for : " + tableName + " !"));
            return true;
        }
        if (manager.getLastUpdated().after(lastRead)) {
            logger_.warn((Object)("Cache for " + tableName + " is stale " + "- table updated at " + manager.getLastUpdated() + " but cache primed at " + lastRead));
            return false;
        }
        return true;
    }

    public synchronized void printStats() {
        Set statSet = tableStatsCache_.entrySet();
        logger_.info((Object)"Table Manager stats:");
        Iterator i = statSet.iterator();
        while (i.hasNext()) {
            Map.Entry map = i.next();
            logger_.info((Object)("Table:" + map.getKey() + " has " + (Long)map.getValue() + " Factory calls."));
        }
    }

    public synchronized void clearStats() {
        tableStatsCache_.clear();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadonlyTableManager other = (ReadonlyTableManager)o;
        if (!Is.equal((Object)this.getKey(), (Object)other.getKey())) {
            return false;
        }
        if (!Is.equal((Object)this.getId(), (Object)other.getId())) {
            return false;
        }
        if (!Is.equal((Object)this.getTableName(), (Object)other.getTableName())) {
            return false;
        }
        if (!Is.equal((Object)this.getReleaseNumber(), (Object)other.getReleaseNumber())) {
            return false;
        }
        if (!Is.equal((Object)this.getReleaseDate(), (Object)other.getReleaseDate())) {
            return false;
        }
        if (!Is.equal((Object)this.getLastPopulated(), (Object)other.getLastPopulated())) {
            return false;
        }
        return Is.equal((Object)this.getLastUpdated(), (Object)other.getLastUpdated());
    }

    public int hashCode() {
        return this.key_ == null ? 0 : this.key_.hashCode();
    }

    public Object clone() {
        try {
            ReadonlyTableManager result = (ReadonlyTableManager)super.clone();
            return result;
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException("Unexpected error in clone: ", x);
        }
    }

    public static ReadonlyTableManager valueOf(String s) {
        return ReadonlyTableManager.obtainFromKeyString(s);
    }

    public int compareTo(Object o) {
        int result = 0;
        ReadonlyTableManager other = (ReadonlyTableManager)o;
        String value = this.getTableName();
        String otherValue = other.getTableName();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public static ReadonlyTableManager[] obtain() {
        return (ReadonlyTableManager[])factory_.obtain();
    }

    public static ReadonlyTableManager obtain(TableManager.Key key) {
        return (ReadonlyTableManager)factory_.obtain(key);
    }

    public static ReadonlyTableManager obtainByTableName(String tableName) {
        return (ReadonlyTableManager)factory_.obtainByTableName(tableName);
    }

    public static ReadonlyTableManager obtainFromKeyString(String s) {
        return (ReadonlyTableManager)factory_.obtainFromKeyString(s);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ReadonlyTableManager@");
        buf.append(System.identityHashCode(this));
        buf.append("[");
        buf.append("key=");
        buf.append(this.key_);
        buf.append(',');
        buf.append("id=");
        buf.append(String.valueOf(this.getId()));
        buf.append(',');
        buf.append("tableName=");
        buf.append(String.valueOf(this.getTableName()));
        buf.append(',');
        buf.append("releaseNumber=");
        buf.append(String.valueOf(this.getReleaseNumber()));
        buf.append(',');
        buf.append("releaseDate=");
        buf.append(String.valueOf(this.getReleaseDate()));
        buf.append(',');
        buf.append("lastPopulated=");
        buf.append(String.valueOf(this.getLastPopulated()));
        buf.append(',');
        buf.append("lastUpdated=");
        buf.append(String.valueOf(this.getLastUpdated()));
        buf.append(']');
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Factory
    extends TableManager.Factory {
    }

    public static class Key
    implements TableManager.Key,
    Comparable {
        private final Long value_;
        private final String sValue_;

        public Key(int value) {
            this.value_ = new Long(value);
            this.sValue_ = String.valueOf(value);
        }

        public Key(Long value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public int hashCode() {
            return this.value_.hashCode();
        }

        public boolean equals(Object other) {
            return other != null && other.getClass() == this.getClass() && ((Key)other).value_.equals(this.value_);
        }

        public Long value() {
            return this.value_;
        }

        public static Key valueOf(String keyString) {
            return new Key(Long.valueOf(keyString));
        }

        public int compareTo(Object other) {
            return this.value_.compareTo(((Key)other).value_);
        }

        public String toString() {
            return this.sValue_;
        }
    }
}

