/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly;

import gov.va.med.term.access.County;
import gov.va.med.term.access.StatisticalArea;
import gov.va.med.term.access.StatisticalAreaHistory;
import gov.va.med.term.access.StatisticalAreaType;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.readonly.ReadonlyStatisticalAreaHistory;
import gov.va.med.term.access.util.ImplementorRegistry;
import gov.va.med.term.access.util.Is;
import java.sql.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ReadonlyStatisticalArea
implements StatisticalArea {
    protected static final Factory factory_ = (Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$StatisticalArea$Factory == null ? (class$gov$va$med$term$access$StatisticalArea$Factory = ReadonlyStatisticalArea.class$("gov.va.med.term.access.StatisticalArea$Factory")) : class$gov$va$med$term$access$StatisticalArea$Factory);
    private static Logger logger_ = Logger.getLogger((Class)(class$gov$va$med$term$access$StatisticalArea == null ? (class$gov$va$med$term$access$StatisticalArea = ReadonlyStatisticalArea.class$("gov.va.med.term.access.StatisticalArea")) : class$gov$va$med$term$access$StatisticalArea));
    private Key key_;
    protected Integer version_;
    protected Long id_;
    protected Integer code_;
    protected String name_;
    protected Long statisticalAreaTypeKey_ = null;
    protected Long parentKey_ = null;
    protected StatisticalArea[] children_ = null;
    protected County[] counties_ = null;
    protected StatisticalAreaHistory[] history_ = null;
    static /* synthetic */ Class class$gov$va$med$term$access$StatisticalArea$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$StatisticalArea;

    public void setKey(Key value) {
        this.key_ = value;
    }

    public StatisticalArea.Key getKey() {
        return this.key_;
    }

    public String getKeyString() {
        return this.getKey().toString();
    }

    public Integer getVersion() {
        return this.version_;
    }

    public Long getId() {
        return this.id_;
    }

    public void setId(Long value) {
        this.id_ = value;
        this.key_ = new Key(value);
    }

    public Integer getCode() {
        return this.code_;
    }

    public void setCode(Integer value) {
        this.code_ = value;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String value) {
        this.name_ = value;
    }

    public void setStatisticalAreaTypeKey(Long value) {
        this.statisticalAreaTypeKey_ = value;
    }

    public Long getStatisticalAreaTypeKey() {
        return this.statisticalAreaTypeKey_;
    }

    public StatisticalAreaType getStatisticalAreaType() {
        if (this.statisticalAreaTypeKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling StatisticalAreaType.factory.obtainFromKeyValue(" + this.statisticalAreaTypeKey_ + ")"));
            }
            return StatisticalAreaType.factory.obtainFromKeyValue(this.statisticalAreaTypeKey_);
        }
        return null;
    }

    public void setParentKey(Long value) {
        this.parentKey_ = value;
    }

    public Long getParentKey() {
        return this.parentKey_;
    }

    public StatisticalArea getParent() {
        if (this.parentKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling StatisticalArea.factory.obtainFromKeyValue(" + this.parentKey_ + ")"));
            }
            return StatisticalArea.factory.obtainFromKeyValue(this.parentKey_);
        }
        return null;
    }

    public boolean isAMetropolitanArea() {
        return "METRO SA".equals(this.getStatisticalAreaType().getCode());
    }

    public boolean isAMicropolitanArea() {
        return "MICRO SA".equals(this.getStatisticalAreaType().getCode());
    }

    public StatisticalArea[] getChildren() {
        Date now = new Date(System.currentTimeMillis());
        return this.getChildren(true, now);
    }

    public StatisticalArea[] getChildren(boolean isActive, Date when) {
        StatisticalArea[] instances = this.getChildrenRaw();
        Vector<StatisticalArea> activeInstances = new Vector<StatisticalArea>();
        for (int i = 0; i < instances.length; ++i) {
            StatisticalArea instance = instances[i];
            if (instance.isActive(when) != isActive) continue;
            activeInstances.add(instance);
        }
        return activeInstances.toArray(new StatisticalArea[0]);
    }

    public StatisticalArea[] getChildrenRaw() {
        return (StatisticalArea[])this.children_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatisticalArea[] children_() {
        ReadonlyStatisticalArea readonlyStatisticalArea = this;
        synchronized (readonlyStatisticalArea) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling .factory.obtainChildren(this)");
            }
            return ((Factory)StatisticalArea.factory).obtainChildren(this);
        }
    }

    public County[] getCounties() {
        Date now = new Date(System.currentTimeMillis());
        return this.getCounties(true, now);
    }

    public County[] getCounties(boolean isActive, Date when) {
        County[] instances = this.getCountiesRaw();
        Vector<County> activeInstances = new Vector<County>();
        for (int i = 0; i < instances.length; ++i) {
            County instance = instances[i];
            if (instance.isActive(when) != isActive) continue;
            activeInstances.add(instance);
        }
        return activeInstances.toArray(new County[0]);
    }

    public County[] getCountiesRaw() {
        return (County[])this.counties_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private County[] counties_() {
        ReadonlyStatisticalArea readonlyStatisticalArea = this;
        synchronized (readonlyStatisticalArea) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling County.factory.obtainCounties");
            }
            return factory_.obtainCounties(this);
        }
    }

    public boolean isActive() {
        return this.isActive(new Date(System.currentTimeMillis()));
    }

    public StatisticalAreaHistory[] getHistory() {
        return (StatisticalAreaHistory[])this.history_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatisticalAreaHistory[] history_() {
        ReadonlyStatisticalArea readonlyStatisticalArea = this;
        synchronized (readonlyStatisticalArea) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling StatisticalAreaHistory.factory.obtain(this)");
            }
            return ((ReadonlyStatisticalAreaHistory.Factory)StatisticalAreaHistory.factory).obtain(this);
        }
    }

    public boolean isActive(Date when) {
        StatisticalAreaHistory[] history = this.getHistory();
        for (int i = 0; i < history.length; ++i) {
            StatisticalAreaHistory entry = history[i];
            Date effectiveDate = entry.getEffectiveDate();
            Date expirationDate = entry.getExpirationDate();
            if (!effectiveDate.before(when) && !effectiveDate.equals(when) || !when.before(expirationDate)) continue;
            return entry.isActive();
        }
        return false;
    }

    public boolean equals(Object o) {
        StatisticalAreaHistory[] otherHistory;
        County[] otherCounties;
        StatisticalArea[] otherChildren;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadonlyStatisticalArea other = (ReadonlyStatisticalArea)o;
        if (!Is.equal((Object)this.getKey(), (Object)other.getKey())) {
            return false;
        }
        if (!Is.equal((Object)this.getId(), (Object)other.getId())) {
            return false;
        }
        if (!Is.equal((Object)this.getCode(), (Object)other.getCode())) {
            return false;
        }
        if (!Is.equal((Object)this.getName(), (Object)other.getName())) {
            return false;
        }
        if (!Is.equal((Object)this.statisticalAreaTypeKey_, (Object)other.statisticalAreaTypeKey_)) {
            return false;
        }
        if (!Is.equal((Object)this.parentKey_, (Object)other.parentKey_)) {
            return false;
        }
        StatisticalArea[] thisChildren = this.getChildren();
        int i = thisChildren.length;
        if (i != (otherChildren = other.getChildren()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisChildren[i].getKey(), (Object)otherChildren[i].getKey())) continue;
            return false;
        }
        County[] thisCounties = this.getCounties();
        i = thisCounties.length;
        if (i != (otherCounties = other.getCounties()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisCounties[i].getKey(), (Object)otherCounties[i].getKey())) continue;
            return false;
        }
        StatisticalAreaHistory[] thisHistory = this.getHistory();
        i = thisHistory.length;
        if (i != (otherHistory = other.getHistory()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisHistory[i].getKey(), (Object)otherHistory[i].getKey())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.key_ == null ? 0 : this.key_.hashCode();
    }

    public Object clone() {
        try {
            ReadonlyStatisticalArea result = (ReadonlyStatisticalArea)super.clone();
            return result;
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException("Unexpected error in clone: ", x);
        }
    }

    public static ReadonlyStatisticalArea valueOf(String s) {
        return ReadonlyStatisticalArea.obtainFromKeyString(s);
    }

    public int compareTo(Object o) {
        int result = 0;
        ReadonlyStatisticalArea other = (ReadonlyStatisticalArea)o;
        String value = this.getName();
        String otherValue = other.getName();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public static ReadonlyStatisticalArea[] obtain() {
        return (ReadonlyStatisticalArea[])factory_.obtain();
    }

    public static ReadonlyStatisticalArea[] obtain(int first, int max) {
        return (ReadonlyStatisticalArea[])factory_.obtain(first, max);
    }

    public static ReadonlyStatisticalArea[] obtain(int first, int max, String order) {
        return (ReadonlyStatisticalArea[])factory_.obtain(first, max, order);
    }

    public static ReadonlyStatisticalArea obtain(StatisticalArea.Key key) {
        return (ReadonlyStatisticalArea)factory_.obtain(key);
    }

    public static ReadonlyStatisticalArea obtainByCode(Integer code) {
        return (ReadonlyStatisticalArea)factory_.obtainByCode(code);
    }

    public static ReadonlyStatisticalArea obtainFromKeyString(String s) {
        return (ReadonlyStatisticalArea)factory_.obtainFromKeyString(s);
    }

    public static ReadonlyStatisticalArea obtainFromKeyValue(Long keyValue) {
        return (ReadonlyStatisticalArea)factory_.obtainFromKeyValue(keyValue);
    }

    public static ReadonlyStatisticalArea[] obtain(Criteria criteria) {
        return (ReadonlyStatisticalArea[])factory_.obtain(criteria);
    }

    public static ReadonlyStatisticalArea[] obtain(Criteria criteria, int first, int max) {
        return (ReadonlyStatisticalArea[])factory_.obtain(criteria, first, max);
    }

    public static ReadonlyStatisticalArea[] obtain(Criteria criteria, int first, int max, String order) {
        return (ReadonlyStatisticalArea[])factory_.obtain(criteria, first, max, order);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ReadonlyStatisticalArea@");
        buf.append(System.identityHashCode(this));
        buf.append("[");
        buf.append("key=");
        buf.append(this.key_);
        buf.append(',');
        buf.append("id=");
        buf.append(String.valueOf(this.getId()));
        buf.append(',');
        buf.append("code=");
        buf.append(String.valueOf(this.getCode()));
        buf.append(',');
        buf.append("name=");
        buf.append(String.valueOf(this.getName()));
        buf.append(',');
        buf.append("statisticalAreaType=");
        StatisticalAreaType thisStatisticalAreaType = this.getStatisticalAreaType();
        if (thisStatisticalAreaType == null) {
            buf.append("null");
        } else {
            buf.append(thisStatisticalAreaType.getKey());
            buf.append('(');
            buf.append(thisStatisticalAreaType.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("parent=");
        StatisticalArea thisParent = this.getParent();
        if (thisParent == null) {
            buf.append("null");
        } else {
            buf.append(thisParent.getKey());
            buf.append('(');
            buf.append(thisParent.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("isAMetropolitanArea=");
        buf.append(String.valueOf(this.isAMetropolitanArea()));
        buf.append(',');
        buf.append("isAMicropolitanArea=");
        buf.append(String.valueOf(this.isAMicropolitanArea()));
        buf.append(',');
        buf.append("isActive=");
        buf.append(String.valueOf(this.isActive()));
        buf.append(',');
        buf.append("history=");
        buf.append('{');
        StatisticalAreaHistory[] elements = this.getHistory();
        int i = -1;
        while (++i < elements.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(elements[i].getKey());
            buf.append('(');
            buf.append(elements[i].getName());
            buf.append(')');
        }
        buf.append('}');
        buf.append(']');
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Factory
    extends StatisticalArea.Factory {
        public StatisticalArea[] obtainChildren(StatisticalArea var1);

        public County[] obtainCounties(StatisticalArea var1);
    }

    public static class Key
    implements StatisticalArea.Key,
    Comparable {
        private final Long value_;
        private final String sValue_;

        public Key(int value) {
            this.value_ = new Long(value);
            this.sValue_ = String.valueOf(value);
        }

        public Key(Long value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public int hashCode() {
            return this.value_.hashCode();
        }

        public boolean equals(Object other) {
            return other != null && other.getClass() == this.getClass() && ((Key)other).value_.equals(this.value_);
        }

        public Long value() {
            return this.value_;
        }

        public static Key valueOf(String keyString) {
            return new Key(Long.valueOf(keyString));
        }

        public int compareTo(Object other) {
            return this.value_.compareTo(((Key)other).value_);
        }

        public String toString() {
            return this.sValue_;
        }
    }
}

