/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly;

import gov.va.med.term.access.Country;
import gov.va.med.term.access.County;
import gov.va.med.term.access.State;
import gov.va.med.term.access.StateHistory;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.readonly.ReadonlyCounty;
import gov.va.med.term.access.readonly.ReadonlyStateHistory;
import gov.va.med.term.access.util.ImplementorRegistry;
import gov.va.med.term.access.util.Is;
import java.sql.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ReadonlyState
implements State {
    protected static final Factory factory_ = (Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$State$Factory == null ? (class$gov$va$med$term$access$State$Factory = ReadonlyState.class$("gov.va.med.term.access.State$Factory")) : class$gov$va$med$term$access$State$Factory);
    private static Logger logger_ = Logger.getLogger((Class)(class$gov$va$med$term$access$State == null ? (class$gov$va$med$term$access$State = ReadonlyState.class$("gov.va.med.term.access.State")) : class$gov$va$med$term$access$State));
    private Key key_;
    protected Integer version_;
    protected Long id_;
    protected String name_;
    protected String postalName_;
    protected String fipsCode_;
    protected Long countryKey_ = null;
    protected County[] counties_ = null;
    protected StateHistory[] history_ = null;
    static /* synthetic */ Class class$gov$va$med$term$access$State$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$State;

    public void setKey(Key value) {
        this.key_ = value;
    }

    public State.Key getKey() {
        return this.key_;
    }

    public String getKeyString() {
        return this.getKey().toString();
    }

    public Integer getVersion() {
        return this.version_;
    }

    public Long getId() {
        return this.id_;
    }

    public void setId(Long value) {
        this.id_ = value;
        this.key_ = new Key(value);
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String value) {
        this.name_ = value;
    }

    public String getPostalName() {
        return this.postalName_;
    }

    public void setPostalName(String value) {
        this.postalName_ = value;
    }

    public String getFipsCode() {
        return this.fipsCode_;
    }

    public void setFipsCode(String value) {
        this.fipsCode_ = value;
    }

    public void setCountryKey(Long value) {
        this.countryKey_ = value;
    }

    public Long getCountryKey() {
        return this.countryKey_;
    }

    public Country getCountry() {
        if (this.countryKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling Country.factory.obtainFromKeyValue(" + this.countryKey_ + ")"));
            }
            return Country.factory.obtainFromKeyValue(this.countryKey_);
        }
        return null;
    }

    public County[] getCounties() {
        Date now = new Date(System.currentTimeMillis());
        return this.getCounties(true, now);
    }

    public County[] getCounties(boolean isActive, Date when) {
        County[] instances = this.getCountiesRaw();
        Vector<County> activeInstances = new Vector<County>();
        for (int i = 0; i < instances.length; ++i) {
            County instance = instances[i];
            if (instance.isActive(when) != isActive) continue;
            activeInstances.add(instance);
        }
        return activeInstances.toArray(new County[0]);
    }

    public County[] getCountiesRaw() {
        return (County[])this.counties_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private County[] counties_() {
        ReadonlyState readonlyState = this;
        synchronized (readonlyState) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling County.factory.obtain(this)");
            }
            return ((ReadonlyCounty.Factory)County.factory).obtain(this);
        }
    }

    public boolean isActive() {
        return this.isActive(new Date(System.currentTimeMillis()));
    }

    public StateHistory[] getHistory() {
        return (StateHistory[])this.history_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StateHistory[] history_() {
        ReadonlyState readonlyState = this;
        synchronized (readonlyState) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling StateHistory.factory.obtain(this)");
            }
            return ((ReadonlyStateHistory.Factory)StateHistory.factory).obtain(this);
        }
    }

    public boolean isActive(Date when) {
        StateHistory[] history = this.getHistory();
        for (int i = 0; i < history.length; ++i) {
            StateHistory entry = history[i];
            Date effectiveDate = entry.getEffectiveDate();
            Date expirationDate = entry.getExpirationDate();
            if (!effectiveDate.before(when) && !effectiveDate.equals(when) || !when.before(expirationDate)) continue;
            return entry.isActive();
        }
        return false;
    }

    public boolean equals(Object o) {
        StateHistory[] otherHistory;
        County[] otherCounties;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadonlyState other = (ReadonlyState)o;
        if (!Is.equal((Object)this.getKey(), (Object)other.getKey())) {
            return false;
        }
        if (!Is.equal((Object)this.getId(), (Object)other.getId())) {
            return false;
        }
        if (!Is.equal((Object)this.getName(), (Object)other.getName())) {
            return false;
        }
        if (!Is.equal((Object)this.getPostalName(), (Object)other.getPostalName())) {
            return false;
        }
        if (!Is.equal((Object)this.getFipsCode(), (Object)other.getFipsCode())) {
            return false;
        }
        if (!Is.equal((Object)this.countryKey_, (Object)other.countryKey_)) {
            return false;
        }
        County[] thisCounties = this.getCounties();
        int i = thisCounties.length;
        if (i != (otherCounties = other.getCounties()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisCounties[i].getKey(), (Object)otherCounties[i].getKey())) continue;
            return false;
        }
        StateHistory[] thisHistory = this.getHistory();
        i = thisHistory.length;
        if (i != (otherHistory = other.getHistory()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisHistory[i].getKey(), (Object)otherHistory[i].getKey())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.key_ == null ? 0 : this.key_.hashCode();
    }

    public Object clone() {
        try {
            ReadonlyState result = (ReadonlyState)super.clone();
            return result;
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException("Unexpected error in clone: ", x);
        }
    }

    public static ReadonlyState valueOf(String s) {
        return ReadonlyState.obtainFromKeyString(s);
    }

    public int compareTo(Object o) {
        int result = 0;
        ReadonlyState other = (ReadonlyState)o;
        String value = this.getName();
        String otherValue = other.getName();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public static ReadonlyState[] obtain() {
        return (ReadonlyState[])factory_.obtain();
    }

    public static ReadonlyState[] obtain(int first, int max) {
        return (ReadonlyState[])factory_.obtain(first, max);
    }

    public static ReadonlyState[] obtain(int first, int max, String order) {
        return (ReadonlyState[])factory_.obtain(first, max, order);
    }

    public static ReadonlyState obtain(State.Key key) {
        return (ReadonlyState)factory_.obtain(key);
    }

    public static ReadonlyState obtainByPostalName(Country country, String postalName) {
        return (ReadonlyState)factory_.obtainByPostalName(country, postalName);
    }

    public static ReadonlyState obtainByName(Country country, String name) {
        return (ReadonlyState)factory_.obtainByName(country, name);
    }

    public static ReadonlyState obtainByFipsCode(Country country, String fipsCode) {
        return (ReadonlyState)factory_.obtainByFipsCode(country, fipsCode);
    }

    public static ReadonlyState obtainFromKeyString(String s) {
        return (ReadonlyState)factory_.obtainFromKeyString(s);
    }

    public static ReadonlyState obtainFromKeyValue(Long keyValue) {
        return (ReadonlyState)factory_.obtainFromKeyValue(keyValue);
    }

    public static ReadonlyState[] obtain(Criteria criteria) {
        return (ReadonlyState[])factory_.obtain(criteria);
    }

    public static ReadonlyState[] obtain(Criteria criteria, int first, int max) {
        return (ReadonlyState[])factory_.obtain(criteria, first, max);
    }

    public static ReadonlyState[] obtain(Criteria criteria, int first, int max, String order) {
        return (ReadonlyState[])factory_.obtain(criteria, first, max, order);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ReadonlyState@");
        buf.append(System.identityHashCode(this));
        buf.append("[");
        buf.append("key=");
        buf.append(this.key_);
        buf.append(',');
        buf.append("id=");
        buf.append(String.valueOf(this.getId()));
        buf.append(',');
        buf.append("name=");
        buf.append(String.valueOf(this.getName()));
        buf.append(',');
        buf.append("postalName=");
        buf.append(String.valueOf(this.getPostalName()));
        buf.append(',');
        buf.append("fipsCode=");
        buf.append(String.valueOf(this.getFipsCode()));
        buf.append(',');
        buf.append("country=");
        Country thisCountry = this.getCountry();
        if (thisCountry == null) {
            buf.append("null");
        } else {
            buf.append(thisCountry.getKey());
            buf.append('(');
            buf.append(thisCountry.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("counties=");
        buf.append('{');
        Comparable[] elements = this.getCounties();
        int i = -1;
        while (++i < elements.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(elements[i].getKey());
            buf.append('(');
            buf.append(elements[i].getName());
            buf.append(')');
        }
        buf.append('}');
        buf.append(',');
        buf.append("isActive=");
        buf.append(String.valueOf(this.isActive()));
        buf.append(',');
        buf.append("history=");
        buf.append('{');
        elements = this.getHistory();
        i = -1;
        while (++i < elements.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(elements[i].getKey());
            buf.append('(');
            buf.append(elements[i].getName());
            buf.append(')');
        }
        buf.append('}');
        buf.append(']');
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Factory
    extends State.Factory {
        public State[] obtain(Country var1);
    }

    public static class Key
    implements State.Key,
    Comparable {
        private final Long value_;
        private final String sValue_;

        public Key(int value) {
            this.value_ = new Long(value);
            this.sValue_ = String.valueOf(value);
        }

        public Key(Long value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public int hashCode() {
            return this.value_.hashCode();
        }

        public boolean equals(Object other) {
            return other != null && other.getClass() == this.getClass() && ((Key)other).value_.equals(this.value_);
        }

        public Long value() {
            return this.value_;
        }

        public static Key valueOf(String keyString) {
            return new Key(Long.valueOf(keyString));
        }

        public int compareTo(Object other) {
            return this.value_.compareTo(((Key)other).value_);
        }

        public String toString() {
            return this.sValue_;
        }
    }
}

