/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly;

import gov.va.med.term.access.Race;
import gov.va.med.term.access.RaceHistory;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.readonly.ReadonlyRaceHistory;
import gov.va.med.term.access.util.ImplementorRegistry;
import gov.va.med.term.access.util.Is;
import java.sql.Date;
import org.apache.log4j.Logger;

public class ReadonlyRace
implements Race {
    protected static final Factory factory_ = (Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$Race$Factory == null ? (class$gov$va$med$term$access$Race$Factory = ReadonlyRace.class$("gov.va.med.term.access.Race$Factory")) : class$gov$va$med$term$access$Race$Factory);
    private static Logger logger_ = Logger.getLogger((Class)(class$gov$va$med$term$access$Race == null ? (class$gov$va$med$term$access$Race = ReadonlyRace.class$("gov.va.med.term.access.Race")) : class$gov$va$med$term$access$Race));
    private Key key_;
    protected Integer version_;
    protected Long id_;
    protected String hl7Code_;
    protected String name_;
    protected String description_;
    protected RaceHistory[] history_ = null;
    static /* synthetic */ Class class$gov$va$med$term$access$Race$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$Race;

    public void setKey(Key value) {
        this.key_ = value;
    }

    public Race.Key getKey() {
        return this.key_;
    }

    public String getKeyString() {
        return this.getKey().toString();
    }

    public Integer getVersion() {
        return this.version_;
    }

    public Long getId() {
        return this.id_;
    }

    public void setId(Long value) {
        this.id_ = value;
        this.key_ = new Key(value);
    }

    public String getHl7Code() {
        return this.hl7Code_;
    }

    public void setHl7Code(String value) {
        this.hl7Code_ = value;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String value) {
        this.name_ = value;
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String value) {
        this.description_ = value;
    }

    public boolean isActive() {
        return this.isActive(new Date(System.currentTimeMillis()));
    }

    public RaceHistory[] getHistory() {
        return (RaceHistory[])this.history_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RaceHistory[] history_() {
        ReadonlyRace readonlyRace = this;
        synchronized (readonlyRace) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling RaceHistory.factory.obtain(this)");
            }
            return ((ReadonlyRaceHistory.Factory)RaceHistory.factory).obtain(this);
        }
    }

    public boolean isActive(Date when) {
        RaceHistory[] history = this.getHistory();
        for (int i = 0; i < history.length; ++i) {
            RaceHistory entry = history[i];
            Date effectiveDate = entry.getEffectiveDate();
            Date expirationDate = entry.getExpirationDate();
            if (!effectiveDate.before(when) && !effectiveDate.equals(when) || !when.before(expirationDate)) continue;
            return entry.isActive();
        }
        return false;
    }

    public boolean equals(Object o) {
        RaceHistory[] otherHistory;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadonlyRace other = (ReadonlyRace)o;
        if (!Is.equal((Object)this.getKey(), (Object)other.getKey())) {
            return false;
        }
        if (!Is.equal((Object)this.getId(), (Object)other.getId())) {
            return false;
        }
        if (!Is.equal((Object)this.getHl7Code(), (Object)other.getHl7Code())) {
            return false;
        }
        if (!Is.equal((Object)this.getName(), (Object)other.getName())) {
            return false;
        }
        if (!Is.equal((Object)this.getDescription(), (Object)other.getDescription())) {
            return false;
        }
        RaceHistory[] thisHistory = this.getHistory();
        int i = thisHistory.length;
        if (i != (otherHistory = other.getHistory()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisHistory[i].getKey(), (Object)otherHistory[i].getKey())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.key_ == null ? 0 : this.key_.hashCode();
    }

    public Object clone() {
        try {
            ReadonlyRace result = (ReadonlyRace)super.clone();
            return result;
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException("Unexpected error in clone: ", x);
        }
    }

    public static ReadonlyRace valueOf(String s) {
        return ReadonlyRace.obtainFromKeyString(s);
    }

    public int compareTo(Object o) {
        int result = 0;
        ReadonlyRace other = (ReadonlyRace)o;
        String value = this.getName();
        String otherValue = other.getName();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public static ReadonlyRace[] obtain() {
        return (ReadonlyRace[])factory_.obtain();
    }

    public static ReadonlyRace[] obtain(int first, int max) {
        return (ReadonlyRace[])factory_.obtain(first, max);
    }

    public static ReadonlyRace[] obtain(int first, int max, String order) {
        return (ReadonlyRace[])factory_.obtain(first, max, order);
    }

    public static ReadonlyRace obtain(Race.Key key) {
        return (ReadonlyRace)factory_.obtain(key);
    }

    public static ReadonlyRace obtainByHl7Code(String hl7Code) {
        return (ReadonlyRace)factory_.obtainByHl7Code(hl7Code);
    }

    public static ReadonlyRace obtainFromKeyString(String s) {
        return (ReadonlyRace)factory_.obtainFromKeyString(s);
    }

    public static ReadonlyRace obtainFromKeyValue(Long keyValue) {
        return (ReadonlyRace)factory_.obtainFromKeyValue(keyValue);
    }

    public static ReadonlyRace[] obtain(Criteria criteria) {
        return (ReadonlyRace[])factory_.obtain(criteria);
    }

    public static ReadonlyRace[] obtain(Criteria criteria, int first, int max) {
        return (ReadonlyRace[])factory_.obtain(criteria, first, max);
    }

    public static ReadonlyRace[] obtain(Criteria criteria, int first, int max, String order) {
        return (ReadonlyRace[])factory_.obtain(criteria, first, max, order);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ReadonlyRace@");
        buf.append(System.identityHashCode(this));
        buf.append("[");
        buf.append("key=");
        buf.append(this.key_);
        buf.append(',');
        buf.append("id=");
        buf.append(String.valueOf(this.getId()));
        buf.append(',');
        buf.append("hl7Code=");
        buf.append(String.valueOf(this.getHl7Code()));
        buf.append(',');
        buf.append("name=");
        buf.append(String.valueOf(this.getName()));
        buf.append(',');
        buf.append("description=");
        buf.append(String.valueOf(this.getDescription()));
        buf.append(',');
        buf.append("isActive=");
        buf.append(String.valueOf(this.isActive()));
        buf.append(',');
        buf.append("history=");
        buf.append('{');
        RaceHistory[] elements = this.getHistory();
        int i = -1;
        while (++i < elements.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(elements[i].getKey());
            buf.append('(');
            buf.append(elements[i].getName());
            buf.append(')');
        }
        buf.append('}');
        buf.append(']');
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Factory
    extends Race.Factory {
    }

    public static class Key
    implements Race.Key,
    Comparable {
        private final Long value_;
        private final String sValue_;

        public Key(int value) {
            this.value_ = new Long(value);
            this.sValue_ = String.valueOf(value);
        }

        public Key(Long value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public int hashCode() {
            return this.value_.hashCode();
        }

        public boolean equals(Object other) {
            return other != null && other.getClass() == this.getClass() && ((Key)other).value_.equals(this.value_);
        }

        public Long value() {
            return this.value_;
        }

        public static Key valueOf(String keyString) {
            return new Key(Long.valueOf(keyString));
        }

        public int compareTo(Object other) {
            return this.value_.compareTo(((Key)other).value_);
        }

        public String toString() {
            return this.sValue_;
        }
    }
}

