/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly;

import gov.va.med.term.access.Address;
import gov.va.med.term.access.Agency;
import gov.va.med.term.access.FacilityType;
import gov.va.med.term.access.Institution;
import gov.va.med.term.access.InstitutionCode;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.readonly.ReadonlyInstitutionCode;
import gov.va.med.term.access.types.Day;
import gov.va.med.term.access.util.ImplementorRegistry;
import gov.va.med.term.access.util.Is;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ReadonlyInstitution
implements Institution {
    protected static final Factory factory_ = (Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$Institution$Factory == null ? (class$gov$va$med$term$access$Institution$Factory = ReadonlyInstitution.class$("gov.va.med.term.access.Institution$Factory")) : class$gov$va$med$term$access$Institution$Factory);
    private static Logger logger_ = Logger.getLogger((Class)(class$gov$va$med$term$access$Institution == null ? (class$gov$va$med$term$access$Institution = ReadonlyInstitution.class$("gov.va.med.term.access.Institution")) : class$gov$va$med$term$access$Institution));
    private Key key_;
    protected Integer version_;
    protected Long id_;
    protected Day activationDate_;
    protected Day deactivationDate_;
    protected String name_;
    protected String stationNumber_;
    protected String vistaName_;
    protected Long agencyKey_ = null;
    protected InstitutionCode[] codes_ = null;
    protected Address streetAddress_;
    protected Address mailingAddress_;
    protected Long facilityTypeKey_ = null;
    protected String mfn_zeg_recipient_;
    protected Institution[] children_ = null;
    protected Long parentKey_ = null;
    protected Long realignedFromKey_ = null;
    protected Long realignedToKey_ = null;
    protected Long visnKey_ = null;
    static /* synthetic */ Class class$gov$va$med$term$access$Institution$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$Institution;

    public void setKey(Key value) {
        this.key_ = value;
    }

    public Institution.Key getKey() {
        return this.key_;
    }

    public String getKeyString() {
        return this.getKey().toString();
    }

    public Integer getVersion() {
        return this.version_;
    }

    public Long getId() {
        return this.id_;
    }

    public void setId(Long value) {
        this.id_ = value;
        this.key_ = new Key(value);
    }

    public Day getActivationDate() {
        return this.activationDate_;
    }

    public void setActivationDate(Day value) {
        this.activationDate_ = value;
    }

    public Day getDeactivationDate() {
        return this.deactivationDate_;
    }

    public void setDeactivationDate(Day value) {
        this.deactivationDate_ = value;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String value) {
        this.name_ = value;
    }

    public String getStationNumber() {
        return this.stationNumber_;
    }

    public void setStationNumber(String value) {
        this.stationNumber_ = value;
    }

    public String getVistaName() {
        return this.vistaName_;
    }

    public void setVistaName(String value) {
        this.vistaName_ = value;
    }

    public void setAgencyKey(Long value) {
        this.agencyKey_ = value;
    }

    public Long getAgencyKey() {
        return this.agencyKey_;
    }

    public Agency getAgency() {
        if (this.agencyKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling Agency.factory.obtainFromKeyValue(" + this.agencyKey_ + ")"));
            }
            return Agency.factory.obtainFromKeyValue(this.agencyKey_);
        }
        return null;
    }

    public InstitutionCode[] getCodes() {
        return (InstitutionCode[])this.codes_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstitutionCode[] codes_() {
        ReadonlyInstitution readonlyInstitution = this;
        synchronized (readonlyInstitution) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling InstitutionCode.factory.obtain(this)");
            }
            return ((ReadonlyInstitutionCode.Factory)InstitutionCode.factory).obtain(this);
        }
    }

    public Address getStreetAddress() {
        return this.streetAddress_;
    }

    public void setStreetAddress(Address value) {
        this.streetAddress_ = value;
    }

    public Address getMailingAddress() {
        return this.mailingAddress_;
    }

    public void setMailingAddress(Address value) {
        this.mailingAddress_ = value;
    }

    public void setFacilityTypeKey(Long value) {
        this.facilityTypeKey_ = value;
    }

    public Long getFacilityTypeKey() {
        return this.facilityTypeKey_;
    }

    public FacilityType getFacilityType() {
        if (this.facilityTypeKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling FacilityType.factory.obtainFromKeyValue(" + this.facilityTypeKey_ + ")"));
            }
            return FacilityType.factory.obtainFromKeyValue(this.facilityTypeKey_);
        }
        return null;
    }

    public String getMfn_zeg_recipient() {
        return this.mfn_zeg_recipient_;
    }

    public void setMfn_zeg_recipient(String value) {
        this.mfn_zeg_recipient_ = value;
    }

    public Institution[] getChildren() {
        return (Institution[])this.children_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Institution[] children_() {
        ReadonlyInstitution readonlyInstitution = this;
        synchronized (readonlyInstitution) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling .factory.obtainChildren(this)");
            }
            return ((Factory)Institution.factory).obtainChildren(this);
        }
    }

    public void setParentKey(Long value) {
        this.parentKey_ = value;
    }

    public Long getParentKey() {
        return this.parentKey_;
    }

    public Institution getParent() {
        if (this.parentKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling Institution.factory.obtainFromKeyValue(" + this.parentKey_ + ")"));
            }
            return Institution.factory.obtainFromKeyValue(this.parentKey_);
        }
        return null;
    }

    public Institution[] getVisns() {
        Criteria.Equal criteria = new Criteria.Equal("facilityType", (Object)FacilityType.factory.obtainByCode("VISN"));
        return Institution.factory.obtain((Criteria)criteria);
    }

    public Institution[] getAllDivisions() {
        Institution[] results = Institution.factory.obtain();
        Vector<Institution> v = new Vector<Institution>();
        for (int i = 0; i < results.length; ++i) {
            if (!results[i].isADivision()) continue;
            v.addElement(results[i]);
        }
        Object[] divisions = new Institution[v.size()];
        v.copyInto(divisions);
        return divisions;
    }

    public Institution[] getVisnDivisions() {
        Institution.Key visnKey;
        if ("VISN".equals(this.getFacilityType().getCode())) {
            visnKey = this.getKey();
        } else {
            if (this.getVisn() == null) {
                return new Institution[0];
            }
            visnKey = this.getVisn().getKey();
        }
        Criteria.Equal visnCriteria = new Criteria.Equal("visn", (Object)Institution.factory.obtain(visnKey));
        Institution[] results = Institution.factory.obtain((Criteria)visnCriteria);
        Vector<Institution> v = new Vector<Institution>();
        for (int i = 0; i < results.length; ++i) {
            if (!results[i].isADivision()) continue;
            v.addElement(results[i]);
        }
        Object[] divisions = new Institution[v.size()];
        v.copyInto(divisions);
        return divisions;
    }

    public Institution[] getDivisions() {
        Institution parent;
        Institution vistaProvider = this.getVistaProvider();
        Object[] divisions = new Institution[]{};
        String Hcs = new String("HCS");
        if (Hcs.equals(this.getFacilityType().getCode())) {
            parent = this;
        } else {
            if (vistaProvider == null) {
                return divisions;
            }
            parent = vistaProvider.getParent();
            if (parent == null) {
                return divisions;
            }
        }
        if (Hcs.equals(parent.getFacilityType().getCode())) {
            Institution[] children = parent.getChildren();
            Vector<Institution> v = new Vector<Institution>();
            int lim = children.length;
            for (int i = 0; i < lim; ++i) {
                if (!children[i].isADivision()) continue;
                v.addElement(children[i]);
            }
            divisions = new Institution[v.size()];
            v.copyInto(divisions);
        } else {
            Institution[] children = vistaProvider.getChildren();
            Vector<Institution> v = new Vector<Institution>();
            int lim = children.length;
            v.addElement(vistaProvider);
            for (int i = 0; i < lim; ++i) {
                if (!children[i].isADivision()) continue;
                v.addElement(children[i]);
            }
            divisions = new Institution[v.size()];
            v.copyInto(divisions);
        }
        return divisions;
    }

    public Institution[] getSiblings() {
        Institution parent = this.getParent();
        Institution[] parentsChildren = new Institution[]{};
        if (parent == null) {
            return parentsChildren;
        }
        parentsChildren = parent.getChildren();
        int childCount = parentsChildren.length;
        if (childCount < 1) {
            return parentsChildren;
        }
        Institution[] siblings = new Institution[childCount - 1];
        if (childCount == 1) {
            return siblings;
        }
        Institution.Key myKey = this.getKey();
        int j = 0;
        for (int i = 0; i < childCount; ++i) {
            if (parentsChildren[i].getKey().equals(myKey)) continue;
            siblings[j++] = parentsChildren[i];
        }
        return siblings;
    }

    public void setRealignedFromKey(Long value) {
        this.realignedFromKey_ = value;
    }

    public Long getRealignedFromKey() {
        return this.realignedFromKey_;
    }

    public Institution getRealignedFrom() {
        if (this.realignedFromKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling Institution.factory.obtainFromKeyValue(" + this.realignedFromKey_ + ")"));
            }
            return Institution.factory.obtainFromKeyValue(this.realignedFromKey_);
        }
        return null;
    }

    public void setRealignedToKey(Long value) {
        this.realignedToKey_ = value;
    }

    public Long getRealignedToKey() {
        return this.realignedToKey_;
    }

    public Institution getRealignedTo() {
        if (this.realignedToKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling Institution.factory.obtainFromKeyValue(" + this.realignedToKey_ + ")"));
            }
            return Institution.factory.obtainFromKeyValue(this.realignedToKey_);
        }
        return null;
    }

    public Institution[] getStationNumberHistory() {
        int predecessors = 0;
        int successors = 0;
        Institution[] history = new Institution[]{};
        Institution alias = this;
        while ((alias = alias.getRealignedFrom()) != null) {
            ++predecessors;
        }
        alias = this;
        while ((alias = alias.getRealignedTo()) != null) {
            ++successors;
        }
        if (predecessors + successors == 0) {
            return history;
        }
        history = new Institution[predecessors + successors + 1];
        history[predecessors] = this;
        successors = predecessors;
        alias = this;
        while ((alias = alias.getRealignedFrom()) != null) {
            history[--predecessors] = alias;
        }
        alias = this;
        while ((alias = alias.getRealignedTo()) != null) {
            history[++successors] = alias;
        }
        return history;
    }

    public void setVisnKey(Long value) {
        this.visnKey_ = value;
    }

    public Long getVisnKey() {
        return this.visnKey_;
    }

    public Institution getVisn() {
        if (this.visnKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling Institution.factory.obtainFromKeyValue(" + this.visnKey_ + ")"));
            }
            return Institution.factory.obtainFromKeyValue(this.visnKey_);
        }
        return null;
    }

    public boolean hasMultipleDivisions() {
        Institution[] divisions = this.getFacilityType() != null && "VISN".equals(this.getFacilityType().getCode()) ? this.getVisnDivisions() : this.getDivisions();
        return divisions.length > 1;
    }

    public boolean isActive() {
        Day today = Day.today();
        if (this.getActivationDate() != null && this.getActivationDate().after((Date)today)) {
            return false;
        }
        return this.getDeactivationDate() == null || !this.getDeactivationDate().before((Date)today);
    }

    public boolean isMedicalTreating() {
        return this.getFacilityType() == null ? false : Boolean.TRUE.equals(this.getFacilityType().isMedicalTreating());
    }

    public boolean isADivision() {
        String facilityTypeCode;
        String stationNumber = this.getStationNumber();
        if (stationNumber == null) {
            return false;
        }
        int stationNumberLength = stationNumber.length();
        if (stationNumberLength == 3 && ("VAMC".equals(facilityTypeCode = this.getFacilityType().getCode()) || "RO-OC".equals(facilityTypeCode) || "M&ROC".equals(facilityTypeCode))) {
            return true;
        }
        return stationNumberLength == 5 && stationNumber.charAt(3) == 'A' && Character.isDigit(stationNumber.charAt(4));
    }

    public String getUserNameForVistaProvider() {
        if (this.getVistaProvider() == null || this.getStationNumber() == null) {
            return "";
        }
        if (this.getStationNumber().equals("528")) {
            return "UPSTATE NEW YORK";
        }
        if (this.getStationNumber().equals("480")) {
            return "HONOLULU, HI";
        }
        if (this.getStationNumber().equals("459")) {
            return "VA PACIFIC ISLAND HCS";
        }
        Address address = this.getVistaProvider().getStreetAddress();
        if (address == null || address.getCity() == null || address.getState() == null) {
            return "";
        }
        return address.getCity().toUpperCase() + ", " + address.getState().getPostalName().toUpperCase();
    }

    public Institution getVistaProvider() {
        if (this.getStationNumber() == null) {
            return null;
        }
        if ("200".equals(this.getStationNumber().substring(0, 3))) {
            return this;
        }
        Institution vistaProvider = Institution.factory.obtainByStationNumber(this.getStationNumber().substring(0, 3));
        if (vistaProvider == null || vistaProvider.getParent() == null || vistaProvider.getDeactivationDate() != null) {
            return null;
        }
        return vistaProvider;
    }

    public Institution[] getAllVistaProviders() {
        Institution[] institutions = Institution.factory.obtain();
        Vector<Institution> vistaProviderVector = new Vector<Institution>();
        int j = 0;
        for (int i = 0; i < institutions.length; ++i) {
            if (institutions[i].getParent() == null || institutions[i].getDeactivationDate() != null || institutions[i].getStationNumber() == null || institutions[i].getStationNumber().length() != 3) continue;
            vistaProviderVector.add(j++, institutions[i]);
        }
        return vistaProviderVector.toArray(new Institution[0]);
    }

    public Institution[] getAllVistaProvidersByUserName() {
        Institution[] institutions = this.getAllVistaProviders();
        class NameComparator
        implements Comparator {
            NameComparator() {
            }

            public int compare(Object instA, Object instB) {
                String nameA = ((Institution)instA).getUserNameForVistaProvider();
                String nameB = ((Institution)instB).getUserNameForVistaProvider();
                return nameA.compareTo(nameB);
            }
        }
        Arrays.sort(institutions, new NameComparator());
        return institutions;
    }

    public boolean equals(Object o) {
        Institution[] otherChildren;
        InstitutionCode[] otherCodes;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadonlyInstitution other = (ReadonlyInstitution)o;
        if (!Is.equal((Object)this.getKey(), (Object)other.getKey())) {
            return false;
        }
        if (!Is.equal((Object)this.getId(), (Object)other.getId())) {
            return false;
        }
        if (!Is.equal((Object)this.getActivationDate(), (Object)other.getActivationDate())) {
            return false;
        }
        if (!Is.equal((Object)this.getDeactivationDate(), (Object)other.getDeactivationDate())) {
            return false;
        }
        if (!Is.equal((Object)this.getName(), (Object)other.getName())) {
            return false;
        }
        if (!Is.equal((Object)this.getStationNumber(), (Object)other.getStationNumber())) {
            return false;
        }
        if (!Is.equal((Object)this.getVistaName(), (Object)other.getVistaName())) {
            return false;
        }
        if (!Is.equal((Object)this.agencyKey_, (Object)other.agencyKey_)) {
            return false;
        }
        InstitutionCode[] thisCodes = this.getCodes();
        int i = thisCodes.length;
        if (i != (otherCodes = other.getCodes()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisCodes[i].getKey(), (Object)otherCodes[i].getKey())) continue;
            return false;
        }
        if (!Is.equal((Object)this.getStreetAddress(), (Object)other.getStreetAddress())) {
            return false;
        }
        if (!Is.equal((Object)this.getMailingAddress(), (Object)other.getMailingAddress())) {
            return false;
        }
        if (!Is.equal((Object)this.facilityTypeKey_, (Object)other.facilityTypeKey_)) {
            return false;
        }
        if (!Is.equal((Object)this.getMfn_zeg_recipient(), (Object)other.getMfn_zeg_recipient())) {
            return false;
        }
        Institution[] thisChildren = this.getChildren();
        i = thisChildren.length;
        if (i != (otherChildren = other.getChildren()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisChildren[i].getKey(), (Object)otherChildren[i].getKey())) continue;
            return false;
        }
        if (!Is.equal((Object)this.parentKey_, (Object)other.parentKey_)) {
            return false;
        }
        if (!Is.equal((Object)this.realignedFromKey_, (Object)other.realignedFromKey_)) {
            return false;
        }
        if (!Is.equal((Object)this.realignedToKey_, (Object)other.realignedToKey_)) {
            return false;
        }
        return Is.equal((Object)this.visnKey_, (Object)other.visnKey_);
    }

    public int hashCode() {
        return this.key_ == null ? 0 : this.key_.hashCode();
    }

    public Object clone() {
        try {
            ReadonlyInstitution result = (ReadonlyInstitution)super.clone();
            if (this.streetAddress_ != null) {
                result.streetAddress_ = (Address)this.streetAddress_.clone();
            }
            if (this.mailingAddress_ != null) {
                result.mailingAddress_ = (Address)this.mailingAddress_.clone();
            }
            return result;
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException("Unexpected error in clone: ", x);
        }
    }

    public static ReadonlyInstitution valueOf(String s) {
        return ReadonlyInstitution.obtainFromKeyString(s);
    }

    public int compareTo(Object o) {
        int result = 0;
        ReadonlyInstitution other = (ReadonlyInstitution)o;
        String value = this.getName();
        String otherValue = other.getName();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public static ReadonlyInstitution[] obtain() {
        return (ReadonlyInstitution[])factory_.obtain();
    }

    public static ReadonlyInstitution[] obtain(int first, int max) {
        return (ReadonlyInstitution[])factory_.obtain(first, max);
    }

    public static ReadonlyInstitution[] obtain(int first, int max, String order) {
        return (ReadonlyInstitution[])factory_.obtain(first, max, order);
    }

    public static ReadonlyInstitution obtain(Institution.Key key) {
        return (ReadonlyInstitution)factory_.obtain(key);
    }

    public static ReadonlyInstitution obtainByStationNumber(String stationNumber) {
        return (ReadonlyInstitution)factory_.obtainByStationNumber(stationNumber);
    }

    public static ReadonlyInstitution obtainFromKeyString(String s) {
        return (ReadonlyInstitution)factory_.obtainFromKeyString(s);
    }

    public static ReadonlyInstitution obtainFromKeyValue(Long keyValue) {
        return (ReadonlyInstitution)factory_.obtainFromKeyValue(keyValue);
    }

    public static ReadonlyInstitution[] obtain(Criteria criteria) {
        return (ReadonlyInstitution[])factory_.obtain(criteria);
    }

    public static ReadonlyInstitution[] obtain(Criteria criteria, int first, int max) {
        return (ReadonlyInstitution[])factory_.obtain(criteria, first, max);
    }

    public static ReadonlyInstitution[] obtain(Criteria criteria, int first, int max, String order) {
        return (ReadonlyInstitution[])factory_.obtain(criteria, first, max, order);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ReadonlyInstitution@");
        buf.append(System.identityHashCode(this));
        buf.append("[");
        buf.append("key=");
        buf.append(this.key_);
        buf.append(',');
        buf.append("id=");
        buf.append(String.valueOf(this.getId()));
        buf.append(',');
        buf.append("activationDate=");
        buf.append(String.valueOf(this.getActivationDate()));
        buf.append(',');
        buf.append("deactivationDate=");
        buf.append(String.valueOf(this.getDeactivationDate()));
        buf.append(',');
        buf.append("name=");
        buf.append(String.valueOf(this.getName()));
        buf.append(',');
        buf.append("stationNumber=");
        buf.append(String.valueOf(this.getStationNumber()));
        buf.append(',');
        buf.append("vistaName=");
        buf.append(String.valueOf(this.getVistaName()));
        buf.append(',');
        buf.append("agency=");
        Agency thisAgency = this.getAgency();
        if (thisAgency == null) {
            buf.append("null");
        } else {
            buf.append(thisAgency.getKey());
            buf.append('(');
            buf.append(thisAgency.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("codes=");
        buf.append('{');
        InstitutionCode[] elements = this.getCodes();
        int i = -1;
        while (++i < elements.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(elements[i].getKey());
            buf.append('(');
            buf.append(elements[i].getName());
            buf.append(')');
        }
        buf.append('}');
        buf.append(',');
        buf.append("streetAddress=");
        buf.append(String.valueOf(this.getStreetAddress()));
        buf.append(',');
        buf.append("mailingAddress=");
        buf.append(String.valueOf(this.getMailingAddress()));
        buf.append(',');
        buf.append("facilityType=");
        FacilityType thisFacilityType = this.getFacilityType();
        if (thisFacilityType == null) {
            buf.append("null");
        } else {
            buf.append(thisFacilityType.getKey());
            buf.append('(');
            buf.append(thisFacilityType.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("mfn_zeg_recipient=");
        buf.append(String.valueOf(this.getMfn_zeg_recipient()));
        buf.append(',');
        buf.append("parent=");
        Institution thisParent = this.getParent();
        if (thisParent == null) {
            buf.append("null");
        } else {
            buf.append(thisParent.getKey());
            buf.append('(');
            buf.append(thisParent.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("realignedFrom=");
        Institution thisRealignedFrom = this.getRealignedFrom();
        if (thisRealignedFrom == null) {
            buf.append("null");
        } else {
            buf.append(thisRealignedFrom.getKey());
            buf.append('(');
            buf.append(thisRealignedFrom.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("realignedTo=");
        Institution thisRealignedTo = this.getRealignedTo();
        if (thisRealignedTo == null) {
            buf.append("null");
        } else {
            buf.append(thisRealignedTo.getKey());
            buf.append('(');
            buf.append(thisRealignedTo.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("visn=");
        Institution thisVisn = this.getVisn();
        if (thisVisn == null) {
            buf.append("null");
        } else {
            buf.append(thisVisn.getKey());
            buf.append('(');
            buf.append(thisVisn.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("hasMultipleDivisions=");
        buf.append(String.valueOf(this.hasMultipleDivisions()));
        buf.append(',');
        buf.append("isActive=");
        buf.append(String.valueOf(this.isActive()));
        buf.append(',');
        buf.append("isMedicalTreating=");
        buf.append(String.valueOf(this.isMedicalTreating()));
        buf.append(',');
        buf.append("isADivision=");
        buf.append(String.valueOf(this.isADivision()));
        buf.append(',');
        buf.append("userNameForVistaProvider=");
        buf.append(String.valueOf(this.getUserNameForVistaProvider()));
        buf.append(',');
        buf.append("vistaProvider=");
        Institution thisVistaProvider = this.getVistaProvider();
        if (thisVistaProvider == null) {
            buf.append("null");
        } else {
            buf.append(thisVistaProvider.getKey());
            buf.append('(');
            buf.append(thisVistaProvider.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append(']');
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Factory
    extends Institution.Factory {
        public Institution[] obtainChildren(Institution var1);
    }

    public static class Key
    implements Institution.Key,
    Comparable {
        private final Long value_;
        private final String sValue_;

        public Key(int value) {
            this.value_ = new Long(value);
            this.sValue_ = String.valueOf(value);
        }

        public Key(Long value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public int hashCode() {
            return this.value_.hashCode();
        }

        public boolean equals(Object other) {
            return other != null && other.getClass() == this.getClass() && ((Key)other).value_.equals(this.value_);
        }

        public Long value() {
            return this.value_;
        }

        public static Key valueOf(String keyString) {
            return new Key(Long.valueOf(keyString));
        }

        public int compareTo(Object other) {
            return this.value_.compareTo(((Key)other).value_);
        }

        public String toString() {
            return this.sValue_;
        }
    }
}

