/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly;

import gov.va.med.term.access.County;
import gov.va.med.term.access.CountyHistory;
import gov.va.med.term.access.State;
import gov.va.med.term.access.StatisticalArea;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.readonly.ReadonlyCountyHistory;
import gov.va.med.term.access.util.ImplementorRegistry;
import gov.va.med.term.access.util.Is;
import java.sql.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ReadonlyCounty
implements County {
    protected static final Factory factory_ = (Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$County$Factory == null ? (class$gov$va$med$term$access$County$Factory = ReadonlyCounty.class$("gov.va.med.term.access.County$Factory")) : class$gov$va$med$term$access$County$Factory);
    private static Logger logger_ = Logger.getLogger((Class)(class$gov$va$med$term$access$County == null ? (class$gov$va$med$term$access$County = ReadonlyCounty.class$("gov.va.med.term.access.County")) : class$gov$va$med$term$access$County));
    private Key key_;
    protected Integer version_;
    protected Long id_;
    protected String name_;
    protected String number_;
    protected String description_;
    protected Long stateKey_ = null;
    protected StatisticalArea[] statisticalAreas_ = null;
    protected CountyHistory[] history_ = null;
    static /* synthetic */ Class class$gov$va$med$term$access$County$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$County;

    public void setKey(Key value) {
        this.key_ = value;
    }

    public County.Key getKey() {
        return this.key_;
    }

    public String getKeyString() {
        return this.getKey().toString();
    }

    public Integer getVersion() {
        return this.version_;
    }

    public Long getId() {
        return this.id_;
    }

    public void setId(Long value) {
        this.id_ = value;
        this.key_ = new Key(value);
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String value) {
        this.name_ = value;
    }

    public String getCountyStateName() {
        return this.getName() + ", " + this.getState().getPostalName();
    }

    public String getNumber() {
        return this.number_;
    }

    public void setNumber(String value) {
        this.number_ = value;
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String value) {
        this.description_ = value;
    }

    public void setStateKey(Long value) {
        this.stateKey_ = value;
    }

    public Long getStateKey() {
        return this.stateKey_;
    }

    public State getState() {
        if (this.stateKey_ != null) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)("Calling State.factory.obtainFromKeyValue(" + this.stateKey_ + ")"));
            }
            return State.factory.obtainFromKeyValue(this.stateKey_);
        }
        return null;
    }

    public StatisticalArea[] getStatisticalAreas() {
        Date now = new Date(System.currentTimeMillis());
        return this.getStatisticalAreas(true, now);
    }

    public StatisticalArea[] getStatisticalAreas(boolean isActive, Date when) {
        StatisticalArea[] instances = this.getStatisticalAreasRaw();
        Vector<StatisticalArea> activeInstances = new Vector<StatisticalArea>();
        for (int i = 0; i < instances.length; ++i) {
            StatisticalArea instance = instances[i];
            if (instance.isActive(when) != isActive) continue;
            activeInstances.add(instance);
        }
        return activeInstances.toArray(new StatisticalArea[0]);
    }

    public StatisticalArea[] getStatisticalAreasRaw() {
        return (StatisticalArea[])this.statisticalAreas_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatisticalArea[] statisticalAreas_() {
        ReadonlyCounty readonlyCounty = this;
        synchronized (readonlyCounty) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling StatisticalArea.factory.obtainStatisticalAreas");
            }
            return factory_.obtainStatisticalAreas(this);
        }
    }

    public boolean isActive() {
        return this.isActive(new Date(System.currentTimeMillis()));
    }

    public CountyHistory[] getHistory() {
        return (CountyHistory[])this.history_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountyHistory[] history_() {
        ReadonlyCounty readonlyCounty = this;
        synchronized (readonlyCounty) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling CountyHistory.factory.obtain(this)");
            }
            return ((ReadonlyCountyHistory.Factory)CountyHistory.factory).obtain(this);
        }
    }

    public boolean isActive(Date when) {
        CountyHistory[] history = this.getHistory();
        for (int i = 0; i < history.length; ++i) {
            CountyHistory entry = history[i];
            Date effectiveDate = entry.getEffectiveDate();
            Date expirationDate = entry.getExpirationDate();
            if (!effectiveDate.before(when) && !effectiveDate.equals(when) || !when.before(expirationDate)) continue;
            return entry.isActive();
        }
        return false;
    }

    public boolean equals(Object o) {
        CountyHistory[] otherHistory;
        StatisticalArea[] otherStatisticalAreas;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadonlyCounty other = (ReadonlyCounty)o;
        if (!Is.equal((Object)this.getKey(), (Object)other.getKey())) {
            return false;
        }
        if (!Is.equal((Object)this.getId(), (Object)other.getId())) {
            return false;
        }
        if (!Is.equal((Object)this.getName(), (Object)other.getName())) {
            return false;
        }
        if (!Is.equal((Object)this.getNumber(), (Object)other.getNumber())) {
            return false;
        }
        if (!Is.equal((Object)this.getDescription(), (Object)other.getDescription())) {
            return false;
        }
        if (!Is.equal((Object)this.stateKey_, (Object)other.stateKey_)) {
            return false;
        }
        StatisticalArea[] thisStatisticalAreas = this.getStatisticalAreas();
        int i = thisStatisticalAreas.length;
        if (i != (otherStatisticalAreas = other.getStatisticalAreas()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisStatisticalAreas[i].getKey(), (Object)otherStatisticalAreas[i].getKey())) continue;
            return false;
        }
        CountyHistory[] thisHistory = this.getHistory();
        i = thisHistory.length;
        if (i != (otherHistory = other.getHistory()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisHistory[i].getKey(), (Object)otherHistory[i].getKey())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.key_ == null ? 0 : this.key_.hashCode();
    }

    public Object clone() {
        try {
            ReadonlyCounty result = (ReadonlyCounty)super.clone();
            return result;
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException("Unexpected error in clone: ", x);
        }
    }

    public static ReadonlyCounty valueOf(String s) {
        return ReadonlyCounty.obtainFromKeyString(s);
    }

    public int compareTo(Object o) {
        int result = 0;
        ReadonlyCounty other = (ReadonlyCounty)o;
        Object value = this.getName();
        Object otherValue = other.getName();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = ((String)value).compareTo((String)otherValue);
        if (result != 0) {
            return result;
        }
        value = this.getState();
        otherValue = other.getState();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public static ReadonlyCounty[] obtain() {
        return (ReadonlyCounty[])factory_.obtain();
    }

    public static ReadonlyCounty[] obtain(int first, int max) {
        return (ReadonlyCounty[])factory_.obtain(first, max);
    }

    public static ReadonlyCounty[] obtain(int first, int max, String order) {
        return (ReadonlyCounty[])factory_.obtain(first, max, order);
    }

    public static ReadonlyCounty obtain(County.Key key) {
        return (ReadonlyCounty)factory_.obtain(key);
    }

    public static ReadonlyCounty obtainByNumber(State state, String number) {
        return (ReadonlyCounty)factory_.obtainByNumber(state, number);
    }

    public static ReadonlyCounty obtainByName(State state, String name) {
        return (ReadonlyCounty)factory_.obtainByName(state, name);
    }

    public static ReadonlyCounty obtainFromKeyString(String s) {
        return (ReadonlyCounty)factory_.obtainFromKeyString(s);
    }

    public static ReadonlyCounty obtainFromKeyValue(Long keyValue) {
        return (ReadonlyCounty)factory_.obtainFromKeyValue(keyValue);
    }

    public static ReadonlyCounty[] obtain(Criteria criteria) {
        return (ReadonlyCounty[])factory_.obtain(criteria);
    }

    public static ReadonlyCounty[] obtain(Criteria criteria, int first, int max) {
        return (ReadonlyCounty[])factory_.obtain(criteria, first, max);
    }

    public static ReadonlyCounty[] obtain(Criteria criteria, int first, int max, String order) {
        return (ReadonlyCounty[])factory_.obtain(criteria, first, max, order);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ReadonlyCounty@");
        buf.append(System.identityHashCode(this));
        buf.append("[");
        buf.append("key=");
        buf.append(this.key_);
        buf.append(',');
        buf.append("id=");
        buf.append(String.valueOf(this.getId()));
        buf.append(',');
        buf.append("name=");
        buf.append(String.valueOf(this.getName()));
        buf.append(',');
        buf.append("countyStateName=");
        buf.append(String.valueOf(this.getCountyStateName()));
        buf.append(',');
        buf.append("number=");
        buf.append(String.valueOf(this.getNumber()));
        buf.append(',');
        buf.append("description=");
        buf.append(String.valueOf(this.getDescription()));
        buf.append(',');
        buf.append("state=");
        State thisState = this.getState();
        if (thisState == null) {
            buf.append("null");
        } else {
            buf.append(thisState.getKey());
            buf.append('(');
            buf.append(thisState.getName());
            buf.append(')');
        }
        buf.append(',');
        buf.append("isActive=");
        buf.append(String.valueOf(this.isActive()));
        buf.append(',');
        buf.append("history=");
        buf.append('{');
        CountyHistory[] elements = this.getHistory();
        int i = -1;
        while (++i < elements.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(elements[i].getKey());
            buf.append('(');
            buf.append(elements[i].getName());
            buf.append(')');
        }
        buf.append('}');
        buf.append(']');
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Factory
    extends County.Factory {
        public County[] obtain(State var1);

        public StatisticalArea[] obtainStatisticalAreas(County var1);
    }

    public static class Key
    implements County.Key,
    Comparable {
        private final Long value_;
        private final String sValue_;

        public Key(int value) {
            this.value_ = new Long(value);
            this.sValue_ = String.valueOf(value);
        }

        public Key(Long value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public int hashCode() {
            return this.value_.hashCode();
        }

        public boolean equals(Object other) {
            return other != null && other.getClass() == this.getClass() && ((Key)other).value_.equals(this.value_);
        }

        public Long value() {
            return this.value_;
        }

        public static Key valueOf(String keyString) {
            return new Key(Long.valueOf(keyString));
        }

        public int compareTo(Object other) {
            return this.value_.compareTo(((Key)other).value_);
        }

        public String toString() {
            return this.sValue_;
        }
    }
}

