/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.readonly;

import gov.va.med.term.access.Country;
import gov.va.med.term.access.CountryHistory;
import gov.va.med.term.access.State;
import gov.va.med.term.access.criteria.Criteria;
import gov.va.med.term.access.readonly.ReadonlyCountryHistory;
import gov.va.med.term.access.readonly.ReadonlyState;
import gov.va.med.term.access.util.ImplementorRegistry;
import gov.va.med.term.access.util.Is;
import java.sql.Date;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ReadonlyCountry
implements Country {
    protected static final Factory factory_ = (Factory)ImplementorRegistry.instance().implementorFor(class$gov$va$med$term$access$Country$Factory == null ? (class$gov$va$med$term$access$Country$Factory = ReadonlyCountry.class$("gov.va.med.term.access.Country$Factory")) : class$gov$va$med$term$access$Country$Factory);
    private static Logger logger_ = Logger.getLogger((Class)(class$gov$va$med$term$access$Country == null ? (class$gov$va$med$term$access$Country = ReadonlyCountry.class$("gov.va.med.term.access.Country")) : class$gov$va$med$term$access$Country));
    private Key key_;
    protected Integer version_;
    protected Long id_;
    protected String numericCode_;
    protected String shortName_;
    protected String alpha3Code_;
    protected String fipsCode_;
    protected String postalName_;
    protected State[] states_ = null;
    protected CountryHistory[] history_ = null;
    static /* synthetic */ Class class$gov$va$med$term$access$Country$Factory;
    static /* synthetic */ Class class$gov$va$med$term$access$Country;

    public void setKey(Key value) {
        this.key_ = value;
    }

    public Country.Key getKey() {
        return this.key_;
    }

    public String getKeyString() {
        return this.getKey().toString();
    }

    public Integer getVersion() {
        return this.version_;
    }

    public String getName() {
        return this.getShortName().toString();
    }

    public Long getId() {
        return this.id_;
    }

    public void setId(Long value) {
        this.id_ = value;
        this.key_ = new Key(value);
    }

    public String getNumericCode() {
        return this.numericCode_;
    }

    public void setNumericCode(String value) {
        this.numericCode_ = value;
    }

    public String getShortName() {
        return this.shortName_;
    }

    public void setShortName(String value) {
        this.shortName_ = value;
    }

    public String getAlpha3Code() {
        return this.alpha3Code_;
    }

    public void setAlpha3Code(String value) {
        this.alpha3Code_ = value;
    }

    public String getFipsCode() {
        return this.fipsCode_;
    }

    public void setFipsCode(String value) {
        this.fipsCode_ = value;
    }

    public String getPostalName() {
        return this.postalName_;
    }

    public void setPostalName(String value) {
        this.postalName_ = value;
    }

    public State[] getStates() {
        Date now = new Date(System.currentTimeMillis());
        return this.getStates(true, now);
    }

    public State[] getStates(boolean isActive, Date when) {
        State[] instances = this.getStatesRaw();
        Vector<State> activeInstances = new Vector<State>();
        for (int i = 0; i < instances.length; ++i) {
            State instance = instances[i];
            if (instance.isActive(when) != isActive) continue;
            activeInstances.add(instance);
        }
        return activeInstances.toArray(new State[0]);
    }

    public State[] getStatesRaw() {
        return (State[])this.states_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private State[] states_() {
        ReadonlyCountry readonlyCountry = this;
        synchronized (readonlyCountry) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling State.factory.obtain(this)");
            }
            return ((ReadonlyState.Factory)State.factory).obtain(this);
        }
    }

    public boolean isActive() {
        return this.isActive(new Date(System.currentTimeMillis()));
    }

    public CountryHistory[] getHistory() {
        return (CountryHistory[])this.history_().clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CountryHistory[] history_() {
        ReadonlyCountry readonlyCountry = this;
        synchronized (readonlyCountry) {
            if (logger_.isDebugEnabled()) {
                logger_.debug((Object)"Calling CountryHistory.factory.obtain(this)");
            }
            return ((ReadonlyCountryHistory.Factory)CountryHistory.factory).obtain(this);
        }
    }

    public boolean isActive(Date when) {
        CountryHistory[] history = this.getHistory();
        for (int i = 0; i < history.length; ++i) {
            CountryHistory entry = history[i];
            Date effectiveDate = entry.getEffectiveDate();
            Date expirationDate = entry.getExpirationDate();
            if (!effectiveDate.before(when) && !effectiveDate.equals(when) || !when.before(expirationDate)) continue;
            return entry.isActive();
        }
        return false;
    }

    public boolean equals(Object o) {
        CountryHistory[] otherHistory;
        State[] otherStates;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadonlyCountry other = (ReadonlyCountry)o;
        if (!Is.equal((Object)this.getKey(), (Object)other.getKey())) {
            return false;
        }
        if (!Is.equal((Object)this.getId(), (Object)other.getId())) {
            return false;
        }
        if (!Is.equal((Object)this.getNumericCode(), (Object)other.getNumericCode())) {
            return false;
        }
        if (!Is.equal((Object)this.getShortName(), (Object)other.getShortName())) {
            return false;
        }
        if (!Is.equal((Object)this.getAlpha3Code(), (Object)other.getAlpha3Code())) {
            return false;
        }
        if (!Is.equal((Object)this.getFipsCode(), (Object)other.getFipsCode())) {
            return false;
        }
        if (!Is.equal((Object)this.getPostalName(), (Object)other.getPostalName())) {
            return false;
        }
        State[] thisStates = this.getStates();
        int i = thisStates.length;
        if (i != (otherStates = other.getStates()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisStates[i].getKey(), (Object)otherStates[i].getKey())) continue;
            return false;
        }
        CountryHistory[] thisHistory = this.getHistory();
        i = thisHistory.length;
        if (i != (otherHistory = other.getHistory()).length) {
            return false;
        }
        while (--i >= 0) {
            if (Is.equal((Object)thisHistory[i].getKey(), (Object)otherHistory[i].getKey())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.key_ == null ? 0 : this.key_.hashCode();
    }

    public Object clone() {
        try {
            ReadonlyCountry result = (ReadonlyCountry)super.clone();
            return result;
        }
        catch (CloneNotSupportedException x) {
            throw new RuntimeException("Unexpected error in clone: ", x);
        }
    }

    public static ReadonlyCountry valueOf(String s) {
        return ReadonlyCountry.obtainFromKeyString(s);
    }

    public int compareTo(Object o) {
        int result = 0;
        ReadonlyCountry other = (ReadonlyCountry)o;
        String value = this.getShortName();
        String otherValue = other.getShortName();
        if (value == null) {
            return otherValue == null ? 0 : -1;
        }
        if (otherValue == null) {
            return 1;
        }
        result = value.compareTo(otherValue);
        return result;
    }

    public static ReadonlyCountry[] obtain() {
        return (ReadonlyCountry[])factory_.obtain();
    }

    public static ReadonlyCountry[] obtain(int first, int max) {
        return (ReadonlyCountry[])factory_.obtain(first, max);
    }

    public static ReadonlyCountry[] obtain(int first, int max, String order) {
        return (ReadonlyCountry[])factory_.obtain(first, max, order);
    }

    public static ReadonlyCountry obtain(Country.Key key) {
        return (ReadonlyCountry)factory_.obtain(key);
    }

    public static ReadonlyCountry obtainByAlpha3Code(String alpha3Code) {
        return (ReadonlyCountry)factory_.obtainByAlpha3Code(alpha3Code);
    }

    public static ReadonlyCountry obtainFromKeyString(String s) {
        return (ReadonlyCountry)factory_.obtainFromKeyString(s);
    }

    public static ReadonlyCountry obtainFromKeyValue(Long keyValue) {
        return (ReadonlyCountry)factory_.obtainFromKeyValue(keyValue);
    }

    public static ReadonlyCountry[] obtain(Criteria criteria) {
        return (ReadonlyCountry[])factory_.obtain(criteria);
    }

    public static ReadonlyCountry[] obtain(Criteria criteria, int first, int max) {
        return (ReadonlyCountry[])factory_.obtain(criteria, first, max);
    }

    public static ReadonlyCountry[] obtain(Criteria criteria, int first, int max, String order) {
        return (ReadonlyCountry[])factory_.obtain(criteria, first, max, order);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ReadonlyCountry@");
        buf.append(System.identityHashCode(this));
        buf.append("[");
        buf.append("key=");
        buf.append(this.key_);
        buf.append(',');
        buf.append("id=");
        buf.append(String.valueOf(this.getId()));
        buf.append(',');
        buf.append("numericCode=");
        buf.append(String.valueOf(this.getNumericCode()));
        buf.append(',');
        buf.append("shortName=");
        buf.append(String.valueOf(this.getShortName()));
        buf.append(',');
        buf.append("alpha3Code=");
        buf.append(String.valueOf(this.getAlpha3Code()));
        buf.append(',');
        buf.append("fipsCode=");
        buf.append(String.valueOf(this.getFipsCode()));
        buf.append(',');
        buf.append("postalName=");
        buf.append(String.valueOf(this.getPostalName()));
        buf.append(',');
        buf.append("states=");
        buf.append('{');
        Comparable[] elements = this.getStates();
        int i = -1;
        while (++i < elements.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(elements[i].getKey());
            buf.append('(');
            buf.append(elements[i].getName());
            buf.append(')');
        }
        buf.append('}');
        buf.append(',');
        buf.append("isActive=");
        buf.append(String.valueOf(this.isActive()));
        buf.append(',');
        buf.append("history=");
        buf.append('{');
        elements = this.getHistory();
        i = -1;
        while (++i < elements.length) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(elements[i].getKey());
            buf.append('(');
            buf.append(elements[i].getName());
            buf.append(')');
        }
        buf.append('}');
        buf.append(']');
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Factory
    extends Country.Factory {
    }

    public static class Key
    implements Country.Key,
    Comparable {
        private final Long value_;
        private final String sValue_;

        public Key(int value) {
            this.value_ = new Long(value);
            this.sValue_ = String.valueOf(value);
        }

        public Key(Long value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public int hashCode() {
            return this.value_.hashCode();
        }

        public boolean equals(Object other) {
            return other != null && other.getClass() == this.getClass() && ((Key)other).value_.equals(this.value_);
        }

        public Long value() {
            return this.value_;
        }

        public static Key valueOf(String keyString) {
            return new Key(Long.valueOf(keyString));
        }

        public int compareTo(Object other) {
            return this.value_.compareTo(((Key)other).value_);
        }

        public String toString() {
            return this.sValue_;
        }
    }
}

