/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.xml.factory.castor;

import gov.va.med.term.access.maint.util.Cache;
import gov.va.med.term.access.maint.xml.Mapping;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.exolab.castor.mapping.MappingException;
import org.xml.sax.InputSource;

class MappingCache {
    private static Cache cache_ = new Cache(new MappingLoader(), false);

    MappingCache() {
    }

    public static Entry get(Mapping mapping) {
        return (Entry)cache_.fetch(mapping);
    }

    public static class Entry {
        public String publicId;
        public String systemId;
        public org.exolab.castor.mapping.Mapping mapping = new org.exolab.castor.mapping.Mapping();
    }

    private static class MappingLoader
    implements Cache.Loader {
        MappingLoader() {
        }

        private void loadFileIntoMapping(org.exolab.castor.mapping.Mapping mapping, URL context, String mappingFile) {
            URL mappingUrl = null;
            try {
                mappingUrl = new URL(context, mappingFile);
                InputStream stream = mappingUrl.openStream();
                if (stream == null) {
                    throw new RuntimeException("Couldn't open stream " + mappingUrl);
                }
                InputSource input = new InputSource(stream);
                mapping.loadMapping(input);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Could not find " + mappingFile + " relative to " + context, e);
            }
            catch (MappingException e) {
                throw new RuntimeException("Invalid mapping file (" + mappingUrl + ").", MappingLoader.rootCause(e));
            }
            catch (IOException e) {
                throw new RuntimeException("Problem reading mapping file (" + mappingUrl + ").", e);
            }
        }

        private static Throwable rootCause(Throwable x) {
            if (x.getCause() != null) {
                return MappingLoader.rootCause(x.getCause());
            }
            Class<?> c = x.getClass();
            try {
                Throwable cause;
                Method m = c.getMethod("getException", null);
                if (m != null && Modifier.isPublic(m.getModifiers()) && (cause = (Throwable)m.invoke((Object)x, null)) != null) {
                    return MappingLoader.rootCause(cause);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return x;
        }

        public Object obtain(Object key) {
            String propertyFile = ((Mapping)key).toString();
            URL propertyUrl = this.getClass().getResource(propertyFile);
            if (propertyUrl == null) {
                throw new RuntimeException("Cannot locate " + propertyFile);
            }
            Properties properties = new Properties();
            try {
                InputStream input = propertyUrl.openStream();
                properties.load(input);
                input.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Problem reading " + propertyUrl, e);
            }
            Entry entry = new Entry();
            entry.publicId = properties.getProperty("publicId");
            entry.systemId = properties.getProperty("systemId");
            String mappings = properties.getProperty("mappings");
            String include = properties.getProperty("include");
            if (mappings == null && include == null) {
                throw new RuntimeException("mappings or include must be specified in " + propertyFile);
            }
            if (mappings != null) {
                String[] mappingFiles = mappings.split(",");
                int i = 0;
                while (i < mappingFiles.length) {
                    this.loadFileIntoMapping(entry.mapping, propertyUrl, mappingFiles[i]);
                    ++i;
                }
            }
            if (include != null) {
                URL includeUrl;
                try {
                    includeUrl = new URL(propertyUrl, include);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Could not find " + include + " relative to " + propertyFile, e);
                }
                Properties mappingFiles = new Properties();
                try {
                    InputStream input = includeUrl.openStream();
                    mappingFiles.load(input);
                    input.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Problem reading " + includeUrl, e);
                }
                Enumeration<?> i = properties.propertyNames();
                while (i.hasMoreElements()) {
                    this.loadFileIntoMapping(entry.mapping, includeUrl, (String)i.nextElement());
                }
            }
            return entry;
        }
    }
}

