/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.xml;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.DefaultHandler;

public class AttributeValidator
extends DefaultHandler
implements DeclHandler {
    private Locator locator_;
    private Dtd dtd_;
    private ErrorHandler errorHandler_;
    private EntityResolver resolver_ = null;
    private NodeIterator iterator_;

    public AttributeValidator(ErrorHandler errorHandler) {
        this.errorHandler_ = errorHandler;
    }

    public void setEntityResolver(EntityResolver resolver) {
        this.resolver_ = resolver;
    }

    public void startDocument() throws SAXException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(this.resolver_);
            Document document = builder.parse(this.locator_.getSystemId());
            if (!document.isSupported("Traversal", "2.0")) {
                DOMParser parser = new DOMParser();
                parser.setEntityResolver(this.resolver_);
                parser.parse(this.locator_.getSystemId());
                document = parser.getDocument();
            }
            this.iterator_ = ((DocumentTraversal)((Object)document)).createNodeIterator(document, 1, null, true);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void attributeDecl(String elementName, String attributeName, String type, String mode, String defaultValue) {
        Type atype = null;
        if (type.charAt(0) == '(') {
            atype = Type.ENUM;
        } else {
            if (type.startsWith("NOTATION")) {
                throw new RuntimeException("Notation unsupported.");
            }
            atype = Type.valueOf(type);
        }
        DefaultingMode amode = null;
        amode = mode == null ? DefaultingMode.NONE : DefaultingMode.valueOf(mode);
        this.dtd_.getElement(elementName).addAttribute(new Attribute(attributeName, atype, amode, defaultValue));
    }

    public void elementDecl(String name, String model) {
        this.dtd_.addElement(new Element(name, model));
    }

    public void externalEntityDecl(String name, String publicId, String systemId) {
    }

    public void internalEntityDecl(String name, String value) {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator_ = locator;
        this.dtd_ = new Dtd();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String elementName = localName;
        if (elementName == null || elementName.equals("")) {
            elementName = qName;
        }
        Element element = this.dtd_.getElement(elementName);
        Node node = this.iterator_.nextNode();
        if (element != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Attribute attribute;
                String attributeName = attributes.getLocalName(i);
                if (attributeName == null || attributeName.equals("")) {
                    attributeName = attributes.getQName(i);
                }
                if ((attribute = element.getAttribute(attributeName)) != null) {
                    if (!attribute.getType().toString().equals(attributes.getType(i)) && !attributes.getType(i).equals("ENUMERATION")) {
                        throw new RuntimeException("Internal Error: Types don't match [" + attribute.getType() + "," + attributes.getType(i));
                    }
                    String defaultValue = attribute.getDefaultValue();
                    Attr domAttribute = (Attr)node.getAttributes().getNamedItem(attribute.getName());
                    if (defaultValue != null && domAttribute != null && domAttribute.getSpecified() && defaultValue.equals(domAttribute.getValue())) {
                        this.errorHandler_.warning(new SAXParseException(String.valueOf(elementName) + "." + attribute.getName() + " has same value as the default.", this.locator_));
                    }
                }
                ++i;
            }
        }
    }

    public static class Type
    implements Serializable {
        public final transient int ordinal;
        public final String name;
        public static final Type CDATA = new Type("CDATA", 0);
        public static final Type ENTITY = new Type("ENTITY", 1);
        public static final Type ENTITIES = new Type("ENTITIES", 2);
        public static final Type ID = new Type("ID", 3);
        public static final Type IDREF = new Type("IDREF", 4);
        public static final Type IDREFS = new Type("IDREFS", 5);
        public static final Type NMTOKEN = new Type("NMTOKEN", 6);
        public static final Type NMTOKENS = new Type("NMTOKENS", 7);
        public static final Type ENUM = NMTOKEN;
        public static final List VALUES = Collections.unmodifiableList(Arrays.asList(CDATA, ENUM, ENTITY, ENTITIES, ID, IDREF, IDREFS, NMTOKEN, NMTOKENS));

        protected Type(String n, int o) {
            this.name = n;
            this.ordinal = o;
        }

        public List family() {
            return VALUES;
        }

        public final boolean equals(Object o) {
            return this == o;
        }

        public final int hashCode() {
            return this.ordinal;
        }

        public String toString() {
            return this.name;
        }

        public final int compareTo(Type o) {
            return this.ordinal - o.ordinal;
        }

        protected final Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException("enums cannot be cloned.");
        }

        public static Type valueOf(String name) {
            int i = 0;
            while (i < VALUES.size()) {
                Type type = (Type)VALUES.get(i);
                if (type.name.equals(name)) {
                    return type;
                }
                ++i;
            }
            throw new IllegalArgumentException("No constant with the specified name: " + name);
        }
    }

    public static class DefaultingMode
    implements Serializable {
        public final transient int ordinal;
        public final String name;
        public static final DefaultingMode IMPLIED = new DefaultingMode("#IMPLIED", 0);
        public static final DefaultingMode REQUIRED = new DefaultingMode("#REQUIRED", 1);
        public static final DefaultingMode FIXED = new DefaultingMode("#FIXED", 2);
        public static final DefaultingMode NONE = new DefaultingMode("NONE", 3);
        public static final List VALUES = Collections.unmodifiableList(Arrays.asList(IMPLIED, REQUIRED, FIXED));

        protected DefaultingMode(String n, int o) {
            this.name = n;
            this.ordinal = o;
        }

        public List family() {
            return VALUES;
        }

        public final boolean equals(Object o) {
            return this == o;
        }

        public final int hashCode() {
            return this.ordinal;
        }

        public String toString() {
            return this.name;
        }

        public final int compareTo(Type o) {
            return this.ordinal - o.ordinal;
        }

        protected final Object clone() throws CloneNotSupportedException {
            throw new CloneNotSupportedException("enums cannot be cloned.");
        }

        public static DefaultingMode valueOf(String name) {
            int i = 0;
            while (i < VALUES.size()) {
                DefaultingMode mode = (DefaultingMode)VALUES.get(i);
                if (mode.name.equals(name)) {
                    return mode;
                }
                ++i;
            }
            throw new IllegalArgumentException("No constant with the specified name: " + name);
        }
    }

    public static class Attribute {
        private String name_;
        private Type type_;
        private DefaultingMode mode_;
        private String defaultValue_;

        public Attribute(String name, Type type, DefaultingMode mode, String defaultValue) {
            this.name_ = name;
            this.type_ = type;
            this.mode_ = mode;
            this.defaultValue_ = defaultValue;
        }

        public String getName() {
            return this.name_;
        }

        public void setName(String name) {
            this.name_ = name;
        }

        public Type getType() {
            return this.type_;
        }

        public void setType(Type type) {
            this.type_ = type;
        }

        public DefaultingMode getMode() {
            return this.mode_;
        }

        public void setMode(DefaultingMode mode) {
            this.mode_ = mode;
        }

        public String getDefaultValue() {
            return this.defaultValue_;
        }

        public void setDefaultValue(String defaultValue) {
            this.defaultValue_ = defaultValue;
        }
    }

    public static class Element {
        private String name_;
        private String model_;
        private Map attributes_ = new HashMap();

        public Element(String name, String model) {
            this.name_ = name;
            this.model_ = model;
        }

        public String getName() {
            return this.name_;
        }

        public void setName(String name) {
            this.name_ = name;
        }

        public String getModel() {
            return this.model_;
        }

        public void setModel(String model) {
            this.model_ = model;
        }

        public Attribute getAttribute(String name) {
            return (Attribute)this.attributes_.get(name);
        }

        public void addAttribute(Attribute attribute) {
            if (this.attributes_.containsKey(attribute.getName())) {
                throw new RuntimeException("Attribute redefinition (" + attribute.getName() + ")");
            }
            this.attributes_.put(attribute.getName(), attribute);
        }

        public void removeAttribute(Attribute attribute) {
            this.attributes_.remove(attribute.getName());
        }

        public void clearAttributes() {
            this.attributes_.clear();
        }
    }

    public static class Dtd {
        private Map elements_ = new HashMap();

        public Element getElement(String name) {
            return (Element)this.elements_.get(name);
        }

        public void addElement(Element element) {
            if (this.elements_.containsKey(element.getName())) {
                throw new RuntimeException("Element redefinition (" + element.getName() + ")");
            }
            this.elements_.put(element.getName(), element);
        }

        public void removeElement(Element element) {
            this.elements_.remove(element.getName());
        }

        public void clearElements() {
            this.elements_.clear();
        }
    }
}

