/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.validation.factory.xml;

import gov.va.med.term.access.maint.validation.ObjectValidator;
import gov.va.med.term.access.maint.xml.Mapping;
import gov.va.med.term.access.maint.xml.Unmarshaller;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class ObjectValidatorFactory
implements ObjectValidator.Factory {
    private static Logger logger_;
    private Hashtable cache_ = new Hashtable();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.validation.factory.xml.ObjectValidatorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public synchronized ObjectValidator validatorFor(Class c) {
        ObjectValidator result = (ObjectValidator)this.cache_.get(c);
        if (result == null) {
            result = this.read_(c);
        }
        return result;
    }

    private ObjectValidator read_(Class c) {
        String name = c.getName();
        ObjectValidator result = null;
        URL dataUrl = this.validationFileFor(c);
        logger_.info((Object)("Validation file for " + c.getName() + ":" + dataUrl));
        try {
            InputStreamReader reader = new InputStreamReader(dataUrl.openStream());
            Unmarshaller unmarshaller = Unmarshaller.factory.create(Mapping.factory.obtain(this.getClass()));
            result = (ObjectValidator)unmarshaller.unmarshal(reader);
            reader.close();
        }
        catch (IOException x) {
            String msg = "Error reading file: " + dataUrl;
            logger_.error((Object)msg, (Throwable)x);
            throw new RuntimeException(msg, x);
        }
        this.cache_.put(name, result);
        return result;
    }

    protected String packageOf(String className) {
        int p = className.lastIndexOf(46);
        className = p >= 0 ? className.substring(0, p) : null;
        return className;
    }

    protected String simpleClassName(Class c) {
        String result = c.getName();
        int i = result.lastIndexOf(46);
        if (i > 0) {
            result = result.substring(i + 1);
        }
        return result;
    }

    protected URL validationFileFor(Class c) {
        String packagePath = "/" + this.packageOf(c.getName()).replace('.', '/') + "/";
        String className = this.simpleClassName(c);
        String filename = String.valueOf(packagePath) + "validation/" + className + "Validation.xml";
        URL result = this.getClass().getResource(filename);
        if (result == null) {
            String filename2 = String.valueOf(packagePath) + className + "Validation.xml";
            result = this.getClass().getResource(filename2);
            if (result == null) {
                String msg = "Couldn't find validation file: " + filename + " or " + filename2;
                logger_.error((Object)msg);
                throw new RuntimeException(msg);
            }
        }
        return result;
    }
}

