/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.validation;

import gov.va.med.term.access.maint.util.UserErrors;
import gov.va.med.term.access.maint.validation.FieldValidator;
import gov.va.med.term.access.maint.validation.MaintenanceValidator;
import gov.va.med.term.access.maint.validation.ScriptedValidator;
import gov.va.med.term.access.maint.validation.UniquenessValidator;
import gov.va.med.term.access.maint.validation.ValidationAtom;
import gov.va.med.term.access.util.ImplementorRegistry;
import java.lang.reflect.Method;

public class ObjectValidator
implements MaintenanceValidator {
    private static final Factory factory_ = new Factory(){

        public ObjectValidator validatorFor(Class c) {
            Factory factory;
            ImplementorRegistry implementorRegistry = ImplementorRegistry.instance();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("gov.va.med.term.access.maint.validation.ObjectValidator$Factory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((factory = (Factory)implementorRegistry.implementorFor((Class)clazz, c)) == null) {
                throw new RuntimeException("Object Validator Factory not found for class " + c.getName());
            }
            return factory.validatorFor(c);
        }
    };
    private FieldValidator[] validators_ = new FieldValidator[0];
    private transient Method[] accessors_ = new Method[0];
    private ValidationAtom[] uniquenessValidators_ = new ValidationAtom[0];
    private boolean[] isFrozen_ = new boolean[0];
    private ScriptedValidator[] scripts_ = new ScriptedValidator[0];
    private Class class_ = null;
    private static final Object MODE_NORMAL = new Object();
    private static final Object MODE_CREATE = new Object();
    private static final Object MODE_UPDATE = new Object();
    static /* synthetic */ Class class$0;

    public static ObjectValidator validatorFor(Class c) {
        return factory_.validatorFor(c);
    }

    public ObjectValidator() {
    }

    public void setClassName(String classname) {
        if (this.class_ != null) {
            throw new IllegalStateException("Class already specified");
        }
        Class<?> c = null;
        try {
            c = Class.forName(classname);
        }
        catch (Exception x) {
            throw new RuntimeException("Class not found: " + classname, x);
        }
        catch (Error x) {
            throw new RuntimeException("Class not loaded: " + classname, x);
        }
        this.class_ = c;
    }

    public void setFieldValidators(FieldValidator[] validators) {
        this.initializeFieldValidators(this.class_, validators);
    }

    public FieldValidator[] fieldValidators() {
        return this.validators_;
    }

    public FieldValidator fieldValidator(String fieldName) {
        FieldValidator result = null;
        int i = this.validators_.length;
        while (--i >= 0) {
            if (!fieldName.equals(this.validators_[i].name())) continue;
            result = this.validators_[i];
            break;
        }
        return result;
    }

    public void setScripts(ScriptedValidator[] scripts) {
        this.scripts_ = (ScriptedValidator[])scripts.clone();
    }

    public ScriptedValidator[] scripts() {
        return this.scripts_;
    }

    public ObjectValidator(Class c, FieldValidator validator) {
        this(c, new FieldValidator[]{validator});
    }

    public ObjectValidator(Class c, FieldValidator validator1, FieldValidator validator2) {
        this(c, new FieldValidator[]{validator1, validator2});
    }

    public ObjectValidator(Class c, FieldValidator validator1, FieldValidator validator2, FieldValidator validator3) {
        this(c, new FieldValidator[]{validator1, validator2, validator3});
    }

    public ObjectValidator(Class c, FieldValidator validator1, FieldValidator validator2, FieldValidator validator3, FieldValidator validator4) {
        this(c, new FieldValidator[]{validator1, validator2, validator3, validator4});
    }

    public ObjectValidator(Class c, FieldValidator validator1, FieldValidator validator2, FieldValidator validator3, FieldValidator validator4, FieldValidator validator5) {
        this(c, new FieldValidator[]{validator1, validator2, validator3, validator4, validator5});
    }

    public ObjectValidator(Class c, FieldValidator[] validators) {
        this(c, validators, null);
    }

    public ObjectValidator(Class c, FieldValidator[] validators, ScriptedValidator[] scripts) {
        if (this.validators_ != null) {
            this.initializeFieldValidators(c, validators);
        }
        if (scripts != null) {
            this.scripts_ = scripts;
        }
    }

    private void initializeFieldValidators(Class c, FieldValidator[] validators) {
        this.validators_ = (FieldValidator[])validators.clone();
        Method[] methods = new Method[validators.length];
        int i = validators.length;
        this.uniquenessValidators_ = new ValidationAtom[i];
        this.isFrozen_ = new boolean[i];
        while (--i >= 0) {
            Method method;
            String name = this.validators_[i].name();
            this.uniquenessValidators_[i] = this.validators_[i].hasUniqueConstraint() ? UniquenessValidator.factory.uniquenessValidatorFor(c, name) : null;
            this.isFrozen_[i] = this.validators_[i].hasFrozenConstraint();
            try {
                method = c.getMethod("get" + ObjectValidator.capitalize(name), null);
            }
            catch (Exception x) {
                try {
                    method = c.getMethod(name, null);
                }
                catch (Exception y) {
                    throw new RuntimeException("Class " + c.getName() + " doesn't provide accessor for field " + name);
                }
            }
            methods[i] = method;
        }
        this.accessors_ = methods;
    }

    private static String capitalize(String s) {
        return String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
    }

    public boolean validate(Object object, UserErrors errors) {
        return this.validate(object, null, errors, MODE_NORMAL);
    }

    public boolean validateForCreate(Object object, UserErrors errors) {
        return this.validate(object, null, errors, MODE_CREATE);
    }

    public boolean validateForUpdate(Object object, Object previous, UserErrors errors) {
        return this.validate(object, previous, errors, MODE_UPDATE);
    }

    private boolean validate(Object object, Object previous, UserErrors errors, Object mode) {
        boolean isValid;
        boolean result = true;
        int length = this.validators_.length;
        int i = -1;
        while (++i < length) {
            Object oldFieldValue;
            String message;
            Object fieldValue;
            try {
                fieldValue = this.accessors_[i].invoke(object, null);
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
            isValid = this.validators_[i].validate(fieldValue, errors);
            result &= isValid;
            if (!isValid) continue;
            if (mode == MODE_CREATE && fieldValue != null) {
                if (this.uniquenessValidators_[i] == null || (message = this.uniquenessValidators_[i].validate(fieldValue)) == null) continue;
                errors.put(fieldValue, this.validators_[i].name(), message);
                result = false;
                continue;
            }
            if (mode != MODE_UPDATE) continue;
            if (this.isFrozen_[i]) {
                try {
                    oldFieldValue = this.accessors_[i].invoke(previous, null);
                    boolean bl = fieldValue == null ? oldFieldValue == null : (isValid = fieldValue.equals(oldFieldValue));
                    if (!isValid) {
                        errors.put(fieldValue, this.validators_[i].name(), this.validators_[i].frozenErrorMessage());
                    }
                    result &= isValid;
                    continue;
                }
                catch (Exception x) {
                    throw new RuntimeException(x);
                }
            }
            if (this.uniquenessValidators_[i] == null || fieldValue == null) continue;
            try {
                oldFieldValue = this.accessors_[i].invoke(previous, null);
                if (oldFieldValue == null || oldFieldValue.equals(fieldValue) || (message = this.uniquenessValidators_[i].validate(fieldValue)) == null) continue;
                errors.put(fieldValue, this.validators_[i].name(), message);
                result = false;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }
        if (result) {
            int length2 = this.scripts_.length;
            int i2 = -1;
            while (++i2 < length2) {
                isValid = mode == MODE_NORMAL ? this.scripts_[i2].validate(object, errors) : (mode == MODE_CREATE ? this.scripts_[i2].validateForCreate(object, errors) : this.scripts_[i2].validateForUpdate(object, previous, errors));
                result &= isValid;
            }
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ObjectValidator:" + this.class_.getName() + ":");
        String comma = "";
        int i = -1;
        int lim = this.validators_.length;
        while (++i < lim) {
            buf.append(comma);
            comma = ",";
            buf.append(this.validators_[i].toString());
        }
        i = -1;
        lim = this.scripts_.length;
        while (++i < lim) {
            buf.append(comma);
            comma = ",";
            buf.append(this.scripts_[i].toString());
        }
        return buf.toString();
    }

    public static interface Factory {
        public ObjectValidator validatorFor(Class var1);
    }
}

