/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.validation;

import gov.va.med.term.access.maint.validation.FieldValidator;
import gov.va.med.term.access.maint.validation.Message;
import gov.va.med.term.access.maint.validation.ValidationAtom;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class FieldValidator_String
extends FieldValidator {
    static /* synthetic */ Class class$0;

    public static ValidationAtom max(String value) {
        return new FieldValidator.Max((Comparable)((Object)value));
    }

    public void setMaxValue(String value) {
        this.addValidator(FieldValidator_String.max(value));
    }

    public static ValidationAtom min(String value) {
        return new FieldValidator.Min((Comparable)((Object)value));
    }

    public void setMinValue(String value) {
        this.addValidator(FieldValidator_String.min(value));
    }

    public static ValidationAtom maxLength(int value) {
        return new MaxLength(value);
    }

    public void setMaxLength(int value) {
        this.addValidator(FieldValidator_String.maxLength(value));
    }

    public static ValidationAtom minLength(int value) {
        return new MinLength(value);
    }

    public void setMinLength(int value) {
        this.addValidator(FieldValidator_String.minLength(value));
    }

    public static ValidationAtom length(int value) {
        return new Length(value);
    }

    public void setLength(int value) {
        this.addValidator(FieldValidator_String.length(value));
    }

    public static ValidationAtom pattern(String regexp) {
        return new Regex(regexp);
    }

    public void setPattern(String regexp) {
        this.addValidator(FieldValidator_String.pattern(regexp));
    }

    public void setPatternDescription(String description) {
        Regex regex;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.validation.FieldValidator_String$Regex");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((regex = (Regex)this.findValidator(clazz)) != null) {
            regex.setDescription(description);
        }
    }

    public String pattern() {
        Regex atom;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.validation.FieldValidator_String$Regex");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (atom = (Regex)this.findValidator(clazz)) == null ? null : atom.pattern();
    }

    public static ValidationAtom pattern(String regexp, String description) {
        return new Regex(regexp, description);
    }

    public void setPattern(String regexp, String description) {
        this.addValidator(new Regex(regexp, description));
    }

    public FieldValidator_String() {
    }

    public FieldValidator_String(String name, ValidationAtom validator1) {
        super(name, validator1);
    }

    public FieldValidator_String(String name, ValidationAtom validator1, ValidationAtom validator2) {
        super(name, validator1, validator2);
    }

    public FieldValidator_String(String name, ValidationAtom validator1, ValidationAtom validator2, ValidationAtom validator3) {
        super(name, validator1, validator2, validator3);
    }

    public FieldValidator_String(String name, ValidationAtom validator1, ValidationAtom validator2, ValidationAtom validator3, ValidationAtom validator4) {
        super(name, validator1, validator2, validator3, validator4);
    }

    public FieldValidator_String(String name, ValidationAtom validator1, ValidationAtom validator2, ValidationAtom validator3, ValidationAtom validator4, ValidationAtom validator5) {
        super(name, validator1, validator2, validator3, validator4, validator5);
    }

    public FieldValidator_String(String name, ValidationAtom validator1, ValidationAtom validator2, ValidationAtom validator3, ValidationAtom validator4, ValidationAtom validator5, ValidationAtom validator6) {
        super(name, validator1, validator2, validator3, validator4, validator5, validator6);
    }

    private static class MaxLength
    implements ValidationAtom {
        private int value_;
        private String sValue_;

        public MaxLength(int value) {
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public String validate(Object o) {
            return o != null && o.toString().length() > this.value_ ? Message.obtain("MaxLength", this.sValue_, "The maximum allowed length is {0}.") : null;
        }

        public String toString() {
            return "max-length(" + this.sValue_ + ")";
        }
    }

    private static class MinLength
    implements ValidationAtom {
        private int value_;
        private String sValue_;

        public MinLength(int value) {
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public String validate(Object o) {
            return o != null && o.toString().length() < this.value_ ? Message.obtain("MinLength", this.sValue_, "The minimum allowed length is {0}.") : null;
        }

        public String toString() {
            return "min-length(" + this.sValue_ + ")";
        }
    }

    private static class Length
    implements ValidationAtom {
        private int value_;
        private String sValue_;

        public Length(int value) {
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public String validate(Object o) {
            if (o == null) {
                return null;
            }
            return o.toString().length() != this.value_ ? Message.obtain("Length", this.sValue_, "Length must be {0}.") : null;
        }

        public String toString() {
            return "length(" + this.sValue_ + ")";
        }
    }

    private static class Regex
    implements ValidationAtom {
        private Pattern pattern_;
        private String description_;
        private String editMessage_;
        static /* synthetic */ Class class$0;

        Regex(String pattern) {
            try {
                this.pattern_ = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException x) {
                throw new RuntimeException(x);
            }
            this.description_ = pattern;
            this.editMessage_ = Message.obtain("CrypticRegex", this.pattern_.pattern(), "Must match pattern {0}.");
        }

        Regex(String pattern, String description) {
            try {
                this.pattern_ = Pattern.compile(pattern);
            }
            catch (PatternSyntaxException x) {
                throw new RuntimeException(x);
            }
            this.setDescription(description);
        }

        private boolean matches(Object o) {
            Class<?> c = o.getClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c == clazz) {
                String s = o.toString();
                return s.length() == 0 || this.pattern_.matcher(s).matches();
            }
            return false;
        }

        public void setDescription(String description) {
            this.description_ = description;
            this.editMessage_ = Message.obtain("ExplainedRegex", description, "Must be {0}.");
        }

        public String pattern() {
            return this.pattern_.pattern();
        }

        public String validate(Object o) {
            return o != null && !this.matches(o) ? this.editMessage_ : null;
        }

        public String toString() {
            return "pattern(" + this.description_ + ")";
        }
    }
}

