/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.validation;

import gov.va.med.term.access.maint.validation.FieldValidator;
import gov.va.med.term.access.maint.validation.Message;
import gov.va.med.term.access.maint.validation.ValidationAtom;
import java.math.BigDecimal;

public class FieldValidator_BigDecimal
extends FieldValidator {
    public static ValidationAtom max(String value) {
        return new FieldValidator.Max(new BigDecimal(value));
    }

    public void setMaxValue(String value) {
        this.setMaxValue(new BigDecimal(value));
    }

    public static ValidationAtom max(BigDecimal value) {
        return new FieldValidator.Max(value);
    }

    public void setMaxValue(BigDecimal value) {
        this.addValidator(FieldValidator_BigDecimal.max(value));
    }

    public static ValidationAtom min(String value) {
        return new FieldValidator.Min(new BigDecimal(value));
    }

    public static ValidationAtom min(BigDecimal value) {
        return new FieldValidator.Min(value);
    }

    public void setMinValue(String value) {
        this.setMinValue(new BigDecimal(value));
    }

    public void setMinValue(BigDecimal value) {
        this.addValidator(new FieldValidator.Min(value));
    }

    public static ValidationAtom maxScale(int value) {
        return new MaxScale(value);
    }

    public void setMaxScale(int value) {
        this.addValidator(FieldValidator_BigDecimal.maxScale(value));
    }

    public static ValidationAtom maxScale(String value) {
        return FieldValidator_BigDecimal.maxScale(Integer.parseInt(value));
    }

    public void setMaxScale(String value) {
        this.setMaxScale(Integer.parseInt(value));
    }

    public static ValidationAtom minScale(int value) {
        return new MinScale(value);
    }

    public void setMinScale(int value) {
        this.addValidator(FieldValidator_BigDecimal.minScale(value));
    }

    public static ValidationAtom minScale(String value) {
        return FieldValidator_BigDecimal.minScale(Integer.parseInt(value));
    }

    public void setMinScale(String value) {
        this.setMinScale(Integer.parseInt(value));
    }

    public static ValidationAtom scale(int value) {
        return new Scale(value);
    }

    public void setScale(int value) {
        this.addValidator(FieldValidator_BigDecimal.scale(value));
    }

    public static ValidationAtom scale(String value) {
        return FieldValidator_BigDecimal.scale(Integer.parseInt(value));
    }

    public void setScale(String value) {
        this.setScale(Integer.parseInt(value));
    }

    public FieldValidator_BigDecimal() {
    }

    public FieldValidator_BigDecimal(String name, ValidationAtom validator1) {
        super(name, validator1);
    }

    public FieldValidator_BigDecimal(String name, ValidationAtom validator1, ValidationAtom validator2) {
        super(name, validator1, validator2);
    }

    public FieldValidator_BigDecimal(String name, ValidationAtom validator1, ValidationAtom validator2, ValidationAtom validator3) {
        super(name, validator1, validator2, validator3);
    }

    public FieldValidator_BigDecimal(String name, ValidationAtom validator1, ValidationAtom validator2, ValidationAtom validator3, ValidationAtom validator4) {
        super(name, validator1, validator2, validator3, validator4);
    }

    public FieldValidator_BigDecimal(String name, ValidationAtom validator1, ValidationAtom validator2, ValidationAtom validator3, ValidationAtom validator4, ValidationAtom validator5) {
        super(name, validator1, validator2, validator3, validator4, validator5);
    }

    public FieldValidator_BigDecimal(String name, ValidationAtom validator1, ValidationAtom validator2, ValidationAtom validator3, ValidationAtom validator4, ValidationAtom validator5, ValidationAtom validator6) {
        super(name, validator1, validator2, validator3, validator4, validator5, validator6);
    }

    protected static class MaxScale
    implements ValidationAtom {
        private int value_;
        private String sValue_;

        protected MaxScale(int value) {
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public String validate(Object o) {
            if (o == null) {
                return null;
            }
            BigDecimal value = (BigDecimal)o;
            return value.scale() > this.value_ ? Message.obtain("MaxScale", this.sValue_, "Must have no more than {0} digits after the decimal point.") : null;
        }

        public String toString() {
            return "max-scale(" + this.sValue_ + ")";
        }
    }

    protected static class MinScale
    implements ValidationAtom {
        private int value_;
        private String sValue_;

        protected MinScale(int value) {
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public String validate(Object o) {
            if (o == null) {
                return null;
            }
            BigDecimal value = (BigDecimal)o;
            return value.scale() < this.value_ ? Message.obtain("MinScale", this.sValue_, "Must have at least {0} digits after the decimal point.") : null;
        }

        public String toString() {
            return "min-scale(" + this.sValue_ + ")";
        }
    }

    protected static class Scale
    implements ValidationAtom {
        private int value_;
        private String sValue_;

        protected Scale(int value) {
            this.value_ = value;
            this.sValue_ = String.valueOf(value);
        }

        public String validate(Object o) {
            if (o == null) {
                return null;
            }
            BigDecimal value = (BigDecimal)o;
            return value.scale() != this.value_ ? Message.obtain("Scale", this.sValue_, "Must have exactly {0} digits after the decimal point.") : null;
        }

        public String toString() {
            return "scale(" + this.sValue_ + ")";
        }
    }
}

