/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.validation;

import gov.va.med.term.access.maint.util.UserErrors;
import gov.va.med.term.access.maint.validation.Message;
import gov.va.med.term.access.maint.validation.UniquenessValidator;
import gov.va.med.term.access.maint.validation.ValidationAtom;
import gov.va.med.term.access.maint.validation.Validator;

public class FieldValidator
implements Validator,
ValidationAtom {
    private String name_;
    private ValidationAtom[] validators_ = new ValidationAtom[0];
    private static final UniquenessValidator dummyUnique_ = new UniquenessValidator(){

        public boolean isUnique(Object value) {
            return true;
        }
    };

    public FieldValidator() {
    }

    protected FieldValidator(String name) {
        this.name_ = name;
    }

    protected FieldValidator(String name, ValidationAtom validator) {
        this.name_ = name;
        this.validators_ = new ValidationAtom[]{validator};
    }

    protected FieldValidator(String name, ValidationAtom validator1, ValidationAtom validator2) {
        this.name_ = name;
        this.validators_ = new ValidationAtom[]{validator1, validator2};
    }

    protected FieldValidator(String name, ValidationAtom validator1, ValidationAtom validator2, ValidationAtom validator3) {
        this.name_ = name;
        this.validators_ = new ValidationAtom[]{validator1, validator2, validator3};
    }

    protected FieldValidator(String name, ValidationAtom validator1, ValidationAtom validator2, ValidationAtom validator3, ValidationAtom validator4) {
        this.name_ = name;
        this.validators_ = new ValidationAtom[]{validator1, validator2, validator3, validator4};
    }

    protected FieldValidator(String name, ValidationAtom validator1, ValidationAtom validator2, ValidationAtom validator3, ValidationAtom validator4, ValidationAtom validator5) {
        this.name_ = name;
        this.validators_ = new ValidationAtom[]{validator1, validator2, validator3, validator4, validator5};
    }

    protected FieldValidator(String name, ValidationAtom validator1, ValidationAtom validator2, ValidationAtom validator3, ValidationAtom validator4, ValidationAtom validator5, ValidationAtom validator6) {
        this.name_ = name;
        this.validators_ = new ValidationAtom[]{validator1, validator2, validator3, validator4, validator5, validator6};
    }

    boolean hasUniqueConstraint() {
        int i = this.validators_.length;
        while (--i >= 0) {
            if (this.validators_[i] != dummyUnique_) continue;
            return true;
        }
        return false;
    }

    boolean hasFrozenConstraint() {
        int i = this.validators_.length;
        while (--i >= 0) {
            if (this.validators_[i] != Frozen.instance) continue;
            return true;
        }
        return false;
    }

    protected ValidationAtom findValidator(Class validatorClass) {
        ValidationAtom result = null;
        int i = this.validators_.length;
        while (--i >= 0) {
            if (!validatorClass.isAssignableFrom(this.validators_[i].getClass())) continue;
            result = this.validators_[i];
            break;
        }
        return result;
    }

    String frozenErrorMessage() {
        return Frozen.instance.message();
    }

    public String name() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public ValidationAtom[] validators() {
        return (ValidationAtom[])this.validators_.clone();
    }

    public String validate(Object fieldValue) {
        try {
            int lim = this.validators_.length;
            int i = -1;
            while (++i < lim) {
                String message = this.validators_[i].validate(fieldValue);
                if (message == null) continue;
                return message;
            }
        }
        catch (ShortCircuit x) {
            return x.isValid() ? null : x.getMessage();
        }
        return null;
    }

    public boolean validate(Object fieldValue, UserErrors errors) {
        String message = this.validate(fieldValue);
        if (message != null) {
            errors.put(fieldValue, this.name_, message);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addValidator(ValidationAtom v) {
        ValidationAtom[] validationAtomArray = this.validators_;
        synchronized (this.validators_) {
            ValidationAtom[] newValidators = new ValidationAtom[this.validators_.length + 1];
            System.arraycopy(this.validators_, 0, newValidators, 0, this.validators_.length);
            newValidators[this.validators_.length] = v;
            this.validators_ = newValidators;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prependValidator(ValidationAtom v) {
        ValidationAtom[] validationAtomArray = this.validators_;
        synchronized (this.validators_) {
            ValidationAtom[] newValidators = new ValidationAtom[this.validators_.length + 1];
            System.arraycopy(this.validators_, 0, newValidators, 1, this.validators_.length);
            newValidators[0] = v;
            this.validators_ = newValidators;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static ValidationAtom noOp() {
        return NoOp.instance;
    }

    public final void setNoOp(boolean value) {
        if (value) {
            this.addValidator(NoOp.instance);
        }
    }

    public static ValidationAtom frozen() {
        return Frozen.instance;
    }

    public void setFrozen(boolean value) {
        if (value) {
            this.addValidator(Frozen.instance);
        }
    }

    public static ValidationAtom accept() {
        return Accept.instance;
    }

    public final void setAccept(boolean value) {
        if (value) {
            this.addValidator(Accept.instance);
        }
    }

    public static ValidationAtom reject() {
        return Reject.instance;
    }

    public final void setReject(boolean value) {
        if (value) {
            this.addValidator(Reject.instance);
        }
    }

    public static ValidationAtom required() {
        return Required.instance;
    }

    public void setRequired(boolean value) {
        if (value) {
            this.prependValidator(Required.instance);
        }
    }

    public static ValidationAtom unique() {
        return dummyUnique_;
    }

    public void setUnique(boolean value) {
        if (value) {
            this.addValidator(FieldValidator.unique());
        }
    }

    public String rules() {
        StringBuffer buf = new StringBuffer();
        int i = -1;
        int lim = this.validators_.length;
        while (++i < lim) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this.validators_[i].toString());
        }
        return buf.toString();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String classname = this.getClass().getName();
        String type = classname.substring(classname.lastIndexOf(95) + 1);
        buf.append(this.name_);
        buf.append(':');
        buf.append(type);
        if (this.validators_.length > 0) {
            buf.append('[');
            buf.append(this.rules());
            buf.append(']');
        }
        return buf.toString();
    }

    private static class ShortCircuit
    extends RuntimeException {
        private final boolean isValid_;

        public ShortCircuit(String message, boolean isValid) {
            super(message);
            this.isValid_ = isValid;
        }

        public boolean isValid() {
            return this.isValid_;
        }
    }

    protected static class NoOp
    implements ValidationAtom {
        public static final NoOp instance = new NoOp();

        protected NoOp() {
        }

        public String validate(Object o) {
            return null;
        }

        public String toString() {
            return "no-op";
        }
    }

    private static class Accept
    implements ValidationAtom {
        public static final Accept instance = new Accept();
        private static final ShortCircuit shortCircuit_ = new ShortCircuit(null, true);

        Accept() {
        }

        public String validate(Object o) {
            throw shortCircuit_;
        }

        public String toString() {
            return "accept";
        }
    }

    private static class Reject
    implements ValidationAtom {
        public static final Reject instance = new Reject();

        Reject() {
        }

        public String validate(Object o) {
            throw new ShortCircuit(Message.obtain("Reject", "Invalid value."), false);
        }

        public String toString() {
            return "reject";
        }
    }

    private static class Required
    implements ValidationAtom {
        public static final Required instance = new Required();
        static /* synthetic */ Class class$0;

        Required() {
        }

        private static boolean isAllWhitespace(String s) {
            int i = s.length();
            while (--i >= 0 && Character.isWhitespace(s.charAt(i))) {
            }
            return i < 0;
        }

        private static boolean present(Object o) {
            Class<?> c = o.getClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (c == clazz) {
                String s = o.toString();
                return s.length() > 0 && !Required.isAllWhitespace(s);
            }
            return true;
        }

        public String validate(Object o) {
            return o == null || !Required.present(o) ? Message.obtain("Required", "A value is required.") : null;
        }

        public String toString() {
            return "required";
        }
    }

    private static class Frozen
    extends NoOp {
        public static final Frozen instance = new Frozen();

        Frozen() {
        }

        public String message() {
            return Message.obtain("Frozen", "Value cannot be changed.");
        }

        public String toString() {
            return "unchangeable";
        }
    }

    protected static class Max
    implements ValidationAtom {
        private Comparable value_;
        private String sValue_;

        protected Max(Comparable value) {
            this.value_ = value;
            this.sValue_ = this.valueToString(value);
        }

        public String validate(Object o) {
            return o != null && this.value_.compareTo(o) < 0 ? Message.obtain("Max", this.sValue_, "The maximum allowed value is {0}.") : null;
        }

        protected String valueToString(Comparable value) {
            return String.valueOf(value);
        }

        public String toString() {
            return "max(" + this.sValue_ + ")";
        }
    }

    protected static class Min
    implements ValidationAtom {
        private Comparable value_;
        private String sValue_;

        public Min(Comparable value) {
            this.value_ = value;
            this.sValue_ = this.valueToString(this.value_);
        }

        public String validate(Object o) {
            return o != null && this.value_.compareTo(o) > 0 ? Message.obtain("Min", this.sValue_, "The minimum allowed value is {0}.") : null;
        }

        protected String valueToString(Comparable value) {
            return String.valueOf(value);
        }

        public String toString() {
            return "min(" + this.sValue_ + ")";
        }
    }
}

