/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.util.factory.db;

import gov.va.med.authentication.kernel.LoginUserInfoVO;
import gov.va.med.term.access.maint.factory.db.hibernate.HibernateAdapter;
import gov.va.med.term.access.maint.util.AuditInfo;
import gov.va.med.term.access.maint.util.Auditable;
import gov.va.med.term.access.maint.util.ThreadGlobals;
import gov.va.med.term.access.maint.util.Transaction;
import java.sql.Timestamp;

public class AuditObserver
extends HibernateAdapter {
    private String getUserId() {
        LoginUserInfoVO userInfo = (LoginUserInfoVO)ThreadGlobals.instance().get("gov.va.med.authentication.kernel.LoginUserInfo");
        String userId = userInfo != null ? userInfo.getUserDuz() : "unknown";
        return userId;
    }

    public void preSave(Object object, Transaction transaction) {
        if (object instanceof Auditable) {
            Auditable auditable = (Auditable)object;
            if (auditable.getAuditInfo() != null) {
                throw new RuntimeException("AuditInfo is managed by the persistence layer.");
            }
            auditable.setAuditInfo(new AuditInfo(new Timestamp(System.currentTimeMillis()), this.getUserId()));
        }
    }

    public void preUpdate(Object object, Transaction transaction) {
        if (object instanceof Auditable) {
            Auditable auditable = (Auditable)object;
            if (auditable.getAuditInfo() == null) {
                throw new RuntimeException("AuditInfo is managed by the persistence layer.");
            }
            AuditInfo auditInfo = auditable.getAuditInfo();
            auditInfo.setUpdated(new Timestamp(System.currentTimeMillis()));
            auditInfo.setUpdatedBy(this.getUserId());
        }
    }
}

