/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class MethodAccessor {
    private static Method getMethod(Class clazz, String name, Class[] parameterTypes) throws NoSuchMethodException {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            if (!Modifier.isPublic(method.getModifiers())) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                try {
                    return MethodAccessor.getMethod(superclass, name, parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            throw e;
        }
    }

    public static Object invoke(Class clazz, String name) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodAccessor.getMethod(clazz, name, null).invoke(null, null);
    }

    public static Object invoke(Class clazz, String name, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodAccessor.getMethod(clazz, name, parameterTypes).invoke(null, args);
    }

    public static Object invoke(Object object, String name) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodAccessor.getMethod(object.getClass(), name, null).invoke(object, null);
    }

    public static Object invoke(Object object, String name, Class[] parameterTypes, Object[] args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return MethodAccessor.getMethod(object.getClass(), name, parameterTypes).invoke(object, args);
    }
}

