/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.util;

import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Cache {
    private Map cache_ = new HashMap();
    private Loader loader_ = null;
    private boolean isCloned_ = false;

    public Cache(Loader loader) {
        this(loader, false);
    }

    public Cache(Loader loader, boolean clone) {
        this.loader_ = loader;
        this.isCloned_ = clone;
    }

    public Object fetch(Object key) {
        Object value;
        SoftReference<Object> reference = (SoftReference<Object>)this.cache_.get(key);
        Object object = value = reference != null ? (Object)reference.get() : null;
        if (value == null) {
            value = this.loader_.obtain(key);
            if (value == null) {
                return null;
            }
            reference = new SoftReference<Object>(value);
            this.cache_.put(key, reference);
        }
        return this.isCloned_ ? this.clone(value) : value;
    }

    private Object clone(Object value) {
        if (value == null) {
            throw new NullPointerException("Cannot clone null.");
        }
        try {
            Method method = value.getClass().getMethod("clone", null);
            return method.invoke(value, null);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Class must be cloneable (" + value.getClass().getName() + ").", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("The clone method must be public.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Cloning error.", e);
        }
    }

    public static interface Loader {
        public Object obtain(Object var1);
    }
}

