/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.servlet.compress;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CompressionResponseStream
extends ServletOutputStream {
    private static Logger logger_;
    protected int threshold_ = 0;
    protected boolean compressing_ = false;
    protected byte[] buffer_ = null;
    protected int nBytesInBuffer_ = 0;
    protected GZIPOutputStream gzipStream_ = null;
    protected boolean closed_ = false;
    protected int nBytesWritten_ = 0;
    protected HttpServletResponse response_ = null;
    protected ServletOutputStream output_ = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.ui.servlet.compress.CompressionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public CompressionResponseStream(HttpServletResponse response, int threshold) throws IOException {
        this.response_ = response;
        this.output_ = response.getOutputStream();
        this.threshold_ = threshold;
        this.buffer_ = new byte[threshold];
    }

    public void close() throws IOException {
        if (this.closed_) {
            throw new IllegalStateException("This output stream has already been closed");
        }
        if (this.gzipStream_ != null) {
            this.gzipStream_.close();
        } else {
            this.flush();
        }
        this.closed_ = true;
    }

    public void flush() throws IOException {
        if (this.closed_) {
            throw new IllegalStateException("Cannot flush a closed output stream");
        }
        if (this.nBytesInBuffer_ > 0) {
            this.output_.write(this.buffer_, 0, this.nBytesInBuffer_);
            this.nBytesInBuffer_ = 0;
        }
    }

    private void flushToGZip() throws IOException {
        if (this.nBytesInBuffer_ > 0) {
            this.gzipStream_.write(this.buffer_, 0, this.nBytesInBuffer_);
            this.nBytesInBuffer_ = 0;
            this.buffer_ = null;
        }
        this.compressing_ = true;
    }

    public void write(int b) throws IOException {
        if (this.closed_) {
            throw new IllegalStateException("Cannot write to a closed output stream");
        }
        if (this.nBytesInBuffer_ == this.buffer_.length) {
            this.ensureGZip();
            this.flushToGZip();
        }
        if (this.compressing_) {
            this.writeToGZip(b);
        } else {
            this.buffer_[this.nBytesInBuffer_++] = (byte)b;
            ++this.nBytesWritten_;
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed_) {
            throw new IllegalStateException("Cannot write to a closed output stream");
        }
        if (len == 0) {
            return;
        }
        if (this.compressing_) {
            this.writeToGZip(b, off, len);
        } else if (len <= this.buffer_.length - this.nBytesInBuffer_) {
            System.arraycopy(b, off, this.buffer_, this.nBytesInBuffer_, len);
            this.nBytesInBuffer_ += len;
        } else {
            this.ensureGZip();
            this.writeToGZip(b, off, len);
        }
        this.nBytesWritten_ += len;
    }

    private void ensureGZip() throws IOException {
        if (this.gzipStream_ == null) {
            this.gzipStream_ = new GZIPOutputStream((OutputStream)this.output_);
            this.flushToGZip();
            this.response_.addHeader("Content-Encoding", "gzip");
            logger_.info((Object)"GZip Compressing response");
        }
    }

    private void writeToGZip(int b) throws IOException {
        this.ensureGZip();
        this.gzipStream_.write(b);
    }

    public void writeToGZip(byte[] b, int off, int len) throws IOException {
        this.ensureGZip();
        this.gzipStream_.write(b, off, len);
    }

    public void reset() {
        if (this.gzipStream_ != null) {
            this.gzipStream_ = null;
        }
        if (this.buffer_ != null) {
            this.buffer_ = new byte[this.threshold_];
        }
        this.nBytesWritten_ = 0;
    }
}

