/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.servlet.compress;

import gov.va.med.term.access.maint.ui.servlet.compress.CompressionResponseWrapper;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class CompressionFilter
implements Filter {
    private static Logger logger_;
    private FilterConfig config_ = null;
    protected int threshold_ = 10000;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.ui.servlet.compress.CompressionFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public void init(FilterConfig filterConfig) {
        String str;
        this.config_ = filterConfig;
        if (filterConfig != null && (str = filterConfig.getInitParameter("compressionThreshold")) != null) {
            this.threshold_ = Integer.parseInt(str);
        }
        logger_.info((Object)("GZIP compression enabled for responses greater than " + this.threshold_ + " bytes"));
    }

    public void destroy() {
        this.config_ = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse && this.agentSupportsGZip(request)) {
            CompressionResponseWrapper wrappedResponse = new CompressionResponseWrapper((HttpServletResponse)response, this.threshold_);
            response = wrappedResponse;
        }
        chain.doFilter(request, response);
    }

    private boolean agentSupportsGZip(ServletRequest request) {
        Enumeration e = ((HttpServletRequest)request).getHeaders("accept-encoding");
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (name.indexOf("gzip") < 0) continue;
            return true;
        }
        return false;
    }
}

