/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.servlet;

import gov.va.med.term.access.maint.ui.servlet.HttpServletException;
import java.util.Enumeration;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ServletRequestLogger {
    private static Logger logger_;
    private static final String lineSeparator_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.ui.servlet.ServletRequestLogger");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        lineSeparator_ = System.getProperty("line.separator");
    }

    public static void log(HttpServletRequest request) {
        StringBuffer buffer = new StringBuffer(100);
        ServletRequestLogger.log(request, buffer);
        logger_.info((Object)buffer.toString());
    }

    public static void error(HttpServletException x) {
        logger_.info((Object)"Request failed", (Throwable)x);
    }

    public static void failure(Throwable exception) {
        logger_.error((Object)"Request failed with an exception", exception);
    }

    public static void success() {
        logger_.info((Object)"Request completed successfully");
    }

    private static void log(HttpServletRequest request, StringBuffer buffer) {
        buffer.append(request.getRemoteAddr());
        buffer.append('-');
        buffer.append(request.getRemoteUser());
        buffer.append("-[");
        buffer.append(request.getHeader("User-Agent"));
        buffer.append("]-");
        buffer.append(request.getMethod());
        buffer.append(' ');
        buffer.append(request.getRequestURI());
        ServletRequestLogger.logParameters((ServletRequest)request, buffer);
        if (logger_.isInfoEnabled()) {
            ServletRequestLogger.logHeaders(request, buffer);
        }
        buffer.append(lineSeparator_);
    }

    private static void logParameters(ServletRequest request, StringBuffer buffer) {
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String comma;
            int i;
            int lim;
            String name = e.nextElement().toString();
            buffer.append(' ');
            buffer.append(name);
            buffer.append('=');
            String[] parm = request.getParameterValues(name);
            buffer.append('[');
            if (ServletRequestLogger.containsIgnoreCase(name, "PASSWORD")) {
                lim = parm.length;
                i = -1;
                comma = "";
                while (++i < lim) {
                    buffer.append(comma);
                    int j = parm[i].length();
                    while (--j >= 0) {
                        buffer.append('*');
                    }
                    comma = ",";
                }
            } else {
                lim = parm.length;
                i = -1;
                comma = "";
                while (++i < lim) {
                    buffer.append(comma);
                    buffer.append(parm[i]);
                    comma = ",";
                }
            }
            buffer.append(']');
        }
    }

    private static void logHeaders(HttpServletRequest request, StringBuffer buffer) {
        Enumeration e = request.getHeaderNames();
        if (e == null) {
            return;
        }
        buffer.append(" headers=[");
        while (e.hasMoreElements()) {
            String name = e.nextElement().toString();
            buffer.append(name);
            buffer.append('=');
            buffer.append(request.getHeader(name));
            if (!e.hasMoreElements()) continue;
            buffer.append(',');
        }
        buffer.append(']');
    }

    private static boolean containsIgnoreCase(String s, String seeking) {
        int len = seeking.length();
        int i = s.length() - len + 1;
        while (--i >= 0) {
            if (!s.regionMatches(true, i, seeking, 0, len)) continue;
            return true;
        }
        return false;
    }
}

