/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.servlet;

import gov.va.med.term.access.maint.ui.StringOutputter;
import gov.va.med.term.access.maint.ui.servlet.HttpServletBase;
import gov.va.med.term.access.maint.ui.servlet.HttpServletException;
import gov.va.med.term.access.maint.ui.servlet.Page;
import gov.va.med.term.access.maint.ui.servlet.ServletArgumentDictionary;
import gov.va.med.term.access.maint.ui.servlet.ServletUtils;
import gov.va.med.term.access.maint.ui.servlet.SessionDictionary;
import gov.va.med.term.access.maint.ui.servlet.URLOutputter;
import gov.va.med.term.access.maint.util.Transaction;
import gov.va.med.term.access.maint.util.UserErrors;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public abstract class PageServlet
extends HttpServletBase {
    private static Logger logger_;
    private static final UserErrors emptyErrors_;
    private static final String statusMessageName_ = "status-message";
    private Class authorizerClass_;
    private Class roleMapperClass_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.ui.servlet.PageServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        emptyErrors_ = new UserErrors();
    }

    public PageServlet() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("gov.va.med.term.access.maint.ui.dataview.factory.DefaultAuthorizer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.authorizerClass_ = clazz;
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("gov.va.med.term.access.maint.ui.dataview.factory.DefaultRoleMapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.roleMapperClass_ = clazz2;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String authorizerClassname = config.getInitParameter("authorizer");
        if (authorizerClassname != null) {
            try {
                this.authorizerClass_ = Class.forName(authorizerClassname);
            }
            catch (Exception e) {
                logger_.error((Object)("Could not find authorizer class: " + authorizerClassname), (Throwable)e);
            }
        }
        logger_.info((Object)("Using authorizer: " + this.authorizerClass_));
        String roleMapperClassname = config.getInitParameter("roleMapper");
        if (roleMapperClassname != null) {
            try {
                this.roleMapperClass_ = Class.forName(roleMapperClassname);
            }
            catch (Exception e) {
                logger_.error((Object)("Could not find roleMapper class: " + roleMapperClassname), (Throwable)e);
            }
        }
        logger_.info((Object)("Using roleMapper: " + this.roleMapperClass_));
    }

    protected boolean allowCache(Page page) {
        return false;
    }

    protected abstract Page createPage(HttpServletRequest var1) throws HttpServletException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, HttpServletException {
        logger_.info((Object)"Entering doGet.");
        Transaction txn = null;
        try {
            try {
                logger_.info((Object)"Creating transaction.");
                txn = Transaction.factory.create();
                logger_.info((Object)("Transaction = " + txn));
                Page page = this.createPage(request);
                if (!this.allowCache(page)) {
                    logger_.info((Object)("Calling ServletUtils.noCache(response)" + txn));
                    ServletUtils.noCache(response);
                }
                Hashtable<String, Object> values = new Hashtable<String, Object>();
                ((Dictionary)values).put("input", new ServletArgumentDictionary((ServletRequest)request));
                ((Dictionary)values).put("errors", emptyErrors_);
                String message = this.statusMessage(request);
                if (message != null) {
                    logger_.info((Object)("Calling values.put('statusMessage', message)" + txn));
                    ((Dictionary)values).put("statusMessage", message);
                }
                logger_.info((Object)("Calling output(request, response, page, values)" + txn));
                this.output(request, response, page, values);
                if (txn.wasRolledBack()) {
                    txn.rollback();
                } else {
                    txn.commit();
                }
            }
            catch (Throwable t2) {
                if (txn != null) {
                    try {
                        txn.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (t2 instanceof RuntimeException) throw (RuntimeException)t2;
                RuntimeException t2 = new RuntimeException(t2);
                throw (RuntimeException)t2;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            logger_.info((Object)"Exiting doGet.");
            throw throwable;
        }
        {
            Object var7_12 = null;
        }
        logger_.info((Object)"Exiting doGet.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, HttpServletException {
        block15: {
            block14: {
                block13: {
                    logger_.info((Object)"Entering doPost.");
                    Transaction txn = null;
                    try {
                        try {
                            logger_.info((Object)"Creating transaction.");
                            txn = Transaction.factory.create();
                            logger_.info((Object)("Transaction = " + txn));
                            logger_.info((Object)("Creating page ..." + txn));
                            Page page = this.createPage(request);
                            logger_.info((Object)("Page created." + txn));
                            Dictionary input = page.modifyInput(new ServletArgumentDictionary((ServletRequest)request));
                            UserErrors errors = new UserErrors();
                            logger_.info((Object)("Apply to page ..." + txn));
                            Boolean result = page.apply(input, errors);
                            logger_.info((Object)("Returned from page.apply ..." + txn));
                            if (result == null) {
                                logger_.info((Object)("result == null" + txn));
                                response.sendRedirect(response.encodeRedirectURL(String.valueOf(request.getContextPath()) + page.nextPage(input, request.getParameter("scrollpage") == null ? request.getPathInfo() : String.valueOf(request.getPathInfo()) + request.getParameter("scrollpage"))));
                                logger_.info((Object)("Rolling back txn " + txn));
                                txn.rollback();
                                Object var9_11 = null;
                                break block13;
                            }
                            if (result.booleanValue()) {
                                logger_.info((Object)("result = " + result));
                                String message = page.successMessage();
                                if (message != null) {
                                    this.setStatusMessage(request, message);
                                }
                                if (txn.wasRolledBack()) {
                                    logger_.info((Object)("Rolling back txn " + txn));
                                    txn.rollback();
                                } else {
                                    logger_.info((Object)("Committing txn " + txn));
                                    txn.commit();
                                }
                                response.sendRedirect(response.encodeRedirectURL(String.valueOf(request.getContextPath()) + page.nextPage(input, request.getParameter("scrollpage") == null ? request.getPathInfo() : String.valueOf(request.getPathInfo()) + request.getParameter("scrollpage"))));
                                break block14;
                            }
                            logger_.info((Object)("result = " + result));
                            Hashtable<String, Object> values = new Hashtable<String, Object>();
                            ((Dictionary)values).put("input", input);
                            ((Dictionary)values).put("errors", errors);
                            ((Dictionary)values).put("statusMessage", page.failureMessage());
                            this.output(request, response, page, values);
                            logger_.info((Object)("Rolling back txn " + txn));
                            txn.rollback();
                            break block15;
                        }
                        catch (Throwable t2) {
                            if (txn != null) {
                                try {
                                    txn.rollback();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (t2 instanceof RuntimeException) throw (RuntimeException)t2;
                            RuntimeException t2 = new RuntimeException(t2);
                            throw (RuntimeException)t2;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        logger_.info((Object)"Exiting doPost.");
                        throw throwable;
                    }
                }
                logger_.info((Object)"Exiting doPost.");
                return;
            }
            Object var9_12 = null;
            logger_.info((Object)"Exiting doPost.");
            return;
        }
        Object var9_14 = null;
        logger_.info((Object)"Exiting doPost.");
    }

    private String statusMessage(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String result = (String)session.getAttribute(statusMessageName_);
        if (result != null) {
            session.removeAttribute(statusMessageName_);
        }
        return result;
    }

    private void setStatusMessage(HttpServletRequest request, String message) {
        HttpSession session = request.getSession();
        session.setAttribute(statusMessageName_, (Object)message);
    }

    protected void output(HttpServletRequest request, HttpServletResponse response, Page page, Dictionary context) throws IOException {
        context.put("page", page);
        context.put("session", new SessionDictionary(request.getSession()));
        context.put("urlOutputter", new StringOutputter(new URLOutputter(response)));
        context.put("requestURI", request.getParameter("scrollpage") == null ? request.getRequestURI() : String.valueOf(request.getRequestURI()) + request.getParameter("scrollpage"));
        context.put("servletDirectory", ServletUtils.servletDirectory(request));
        context.put("rootDirectory", request.getContextPath());
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("javax.servlet.http.HttpServletRequest");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            context.put("authorizer", this.authorizerClass_.getConstructor(classArray).newInstance(request));
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't instantiate authorizer: '" + this.authorizerClass_ + "'", e);
        }
        try {
            context.put("roleMapper", this.roleMapperClass_.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't instantiate roleMapper: '" + this.roleMapperClass_ + "'", e);
        }
        this.updateContext(page, context);
        response.setContentType(page.contentType());
        PrintWriter out = response.getWriter();
        page.output(context, out);
        out.flush();
        out.close();
    }

    protected void updateContext(Page page, Dictionary context) {
    }
}

