/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.servlet;

import gov.va.med.term.access.maint.ui.servlet.ContentServlet;
import gov.va.med.term.access.maint.ui.servlet.HttpServletException;
import java.util.Hashtable;

public class CachingContentServlet
extends ContentServlet {
    private Hashtable cache_ = new Hashtable();

    protected byte[] contentOf(String contentName) throws HttpServletException {
        CacheEntry entry = (CacheEntry)this.cache_.get(contentName);
        if (entry == null || entry.lastModified() < this.lastModified(contentName)) {
            entry = this.newEntry(contentName);
        }
        return entry.content();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry newEntry(String contentName) throws HttpServletException {
        Hashtable hashtable = this.cache_;
        synchronized (hashtable) {
            CacheEntry entry = (CacheEntry)this.cache_.get(contentName);
            if (entry == null) {
                entry = new CacheEntry(super.contentOf(contentName), super.lastModified(contentName));
                this.cache_.put(contentName, entry);
            }
            return entry;
        }
    }

    private class CacheEntry {
        private long lastModified_;
        private byte[] content_;

        public CacheEntry(byte[] content, long lastModified) {
            this.lastModified_ = lastModified;
            this.content_ = content;
        }

        public long lastModified() {
            return this.lastModified_;
        }

        public byte[] content() {
            return this.content_;
        }
    }
}

