/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.dataview.factory.xml;

import gov.va.med.term.access.maint.ui.dataview.TypeDescriptor;
import gov.va.med.term.access.maint.xml.Mapping;
import gov.va.med.term.access.maint.xml.Unmarshaller;
import gov.va.med.term.access.util.PropertiesLoader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

class ApplicationTypeDescriptorFactory {
    private static Logger logger_;
    private static final String contentList_ = "/_content.properties";
    private final String dataDir_;
    private Vector cache_ = new Vector();
    private Hashtable keyCache_ = new Hashtable();
    private boolean gotAll_ = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.ui.dataview.factory.xml.ApplicationTypeDescriptorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    private String initializeDataDir(String applicationPackage) {
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("applicationPackage = " + applicationPackage));
        }
        String result = null;
        Properties p = PropertiesLoader.find((String)applicationPackage, (String)"TypeDescriptorFactory", null);
        if (p != null) {
            result = p.getProperty("xmldir");
            if (result == null) {
                String msg = "Property 'xmldir' not found in TypeDescriptorFactory.properties for application package " + applicationPackage;
                logger_.error((Object)msg);
                throw new RuntimeException(msg);
            }
        } else {
            result = "/" + applicationPackage.replace('.', '/') + "/dataview";
            URL listUrl = this.getClass().getResource(String.valueOf(result) + contentList_);
            if (listUrl == null) {
                String msg = "Cannot locate type descriptors for application package " + applicationPackage + "(Expected " + result + contentList_ + ")";
                logger_.error((Object)msg);
                throw new RuntimeException(msg);
            }
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("result = " + result));
        }
        return result;
    }

    public ApplicationTypeDescriptorFactory(String applicationPackage) {
        this.dataDir_ = this.initializeDataDir(applicationPackage);
    }

    public synchronized TypeDescriptor obtain(String name) {
        TypeDescriptor result;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("name = " + name));
        }
        if ((result = (TypeDescriptor)this.keyCache_.get(name)) == null) {
            result = this.read_(name);
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("result = " + result));
        }
        return result;
    }

    public synchronized TypeDescriptor[] obtain() {
        Object[] result;
        if (this.gotAll_) {
            result = new TypeDescriptor[this.cache_.size()];
            this.cache_.copyInto(result);
        } else {
            result = this.read_();
        }
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("result = " + result));
        }
        return result;
    }

    private TypeDescriptor[] read_() {
        Vector<TypeDescriptor> vResult = new Vector<TypeDescriptor>();
        String filename = String.valueOf(this.dataDir_) + contentList_;
        URL listUrl = this.getClass().getResource(filename);
        if (listUrl == null) {
            String msg = "Couldn't find type descriptor list: " + filename;
            logger_.error((Object)msg);
            throw new RuntimeException(msg);
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(listUrl.openStream()));
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                vResult.addElement(this.obtain(line.substring(0, line.length() - 4)));
            }
            reader.close();
        }
        catch (IOException x) {
            String msg = "Error reading type descriptor list: " + filename;
            logger_.error((Object)msg, (Throwable)x);
            throw new RuntimeException(msg, x);
        }
        Object[] result = new TypeDescriptor[vResult.size()];
        vResult.copyInto(result);
        Arrays.sort(result);
        this.gotAll_ = true;
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("result = " + result));
        }
        return result;
    }

    private TypeDescriptor read_(String name) {
        TypeDescriptor result = null;
        String filename = String.valueOf(this.dataDir_) + '/' + name + ".xml";
        try {
            URL dataUrl = this.getClass().getResource(filename);
            if (dataUrl == null) {
                String msg = "Couldn't find data file: " + filename;
                logger_.error((Object)msg);
                throw new RuntimeException(msg);
            }
            logger_.info((Object)("Loading descriptor file " + dataUrl.toString()));
            InputStreamReader reader = new InputStreamReader(dataUrl.openStream());
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("gov.va.med.term.access.maint.ui.dataview.factory.xml.TypeDescriptorFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Unmarshaller unmarshaller = Unmarshaller.factory.create(Mapping.factory.obtain(clazz));
            result = (TypeDescriptor)unmarshaller.unmarshal(reader);
            reader.close();
        }
        catch (IOException x) {
            String msg = "Error reading file: " + filename;
            logger_.error((Object)msg, (Throwable)x);
            throw new RuntimeException(msg, x);
        }
        this.keyCache_.put(name, result);
        this.cache_.addElement(result);
        if (logger_.isDebugEnabled()) {
            logger_.debug((Object)("result = " + result));
        }
        return result;
    }
}

