/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.dataview.factory;

import gov.va.med.term.access.maint.conversion.StringConverter;
import gov.va.med.term.access.maint.ui.dataview.FieldDescriptor;
import gov.va.med.term.access.maint.ui.dataview.FieldTransformer;
import gov.va.med.term.access.maint.ui.dataview.Relationship;
import gov.va.med.term.access.maint.ui.dataview.Role;
import gov.va.med.term.access.maint.ui.dataview.TypeDescriptor;
import gov.va.med.term.access.maint.validation.FieldValidator;
import gov.va.med.term.access.types.Referenceable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class FieldDescriptorImpl
implements FieldDescriptor {
    private static Logger logger_;
    private String name_ = null;
    private String userName_ = null;
    private String shortDescription_ = null;
    private String validationRules_ = "";
    private Class holder_ = null;
    private Method accessor_ = null;
    private Method mutator_ = null;
    private String accessorName_ = null;
    private Class type_ = null;
    private int displaySize_ = 0;
    private int maxLength_ = 0;
    private String ownerFieldName_ = null;
    private String referringFieldName_ = null;
    private boolean isRequired_ = false;
    private boolean isFrozen_ = false;
    private boolean isSystemAssigned_ = false;
    private boolean isPassword_ = false;
    private boolean isMulti_ = false;
    private boolean displayOnList_ = true;
    private boolean displayOnSearch_ = true;
    private boolean displayOnView_ = true;
    private boolean allowPatternSearch_ = false;
    private boolean allowSoundexSearch_ = false;
    private boolean isReference_ = false;
    private TypeDescriptor typeDescriptor_ = null;
    private Boolean checkedTypeDescriptor_ = Boolean.FALSE;
    private Boolean isGroup_ = null;
    private String transformString_ = null;
    private FieldTransformer[] transformers_ = new FieldTransformer[0];
    private String defaultValueString_ = null;
    private Object defaultValue_ = null;
    private String constrainedByName_ = null;
    private FieldDescriptor constrainedBy_ = null;
    private FieldDescriptorImpl[] constrainedDependents_ = new FieldDescriptorImpl[0];
    private String[] constrainingTypePath_ = new String[0];
    private Method[] constrainingTypeMethods_ = null;
    private String[] constrainedTypePath_ = new String[0];
    private Method[] constrainedTypeMethods_ = null;
    private static final char KEY_STRING_SEPARATOR = '_';
    private Role role_ = Role.undefined;
    private Relationship relationship_ = Relationship.undefined;
    private static final HashMap typeMap_;
    private String associationName_ = null;
    private Class association_ = null;
    private String associationBackRef_ = null;
    private String associationPeerRef_ = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.ui.dataview.factory.FieldDescriptorImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        typeMap_ = new HashMap();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("boolean", clazz2);
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("double", clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("int", clazz4);
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("long", clazz5);
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("BigDecimal", clazz6);
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("java.sql.Blob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("Blob", clazz7);
        Class<?> clazz8 = class$1;
        if (clazz8 == null) {
            try {
                clazz8 = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("Boolean", clazz8);
        Class<?> clazz9 = class$7;
        if (clazz9 == null) {
            try {
                clazz9 = class$7 = Class.forName("java.sql.Clob");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("Clob", clazz9);
        Class<?> clazz10 = class$2;
        if (clazz10 == null) {
            try {
                clazz10 = class$2 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("Double", clazz10);
        Class<?> clazz11 = class$3;
        if (clazz11 == null) {
            try {
                clazz11 = class$3 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("Integer", clazz11);
        Class<?> clazz12 = class$4;
        if (clazz12 == null) {
            try {
                clazz12 = class$4 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("Long", clazz12);
        Class<?> clazz13 = class$8;
        if (clazz13 == null) {
            try {
                clazz13 = class$8 = Class.forName("java.io.Serializable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("Serializable", clazz13);
        Class<?> clazz14 = class$9;
        if (clazz14 == null) {
            try {
                clazz14 = class$9 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("String", clazz14);
        Class<?> clazz15 = class$10;
        if (clazz15 == null) {
            try {
                clazz15 = class$10 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("Date", clazz15);
        Class<?> clazz16 = class$11;
        if (clazz16 == null) {
            try {
                clazz16 = class$11 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        typeMap_.put("Timestamp", clazz16);
        FieldDescriptorImpl.conditionallySupport("Day", "gov.va.med.term.access.types.Day");
        FieldDescriptorImpl.conditionallySupport("ImpreciseDate", "gov.va.med.term.access.types.ImpreciseDate");
    }

    public void setName(String value) {
        this.name_ = value;
        if (this.accessorName_ == null) {
            String string = this.accessorName_ = value.length() > 2 && value.startsWith("is") && Character.isUpperCase(value.charAt(2)) ? value : "get" + this.capitalize(value);
        }
        if (this.userName_ == null) {
            this.userName_ = FieldDescriptorImpl.javaNameToText(value);
        }
    }

    private static String javaNameToText(String name) {
        StringBuffer buf = new StringBuffer(name.length() + 5);
        buf.append(Character.toUpperCase(name.charAt(0)));
        int i = 0;
        while (++i < name.length()) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                buf.append(' ');
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public final String capitalize(String s) {
        return String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
    }

    public String name() {
        return this.name_;
    }

    public void setShortDescription(String value) {
        this.shortDescription_ = value;
    }

    public String shortDescription() {
        return this.shortDescription_;
    }

    public String userName() {
        return this.userName_;
    }

    public void setUserName(String value) {
        this.userName_ = value;
    }

    void setOwner(Class value) {
        this.holder_ = value;
    }

    public void setValidationRules(String value) {
        this.validationRules_ = value;
    }

    public String validationRules() {
        return this.validationRules_;
    }

    void setValidator(FieldValidator validator) {
        if (this.validationRules_.length() == 0) {
            this.validationRules_ = validator.rules();
        }
    }

    private static void conditionallySupport(String name, String className) {
        try {
            Class<?> c = Class.forName(className);
            typeMap_.put(name, c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setType(String value) {
        Class<?> type;
        if (value.endsWith("[]")) {
            this.isMulti_ = true;
            value = value.substring(0, value.length() - 2);
        }
        if ((type = (Class<?>)typeMap_.get(value)) != null) {
            this.isGroup_ = Boolean.FALSE;
        } else {
            try {
                type = Class.forName(value);
            }
            catch (Exception x) {
                String message = "Field " + this.name() + ": unknown field type: " + value;
                logger_.error((Object)message, (Throwable)x);
                throw new RuntimeException(message);
            }
            catch (Error x) {
                String message = "Field " + this.name() + ": unknown field type: " + value;
                logger_.error((Object)message, (Throwable)x);
                throw new RuntimeException(message);
            }
            if (StringConverter.canConvert(type)) {
                this.isGroup_ = Boolean.FALSE;
            } else {
                TypeDescriptor typeDescriptor;
                Class<?> clazz = class$12;
                if (clazz == null) {
                    try {
                        clazz = class$12 = Class.forName("gov.va.med.term.access.types.Referenceable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(type) && (typeDescriptor = TypeDescriptor.factory.obtain(type)) != null && !typeDescriptor.isGroup()) {
                    throw new RuntimeException("Field " + this.name() + ": field type not Referenceable" + " or not a group: " + value);
                }
            }
        }
        this.setType(type);
    }

    public void setType(Class value) {
        this.type_ = value;
        Class<?> clazz = class$12;
        if (clazz == null) {
            try {
                clazz = class$12 = Class.forName("gov.va.med.term.access.types.Referenceable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.isReference_ = clazz.isAssignableFrom(value);
    }

    public Class type() {
        return this.type_;
    }

    public boolean isReference() {
        return this.isReference_;
    }

    public String typeName() {
        return this.type_.getName();
    }

    public void setAccessorName(String value) {
        this.accessorName_ = value;
    }

    public void setRequired(boolean value) {
        this.isRequired_ = value;
    }

    public boolean isRequired() {
        return this.isRequired_;
    }

    public void setFrozen(boolean value) {
        this.isFrozen_ = value;
    }

    public boolean isFrozen() {
        return this.isFrozen_;
    }

    public void setSystemAssigned(boolean value) {
        this.isSystemAssigned_ = value;
    }

    public boolean isSystemAssigned() {
        return this.isSystemAssigned_;
    }

    public void setPassword(boolean value) {
        this.isPassword_ = value;
    }

    public boolean isPassword() {
        return this.isPassword_;
    }

    public void setMulti(boolean value) {
        this.isMulti_ = value;
    }

    public boolean isMulti() {
        return this.isMulti_;
    }

    public boolean isGroup() {
        if (this.isGroup_ == null) {
            TypeDescriptor typeDescriptor;
            Class<?> clazz = class$12;
            if (clazz == null) {
                try {
                    clazz = class$12 = Class.forName("gov.va.med.term.access.types.Referenceable");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.isGroup_ = clazz.isAssignableFrom(this.type_) ? Boolean.FALSE : ((typeDescriptor = this.typeDescriptor()) != null && typeDescriptor.isGroup() ? Boolean.TRUE : Boolean.FALSE);
        }
        return this.isGroup_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDescriptor typeDescriptor() {
        if (this.typeDescriptor_ == null && this.checkedTypeDescriptor_ == Boolean.FALSE) {
            Boolean bl = this.checkedTypeDescriptor_;
            synchronized (bl) {
                this.typeDescriptor_ = TypeDescriptor.factory.obtain(this.type_);
            }
        }
        return this.typeDescriptor_;
    }

    public void setDisplayOnList(boolean value) {
        this.displayOnList_ = value;
    }

    public boolean displayOnList() {
        return this.displayOnList_ && !this.isMulti_ && !this.isGroup();
    }

    public void setDisplayOnSearch(boolean value) {
        this.displayOnSearch_ = value;
    }

    public boolean displayOnSearch() {
        return this.displayOnSearch_ && !this.isMulti_;
    }

    public void setDisplayOnView(boolean value) {
        this.displayOnView_ = value;
    }

    public boolean displayOnView() {
        return this.displayOnView_;
    }

    public void setAllowSoundexSearch(boolean value) {
        this.allowSoundexSearch_ = value;
    }

    public boolean allowSoundexSearch() {
        return this.allowSoundexSearch_;
    }

    public void setAllowPatternSearch(boolean value) {
        this.allowPatternSearch_ = value;
    }

    public boolean allowPatternSearch() {
        return this.allowPatternSearch_;
    }

    public void setOwnerFieldName(String value) {
        this.ownerFieldName_ = value;
    }

    public String ownerFieldName() {
        return this.ownerFieldName_;
    }

    public void setReferringFieldName(String value) {
        this.referringFieldName_ = value;
    }

    public String referringFieldName() {
        return this.referringFieldName_;
    }

    public void setMaxLength(int value) {
        this.maxLength_ = value;
    }

    public int maxLength() {
        return this.maxLength_;
    }

    public void setDisplaySize(int value) {
        this.displaySize_ = value;
    }

    public int displaySize() {
        return this.displaySize_ == 0 ? this.maxLength_ : this.displaySize_;
    }

    private Method accessor() {
        if (this.accessor_ == null) {
            try {
                try {
                    this.accessor_ = this.holder_.getMethod(String.valueOf(this.accessorName_) + "Raw", null);
                }
                catch (Exception e) {
                    this.accessor_ = this.holder_.getMethod(this.accessorName_, null);
                }
            }
            catch (Exception x) {
                throw new RuntimeException("Accessor not found for attribute " + this.name_ + ": '" + this.accessorName_ + "'");
            }
        }
        return this.accessor_;
    }

    private Method mutator() {
        if (this.mutator_ == null) {
            String mutatorName = "set" + this.capitalize(this.name_);
            try {
                Class[] params = new Class[]{this.type()};
                this.mutator_ = this.holder_.getMethod(mutatorName, params);
            }
            catch (Exception x) {
                throw new RuntimeException("Mutator not found for attribute " + this.name_ + ": '" + mutatorName + "'");
            }
        }
        return this.mutator_;
    }

    public Object valueFor(Object subject) {
        if (subject == null) {
            return null;
        }
        try {
            return this.accessor().invoke(subject, null);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public String displayValueFor(Object subject) {
        Object oResult = this.valueFor(subject);
        if (oResult == null) {
            return null;
        }
        if (this.isReference_) {
            return ((Referenceable)oResult).getName();
        }
        Class<?> clazz = oResult.getClass();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return Boolean.TRUE.equals(oResult) ? "Y" : "N";
        }
        return oResult.toString();
    }

    public void setValueFor(Object subject, Object value) {
        if (!this.isGroup()) {
            throw new UnsupportedOperationException(String.valueOf(this.name()) + " is not a group field--" + "use gov.va.med.term.access.maint.Input instead");
        }
        Object[] args = new Object[]{value};
        try {
            this.mutator().invoke(subject, args);
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public boolean hasTransforms() {
        return this.transformers_.length != 0;
    }

    public String transformString() {
        return this.transformString_;
    }

    public void setTransforms(String value) {
        this.transformString_ = value;
        StringTokenizer tokenizer = new StringTokenizer(value);
        FieldTransformer[] transformers = new FieldTransformer[tokenizer.countTokens()];
        int i = transformers.length;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            transformers[--i] = FieldTransformer.factory.obtain(token);
        }
        this.transformers_ = transformers;
    }

    public String runTransforms(String input) {
        int i = this.transformers_.length;
        while (--i >= 0) {
            input = this.transformers_[i].transform(input, this.maxLength());
        }
        return input;
    }

    public String defaultValueString() {
        return this.defaultValueString_;
    }

    public void setDefaultValueString(String value) {
        this.defaultValueString_ = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object defaultValue() {
        if (this.defaultValueString_ != null) {
            String string = this.defaultValueString_;
            synchronized (string) {
                if (this.defaultValue_ == null) {
                    try {
                        this.defaultValue_ = StringConverter.fromString(this.defaultValueString_, this.type_);
                    }
                    catch (StringConverter.FormatException x) {
                        throw new IllegalArgumentException("Invalid default value for type " + this.type_.getName() + ": " + this.defaultValueString_);
                    }
                }
            }
        }
        return this.defaultValue_;
    }

    public FieldDescriptor constrainedBy() {
        return this.constrainedBy_;
    }

    public void setConstrainedBy(FieldDescriptor value) {
        this.constrainedBy_ = value;
    }

    public String constrainedByName() {
        return this.constrainedByName_;
    }

    public void setConstrainedByName(String fieldName) {
        this.constrainedByName_ = fieldName;
    }

    public String constrainingTypePath() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.constrainingTypePath_.length) {
            if (i != 0) {
                buffer.append('.');
            }
            buffer.append(this.constrainingTypePath_[i]);
            ++i;
        }
        return buffer.toString();
    }

    public void setConstrainingTypePath(String value) {
        this.constrainingTypePath_ = value != null && value.length() != 0 ? value.split("\\.") : new String[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method[] constrainingTypeMethods() {
        String[] stringArray = this.constrainingTypePath_;
        synchronized (this.constrainingTypePath_) {
            if (this.constrainingTypeMethods_ == null) {
                this.constrainingTypeMethods_ = new Method[this.constrainingTypePath_.length];
                Class<?> c = this.constrainedBy().type();
                int i = 0;
                while (i < this.constrainingTypePath_.length) {
                    try {
                        this.constrainingTypeMethods_[i] = c.getMethod("get" + this.capitalize(this.constrainingTypePath_[i]), null);
                        c = this.constrainingTypeMethods_[i].getReturnType();
                    }
                    catch (Exception x) {
                        throw new RuntimeException("Accessor not found for attribute " + this.constrainingTypePath_[i]);
                    }
                    ++i;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.constrainingTypeMethods_;
        }
    }

    public String constrainedTypePath() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.constrainedTypePath_.length) {
            if (i != 0) {
                buffer.append('.');
            }
            buffer.append(this.constrainedTypePath_[i]);
            ++i;
        }
        return buffer.toString();
    }

    public void setConstrainedTypePath(String value) {
        this.constrainedTypePath_ = value != null && value.length() != 0 ? value.split("\\.") : new String[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Method[] constrainedTypeMethods() {
        String[] stringArray = this.constrainedTypePath_;
        synchronized (this.constrainedTypePath_) {
            if (this.constrainedTypeMethods_ == null) {
                this.constrainedTypeMethods_ = new Method[this.constrainedTypePath_.length];
                Class<?> c = this.type_;
                int i = 0;
                while (i < this.constrainedTypePath_.length) {
                    try {
                        this.constrainedTypeMethods_[i] = c.getMethod("get" + this.capitalize(this.constrainedTypePath_[i]), null);
                        c = this.constrainedTypeMethods_[i].getReturnType();
                    }
                    catch (Exception x) {
                        throw new RuntimeException("Accessor not found for attribute " + this.constrainedTypePath_[i]);
                    }
                    ++i;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.constrainedTypeMethods_;
        }
    }

    public String constrainingKeyStrings(Referenceable object) {
        if (this.constrainedBy() != null) {
            if (this.constrainedTypePath_.length != 0) {
                return this.apply(object, this.constrainedTypeMethods());
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append('_');
            buffer.append(object.getKeyString());
            buffer.append('_');
            return buffer.toString();
        }
        if (this.constrainedDependents().length != 0) {
            FieldDescriptorImpl constrainedField = (FieldDescriptorImpl)this.constrainedDependents()[0];
            if (constrainedField.constrainingTypePath_.length != 0) {
                return this.apply(object, constrainedField.constrainingTypeMethods());
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append('_');
            buffer.append(object.getKeyString());
            buffer.append('_');
            return buffer.toString();
        }
        return null;
    }

    private String apply(Referenceable object, Method[] methods) {
        try {
            int i = 0;
            while (i < methods.length && object != null) {
                object = (Referenceable)methods[i].invoke((Object)object, null);
                ++i;
            }
            if (object == null) {
                return null;
            }
            if (object.getClass().isArray()) {
                int length = Array.getLength(object);
                StringBuffer buffer = new StringBuffer();
                buffer.append('_');
                int i2 = 0;
                while (i2 < length) {
                    Object element = Array.get(object, i2);
                    buffer.append(((Referenceable)element).getKeyString());
                    buffer.append('_');
                    ++i2;
                }
                return buffer.toString();
            }
            return String.valueOf('_') + object.getKeyString() + '_';
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    public void addConstrainedDependent(FieldDescriptorImpl field) {
        FieldDescriptorImpl[] newDependents = new FieldDescriptorImpl[this.constrainedDependents_.length + 1];
        System.arraycopy(this.constrainedDependents_, 0, newDependents, 0, this.constrainedDependents_.length);
        newDependents[this.constrainedDependents_.length] = field;
        this.constrainedDependents_ = newDependents;
    }

    public FieldDescriptor[] constrainedDependents() {
        return this.constrainedDependents_;
    }

    public Role role() {
        return this.role_;
    }

    public void setRole(Role value) {
        this.role_ = value;
    }

    public Relationship relationship() {
        return this.relationship_;
    }

    public void setRelationship(Relationship value) {
        this.relationship_ = value;
    }

    public String associationName() {
        return this.associationName_;
    }

    public void setAssociationName(String value) {
        this.associationName_ = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class association() {
        if (this.associationName_ == null) {
            return null;
        }
        String string = this.associationName_;
        synchronized (string) {
            if (this.association_ == null) {
                this.initializeAssociation_();
            }
        }
        return this.association_;
    }

    private void initializeAssociation_() {
        try {
            this.association_ = Class.forName(this.associationName_);
        }
        catch (Exception x) {
            String message = "Field " + this.name() + ": unknown association class: " + this.associationName_;
            logger_.error((Object)message, (Throwable)x);
            throw new RuntimeException(message, x);
        }
        catch (Error x) {
            String message = "Field " + this.name() + ": unknown association class: " + this.associationName_;
            logger_.error((Object)message, (Throwable)x);
            throw new RuntimeException(message, x);
        }
    }

    public String associationBackRef() {
        return this.associationBackRef_;
    }

    public void setAssociationBackRef(String value) {
        this.associationBackRef_ = value;
    }

    public String associationPeerRef() {
        return this.associationPeerRef_;
    }

    public void setAssociationPeerRef(String value) {
        this.associationPeerRef_ = value;
    }
}

