/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.dataview;

import gov.va.med.term.access.maint.ui.dataview.FieldDescriptor;
import gov.va.med.term.access.maint.ui.dataview.Function;
import gov.va.med.term.access.maint.ui.dataview.TypeDescriptor;
import gov.va.med.term.access.maint.ui.dataview.factory.DefaultRoleMapper;
import gov.va.med.term.access.maint.ui.dataview.factory.RequestAuthorizer;
import gov.va.med.term.access.maint.ui.servlet.IncidentRegistry;
import gov.va.med.term.access.maint.util.Transaction;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SecurityFilter
implements Filter {
    private static Logger logger_;
    private static final DefaultRoleMapper roleMapper_;
    private static TypeDescriptor[] sortedTypes_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.ui.dataview.SecurityFilter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        roleMapper_ = new DefaultRoleMapper();
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        String applicationPackage = filterConfig.getServletContext().getInitParameter("application-package");
        if (applicationPackage == null) {
            throw new ServletException("Deployment Descriptor must specify application-package as a context-param");
        }
        sortedTypes_ = TypeDescriptor.factory.obtain(applicationPackage);
        Arrays.sort(sortedTypes_, SortByName.instance);
    }

    public void destroy() {
    }

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object problem = new ServletException("User is not authorized.");
        try {
            if (this.isAuthorized((HttpServletRequest)request)) {
                chain.doFilter(request, response);
                return;
            }
        }
        catch (Throwable t) {
            problem = t;
        }
        this.forwardToSiteError(request, response, (Throwable)problem);
    }

    private boolean isAuthorized(HttpServletRequest request) throws ServletException {
        boolean isAuthorized = false;
        Transaction txn = null;
        try {
            txn = Transaction.factory.create();
            isAuthorized = this.isAuthorizedInternal(request);
            if (txn.wasRolledBack()) {
                txn.rollback();
            } else {
                txn.commit();
            }
        }
        catch (Throwable e) {
            if (txn != null) {
                try {
                    txn.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new ServletException("Couldn't perform authorization.", e);
        }
        return isAuthorized;
    }

    private boolean isAuthorizedInternal(HttpServletRequest request) throws ServletException {
        Function function;
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("URI: " + request.getRequestURI() + "\n\tServletPath: " + request.getServletPath() + "\n\tPathInfo: " + request.getPathInfo()));
        }
        if ((function = Function.valueOf(request.getServletPath().substring(1))) == null) {
            String msg = "Unknown function: '" + request.getServletPath() + "'";
            logger_.warn((Object)msg);
            throw new ServletException(msg);
        }
        String path = request.getPathInfo().substring(1);
        String[] segments = path.split("/");
        if (segments.length == 0) {
            String msg = "No segments found: '" + path + "'";
            logger_.warn((Object)msg);
            throw new ServletException(msg);
        }
        String datatype = this.segmentName(segments[0]);
        int typeIndex = Arrays.binarySearch(sortedTypes_, datatype, LookupByName.instance);
        if (typeIndex < 0) {
            String msg = "Unknown type: '" + datatype + "'";
            logger_.warn((Object)msg);
            throw new ServletException(msg);
        }
        TypeDescriptor type = sortedTypes_[typeIndex];
        Object subject = null;
        FieldDescriptor relation = null;
        int i = 1;
        while (i < segments.length) {
            if ((i & 1) == 0) {
                String fieldName = this.segmentName(segments[i]);
                relation = type.fieldNamed(fieldName);
                if (relation == null) {
                    String msg = "Unknown relation: '" + fieldName + "'";
                    logger_.warn((Object)msg);
                    throw new ServletException(msg);
                }
            } else {
                String keyString = this.segmentName(segments[i]);
                try {
                    if (i != 1) {
                        type = TypeDescriptor.factory.obtain(relation.type());
                    }
                    subject = type.fromSerializedKey(keyString);
                    relation = null;
                }
                catch (Exception e) {
                    throw new ServletException("Object not found: " + type.name() + " [" + keyString + "]", (Throwable)e);
                }
                if (subject == null) {
                    throw new ServletException("Object not found: " + type.name() + " [" + keyString + "]");
                }
            }
            ++i;
        }
        if (logger_.isInfoEnabled()) {
            logger_.info((Object)("Function: " + function + "\n\tType: " + (type != null ? type.name() : null) + "\n\tSubject: " + subject + "\n\tRelation: " + (relation != null ? relation.name() : null)));
        }
        String role = roleMapper_.toName(function, type, subject, relation);
        return new RequestAuthorizer(request).isAuthorized(role);
    }

    private String segmentName(String segment) {
        int index;
        int n = index = segment != null ? segment.indexOf(58) : -1;
        if (index != -1) {
            return segment.substring(0, index);
        }
        return segment;
    }

    private void forwardToSiteError(ServletRequest request, ServletResponse response, Throwable problem) {
        logger_.error((Object)"Redirecting to SiteError", problem);
        while (problem.getCause() != null) {
            problem = problem.getCause();
        }
        String incidentId = IncidentRegistry.put(problem);
        try {
            RequestDispatcher rd = request.getRequestDispatcher("/SiteError?" + incidentId);
            rd.forward(request, response);
        }
        catch (Exception e) {
            logger_.fatal((Object)"Couldn't forward to SiteError", (Throwable)e);
        }
    }

    private static class SortByName
    implements Comparator {
        public static SortByName instance = new SortByName();

        SortByName() {
        }

        public int compare(Object o1, Object o2) {
            TypeDescriptor descriptor1 = (TypeDescriptor)o1;
            TypeDescriptor descriptor2 = (TypeDescriptor)o2;
            return descriptor1.name().compareTo(descriptor2.name());
        }
    }

    private static class LookupByName
    implements Comparator {
        public static LookupByName instance = new LookupByName();

        LookupByName() {
        }

        public int compare(Object typeDescriptor, Object name) {
            return ((TypeDescriptor)typeDescriptor).name().compareTo(name);
        }
    }
}

