/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.dataview;

import gov.va.med.term.access.maint.ui.Outputter;
import gov.va.med.term.access.maint.ui.dataview.FieldDescriptor;
import gov.va.med.term.access.maint.ui.dataview.PageFunction;
import gov.va.med.term.access.maint.ui.dataview.PageInfo;
import gov.va.med.term.access.maint.ui.dataview.TypeDescriptor;
import gov.va.med.term.access.maint.ui.servlet.Page;
import gov.va.med.term.access.maint.util.UserErrors;
import gov.va.med.term.access.util.Settings;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PageStack
extends Page {
    private static Logger logger_;
    private PageInfo[] pageInfoStack_;
    private PageFunction pageFunction_;
    private int offset_ = 0;
    private String error_ = null;
    private String userName_ = null;
    private String functionName_ = null;
    private Outputter.Factory outputterFactory_;
    private Outputter mainOutputter_;
    private static final int maxRows_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.ui.dataview.PageStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
        Settings settings = Settings.instance();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("gov.va.med.term.access.maint.ui.dataview.PageStack");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String value = settings.value((Class)clazz2, "max.scrolling.rows", "25");
        maxRows_ = Integer.parseInt(value);
    }

    public PageStack(String servletPath, String pathInfo, TypeDescriptor[] types, Outputter mainOutputter, Outputter.Factory outputterFactory) {
        this.functionName_ = servletPath.substring(1);
        this.mainOutputter_ = mainOutputter;
        this.outputterFactory_ = outputterFactory;
        StringBuffer currentURL = new StringBuffer(servletPath.length() + pathInfo.length());
        StringBuffer searchCriteria = new StringBuffer();
        TypeDescriptor prevType = null;
        Object subject = null;
        Object prevSubject = null;
        PageFunction pageFunction = null;
        Vector<PageInfo> stack = new Vector<PageInfo>();
        StringTokenizer tokenizer = new StringTokenizer(pathInfo, "/");
        while (tokenizer.hasMoreTokens()) {
            Outputter outputter;
            StringTokenizer pagetokenizer;
            String tempName;
            TypeDescriptor type = null;
            String page = "1";
            String criteria = "";
            String active = "";
            String orderBy = "";
            String linkName = null;
            if (stack.size() == 0) {
                tempName = tokenizer.nextToken();
                logger_.info((Object)("tempName = " + tempName));
                pagetokenizer = new StringTokenizer(tempName, ":=");
                String typeName = pagetokenizer.nextToken();
                while (pagetokenizer.hasMoreTokens()) {
                    String nextToken = pagetokenizer.nextToken();
                    if (nextToken.equals("p")) {
                        page = pagetokenizer.nextToken();
                    }
                    if (nextToken.equals("c")) {
                        criteria = pagetokenizer.nextToken();
                    }
                    if (nextToken.equals("a")) {
                        active = pagetokenizer.nextToken();
                    }
                    if (!nextToken.equals("o")) continue;
                    orderBy = pagetokenizer.nextToken();
                }
                logger_.info((Object)("criteria = " + criteria + " active = " + active + " orderBy = " + orderBy + " page = " + page));
                int p = Arrays.binarySearch(types, typeName, TypeDescriptorNameComparator.instance);
                if (p < 0) {
                    this.error_ = "Unknown type: '" + typeName + "'";
                    return;
                }
                type = types[p];
                this.userName_ = type.userName();
                currentURL.append('/');
                currentURL.append(typeName);
                if (criteria.length() > 0) {
                    currentURL.append(":c=" + (criteria.indexOf("?") >= 0 ? PageStack.encode(criteria) : criteria));
                    searchCriteria.append(":c=" + criteria);
                }
                if (active.length() > 0) {
                    currentURL.append(":a=" + active);
                    searchCriteria.append(":a=" + active);
                }
                if (orderBy.length() > 0) {
                    currentURL.append(":o=" + orderBy);
                    searchCriteria.append(":o=" + orderBy);
                }
                currentURL.append(":p=" + page);
                searchCriteria.append(":p=" + page);
            } else {
                tempName = tokenizer.nextToken();
                pagetokenizer = new StringTokenizer(tempName, ":=");
                linkName = pagetokenizer.nextToken();
                while (pagetokenizer.hasMoreTokens()) {
                    if (!pagetokenizer.nextToken().equals("p")) continue;
                    page = pagetokenizer.nextToken();
                }
                FieldDescriptor field = prevType.fieldNamed(linkName);
                if (field == null) {
                    this.error_ = "No field '" + linkName + "' in type '" + prevType.name() + "'";
                    return;
                }
                type = TypeDescriptor.factory.obtain(field.type());
                this.userName_ = field.userName();
                currentURL.append('/');
                currentURL.append(linkName);
                currentURL.append(":p=" + page);
                searchCriteria.append(":p=" + page);
            }
            String key = null;
            if (tokenizer.hasMoreTokens()) {
                key = tokenizer.nextToken();
                currentURL.append('/');
                currentURL.append(key);
            }
            if (tokenizer.hasMoreTokens()) {
                pageFunction = PageFunction.factory.obtain("View");
                outputter = this.outputterFactory_.obtain(type.type(), "View");
            } else {
                pageFunction = PageFunction.factory.obtain(this.functionName_);
                outputter = this.outputterFactory_.obtain(type.type(), this.functionName_);
            }
            if (key == null && pageFunction.expectsObject()) {
                this.error_ = "Not enough args";
                return;
            }
            subject = pageFunction.subject(prevType, prevSubject, linkName, type, key != null ? key : searchCriteria.toString());
            PageInfo info = new PageInfo(type, outputter, currentURL.toString(), linkName, subject, page, criteria, active, orderBy);
            prevSubject = info.subject();
            prevType = type;
            stack.addElement(info);
        }
        this.pageInfoStack_ = new PageInfo[stack.size()];
        stack.copyInto(this.pageInfoStack_);
        this.pageFunction_ = pageFunction;
    }

    public PageInfo current() {
        return this.pageInfoStack_[this.offset_];
    }

    public PageInfo next() {
        int next = this.offset_ + 1;
        return next < this.pageInfoStack_.length ? this.pageInfoStack_[next] : null;
    }

    public PageInfo prev() {
        int prev = this.offset_ - 1;
        return prev >= 0 ? this.pageInfoStack_[prev] : null;
    }

    public PageInfo push() {
        return this.pageInfoStack_[++this.offset_];
    }

    public void pop() {
        --this.offset_;
    }

    public boolean canPush() {
        return this.offset_ + 1 < this.pageInfoStack_.length;
    }

    public boolean canPop() {
        return this.offset_ > 0;
    }

    public String error() {
        return this.error_;
    }

    public boolean invalid() {
        return this.error_ != null;
    }

    public PageInfo first() {
        return this.pageInfoStack_[0];
    }

    public PageInfo last() {
        return this.pageInfoStack_[this.pageInfoStack_.length - 1];
    }

    public static final int getMaxRows() {
        return maxRows_;
    }

    public PageInfo penultimate() {
        return this.pageInfoStack_.length > 1 ? this.pageInfoStack_[this.pageInfoStack_.length - 2] : null;
    }

    public String userName() {
        return this.userName_;
    }

    public String functionName() {
        return this.functionName_;
    }

    public Outputter outputter() {
        return this.mainOutputter_;
    }

    public String title() {
        return this.pageFunction_.title(this.last());
    }

    public String successMessage() {
        return this.pageFunction_.successMessage(this.last(), this.penultimate());
    }

    public String nextPage(Dictionary input, String pathInfo) {
        return this.pageFunction_.nextPage(this.last(), input, pathInfo.indexOf("?") >= 0 ? PageStack.encode(pathInfo) : pathInfo);
    }

    public Boolean apply(Dictionary input, UserErrors errors) {
        return this.pageFunction_.apply(this.last(), this.penultimate(), input, errors);
    }

    public Dictionary modifyInput(Dictionary input) {
        return this.pageFunction_.input(input, this.last().type());
    }

    public Object subject() {
        return this.last().subject();
    }

    public String activeLink() {
        int next = this.offset_ + 1;
        return next < this.pageInfoStack_.length ? this.pageInfoStack_[next].linkName() : null;
    }

    private static String encode(String s) {
        try {
            return s.replaceAll("\\?", URLEncoder.encode("?", "UTF-8"));
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException(x);
        }
    }

    private static class TypeDescriptorNameComparator
    implements Comparator {
        public static TypeDescriptorNameComparator instance = new TypeDescriptorNameComparator();

        TypeDescriptorNameComparator() {
        }

        public int compare(Object typeDescriptor, Object name) {
            return ((TypeDescriptor)typeDescriptor).name().compareTo(name);
        }
    }
}

