/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.dataview;

import gov.va.med.term.access.maint.ui.dataview.FieldDescriptor;
import gov.va.med.term.access.maint.ui.dataview.PageFunction;
import gov.va.med.term.access.maint.ui.dataview.PageInfo;
import gov.va.med.term.access.maint.ui.dataview.TypeDescriptor;
import gov.va.med.term.access.maint.util.UserErrors;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Dictionary;
import org.apache.log4j.Logger;

public class PageFunction_Search
extends PageFunction {
    private static Logger logger_;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.va.med.term.access.maint.ui.dataview.PageFunction_Search");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger_ = Logger.getLogger((Class)clazz);
    }

    public String title(PageInfo info) {
        return String.valueOf(info.type().userName()) + " Search";
    }

    public Object subject(TypeDescriptor prevType, Object prevSubject, String linkName, TypeDescriptor type, String serializedKey) {
        return null;
    }

    public Boolean apply(PageInfo info, PageInfo prevInfo, Dictionary input, UserErrors errors) {
        if (input.get("cmd_search") == null) {
            return null;
        }
        TypeDescriptor type = info.type();
        FieldDescriptor[] fields = type.fields();
        int i = 0;
        int j = 1;
        while (i < 4) {
            String searchValue;
            String operator;
            String searchFieldNumber = (String)input.get("searchfield" + j);
            String errorMessage = this.validateCriteria(searchFieldNumber, operator = (String)input.get("searchoperation" + j), searchValue = (String)input.get("searchvalue" + j), fields);
            if (errorMessage != null) {
                logger_.info((Object)("Field: " + searchFieldNumber + " Operator: " + operator + " Value: '" + searchValue + "'"));
                logger_.info((Object)("Invalid search criteria: " + errorMessage));
                errors.put(searchValue, "searchvalue" + j, errorMessage);
            }
            ++i;
            ++j;
        }
        if (errors.isEmpty()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String nextPage(PageInfo info, Dictionary input, String pathInfo) {
        return input.get("cmd_search") == null ? "/List" + pathInfo.split(":")[0] + this.createURL(input) : "/List" + pathInfo.split(":")[0] + this.createURL(input);
    }

    public boolean expectsObject() {
        return false;
    }

    public String validateCriteria(String searchFieldNumber, String operator, String searchValue, FieldDescriptor[] fields) {
        if (searchFieldNumber.equals("0")) {
            if (!operator.equals("0")) {
                return "Operator invalid - no field selected.";
            }
            if (!searchValue.equals("")) {
                return "Value invalid - no field selected.";
            }
            return null;
        }
        try {
            int fieldNumber = Integer.parseInt(searchFieldNumber);
            if (fieldNumber > fields.length) {
                return "Search field not recognized.";
            }
            FieldDescriptor field = fields[fieldNumber];
            int operatorNumber = Integer.parseInt(operator);
            if (operatorNumber < 1 || operatorNumber > 13) {
                return "Operator not recognized.";
            }
            if (operatorNumber == 10) {
                if (searchValue.length() > 0) {
                    return "Null operator does not take a value.";
                }
                if (field.isRequired()) {
                    return "Null is invalid for a required attribute.";
                }
            } else if (searchValue.length() == 0) {
                return "Operator must have a value.";
            }
            if (searchValue.indexOf("/") >= 0 || searchValue.indexOf("\\") >= 0) {
                return "'/' cannot be used in the value field.";
            }
            if (searchValue.indexOf("?") >= 0 && operatorNumber != 8) {
                return "'?' cannot be used in the value field except for LIKE operation.";
            }
            if (searchValue.length() == 1 && searchValue.equals("*") && field.isReference() && operatorNumber == 8) {
                return "'*' cannot be used by itself in the value field for LIKE operation on reference fields.";
            }
            if (searchValue.indexOf("!") >= 0) {
                return "'!' cannot be used in the value field.";
            }
            if (searchValue.indexOf("=") >= 0) {
                return "'=' cannot be used in the value field.";
            }
            if (searchValue.indexOf(":") >= 0) {
                return "':' cannot be used in the value field.";
            }
            Class fieldClass = field.type();
            if (fieldClass.getName().equals("java.lang.String")) {
                if (field.hasTransforms() && searchValue.length() != field.runTransforms(searchValue).length()) {
                    return "Please enter all " + field.maxLength() + " digits.";
                }
                if (searchValue.indexOf("\\") >= 0) {
                    searchValue.replaceAll("\\\\", "\\\\\\\\");
                    logger_.error((Object)"MUST WRITE CONVERSION FOR ESCAPE CHARACTER");
                }
                if (searchValue.indexOf("=") >= 0) {
                    searchValue.replaceAll("=", "\\\\=");
                    logger_.error((Object)"MUST WRITE CONVERSION FOR ASSIGNMENT STRING");
                }
            } else if (fieldClass.getName().equals("java.math.BigDecimal") || fieldClass.getName().equals("java.lang.Double")) {
                if (operatorNumber == 1 || operatorNumber == 3 || operatorNumber == 12 || operatorNumber == 13) {
                    return "The operator is not supported for decimal fields.";
                }
                try {
                    new BigDecimal(searchValue);
                }
                catch (NumberFormatException e) {
                    return "Value must be a valid decimal.";
                }
            } else if (fieldClass.getName().equals("java.lang.Integer") || fieldClass.getName().equals("java.lang.Long")) {
                if (operatorNumber == 1 || operatorNumber == 3 || operatorNumber == 12 || operatorNumber == 13) {
                    return "The operator is not supported for integer fields.";
                }
                try {
                    new Long(searchValue);
                }
                catch (NumberFormatException e) {
                    return "Value must be a valid decimal.";
                }
            } else {
                if (fieldClass.getName().equals("gov.va.med.term.access.types.ImpreciseDate")) {
                    return null;
                }
                if (fieldClass.getName().equals("java.lang.Boolean")) {
                    if (operatorNumber != 2) {
                        return "The operator for Boolean fields must be Equals.";
                    }
                    if (searchValue.length() == 0) {
                        return "Operator for Boolean fields must have a value.";
                    }
                    if (!searchValue.toUpperCase().equals("Y") && !searchValue.toUpperCase().equals("N")) {
                        return "Value for Boolean fields must be a 'Y' or 'N'.";
                    }
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            return "Search field/operator value must be numeric.";
        }
    }

    public String createURL(Dictionary input) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = 1;
        int k = 0;
        while (i < 4) {
            String searchFieldNumber = (String)input.get("searchfield" + j);
            String operator = (String)input.get("searchoperation" + j);
            String searchValue = (String)input.get("searchvalue" + j);
            if (!"0".equals(searchFieldNumber)) {
                if (k == 0) {
                    sb.append(":c=");
                    ++k;
                }
                sb.append("!" + searchFieldNumber);
                sb.append("!" + operator);
                sb.append(searchValue.equals("") ? "!0" : "!" + (searchValue.indexOf("?") >= 0 ? PageFunction_Search.encode(searchValue) : searchValue));
            }
            ++i;
            ++j;
        }
        if (input.get("searchactive") != null) {
            sb.append(":a=");
            sb.append((Object)(input.get("searchactive").equals("") ? "0" : input.get("searchactive")));
        }
        i = 0;
        j = 1;
        k = 0;
        while (i < 4) {
            if (!"0".equals(input.get("sortfield" + j))) {
                if (k == 0) {
                    sb.append(":o=");
                    ++k;
                }
                sb.append("!" + input.get("sortfield" + j));
                sb.append(input.get("sortfield" + j + "Order").equals("") ? "!0" : "!" + input.get("sortfield" + j + "Order"));
            }
            ++i;
            ++j;
        }
        sb.append(":p=1");
        logger_.info((Object)("Search URL = " + sb));
        return sb.toString();
    }

    public static int getFieldNo(FieldDescriptor[] fields, String fieldName) {
        int i = 0;
        while (i < fields.length) {
            if (fields[i].name().equals(fieldName)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException x) {
            throw new RuntimeException(x);
        }
    }
}

