/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.term.access.maint.ui.dataview;

import gov.va.med.term.access.maint.command.Command;
import gov.va.med.term.access.maint.command.Create;
import gov.va.med.term.access.maint.command.Delete;
import gov.va.med.term.access.maint.conversion.Input;
import gov.va.med.term.access.maint.ui.dataview.FieldDescriptor;
import gov.va.med.term.access.maint.ui.dataview.PageFunction;
import gov.va.med.term.access.maint.ui.dataview.PageInfo;
import gov.va.med.term.access.maint.ui.dataview.TypeDescriptor;
import gov.va.med.term.access.maint.util.AuditInfo;
import gov.va.med.term.access.maint.util.Auditable;
import gov.va.med.term.access.maint.util.Maintainable;
import gov.va.med.term.access.maint.util.Transaction;
import gov.va.med.term.access.maint.util.UserErrors;
import gov.va.med.term.access.types.Referenceable;
import java.util.Dictionary;
import java.util.Hashtable;

public class PageFunction_EditAssociation
extends PageFunction {
    private static final Command add_ = new Create();
    private static final Command remove_ = new Delete();

    public String title(PageInfo info) {
        return "Edit " + info.type().userName() + " " + info.linkName();
    }

    public Object subject(TypeDescriptor prevType, Object prevSubject, String linkName, TypeDescriptor type, String serializedKey) {
        return prevType.fieldNamed(linkName).valueFor(prevSubject);
    }

    public Boolean apply(PageInfo info, PageInfo prevInfo, Dictionary input, UserErrors errors) {
        String[] selections;
        Command command;
        Command command2 = input.get("cmd_remove") != null ? remove_ : (command = input.get("cmd_add") != null ? add_ : null);
        if (command == null) {
            return null;
        }
        Maintainable subject = (Maintainable)prevInfo.subject();
        String[] stringArray = selections = command == add_ ? (String[])input.get("multi_unselected") : (String[])input.get("multi_selected");
        if (selections == null || selections.length == 0) {
            return Boolean.TRUE;
        }
        int i = selections.length;
        boolean ok = true;
        FieldDescriptor associationField = prevInfo.type().fieldNamed(info.linkName());
        Hashtable<String, String> individualInput = new Hashtable<String, String>();
        ((Dictionary)individualInput).put(associationField.associationBackRef(), ((Referenceable)subject).getKeyString());
        Transaction transaction = Transaction.factory.create();
        try {
            while (--i >= 0) {
                Maintainable association = (Maintainable)associationField.association().newInstance();
                ((Dictionary)individualInput).put(associationField.associationPeerRef(), selections[i]);
                if (command == add_) {
                    ok = command.apply(association, individualInput, errors);
                } else if (command == remove_) {
                    Input.transfer(individualInput, association, errors);
                    if (!errors.isEmpty()) {
                        transaction.rollback();
                        return Boolean.FALSE;
                    }
                    if (association instanceof Auditable) {
                        ((Auditable)((Object)association)).setAuditInfo(new AuditInfo());
                    }
                    ok = command.apply(association, individualInput, errors);
                }
                if (ok) continue;
                transaction.rollback();
                return Boolean.FALSE;
            }
            transaction.commit();
        }
        catch (RuntimeException x) {
            transaction.rollback();
            throw x;
        }
        catch (Exception x) {
            transaction.rollback();
            throw new RuntimeException(x);
        }
        catch (Error x) {
            transaction.rollback();
            throw new RuntimeException(x);
        }
        return Boolean.TRUE;
    }

    public String nextPage(PageInfo info, Dictionary input, String pathInfo) {
        return String.valueOf(input.get("cmd_add") == null && input.get("cmd_remove") == null ? "/List" : "/EditAssociation") + pathInfo;
    }

    public String successMessage(PageInfo info, PageInfo prevInfo) {
        return String.valueOf(prevInfo.type().userName()) + " " + prevInfo.type().userName(prevInfo.subject()) + " updated.";
    }

    public boolean expectsObject() {
        return false;
    }
}

